/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.Calculate;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class ArticleFragment
extends Fragment
implements NRSearchBarListener,
NRContentView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRArticleView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = ArticleFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRCustomViewAdapter viewAdapter;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private TextView searchContextTextView;
    private LinearLayout noConnectionView;
    private NRApplicationContentListener applicationContentListener;
    private AccountParams accountParams;
    private NRConfiguration configuration;
    private Nanorep nanorepInstance;
    private NanorepUI nanorepUIInstance;
    private NRFetchedDataManager mFetchedDataManager;
    private boolean animation = true;
    private NRCustomChannelView channelView;
    private String articleId;
    private String searchContextValue;
    private NRLabel label;
    private boolean fragmentPaused;
    private long previousClickTime;
    private BaseListView currentView;
    private int y;
    private NRResult currentResult;
    private String url;
    NRCustomContentView contentView;
    private ProgressBar mLoadingView;
    Button clearContextButton;
    private LinearLayout searchContextView;
    private Context context;
    private boolean killedBySystem;
    private boolean linked;
    private int searchContextVisibility = 0;
    private FragmentManager fragmentManager;
    private ViewGroup container;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (!this.animation && view instanceof NRArticleView && !((NRArticleView)view).getResult().isSingle()) {
            ((NRArticleView)view).setResultUnFoldState(false);
            ((NRArticleView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        NRQueryResult currentResult = this.getCurrentResult();
        final String predefinedExtraData = currentResult == null || currentResult.getExtraData() == null ? channel.getNoResultExtra() : this.getCurrentResult().getExtraData();
        this.widgetListener.personalInfoWithExtraData(channel.getChannelDescription(), predefinedExtraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData, predefinedExtraData);
                ArticleFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresenter presenter = NRChannelStrategy.presenter(this.context, channeling, this.nanorepInstance);
        if (presenter instanceof NRCustomScriptChannelPresenter) {
            presenter.present();
        } else {
            String url = presenter.getUrl();
            View view = this.getView();
            if (url != null && this.container != null && view != null && this.fragmentManager != null && this.viewsProvider != null) {
                this.setLoadingState(true);
                final NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, this.viewsProvider, this.widgetListener);
                fragment.setConfirmationDialogsTextProvider(this.configuration.getConfirmationDialogsText(this.getContext()));
                fragment.setListener(new NRWebContentFragment.WebFormListener(){

                    @Override
                    public void onDismiss(String result) {
                        if (result == null) {
                            ArticleFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)ArticleFragment.this.getString(R.string.null_form_result)));
                        }
                        ArticleFragment.this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).remove((Fragment)fragment).commitAllowingStateLoss();
                    }
                });
                this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(this.container.getId(), (Fragment)fragment, NRWebContentFragment.TAG).commit();
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                this.widgetListener.onChannel(NRChanneling.NRChannelingType.PhoneNumber, (Object)phoneNumber);
                String string2 = channeling.getName();
            }
        }
        this.nanorepInstance.reportChanneling(this.getCurrentResult(), channeling);
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(final String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResult.RowType.TITLE);
                int height = Integer.valueOf(ArticleFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(ArticleFragment.this.context, height));
                newResult.setSingle(true);
                ArticleFragment.this.nanorepUIInstance.addToArticleStuck(newResult);
                if (ArticleFragment.this.fragmentManager != null && ArticleFragment.this.container != null) {
                    ArticleFragment.this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).add(ArticleFragment.this.container.getId(), ArticleFragment.newInstance(newResult, ArticleFragment.this.y, ArticleFragment.this.searchContextValue, true), articleId).addToBackStack(ArticleFragment.this.getTag()).commitAllowingStateLoss();
                }
                ArticleFragment.this.requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        this.url = url;
        if (this.accountParams.isOpenLinksInternally()) {
            this.contentView.loadUrl(url);
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onError(NRError error) {
        this.widgetListener.onError(error);
    }

    @Override
    public void onDismiss() {
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }

    @Override
    public void onLikeClicked(NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRQueryResult fetchedResult;
        NRResult result = view.getResult();
        if (result != null && (fetchedResult = result.getFetchedResult()) != null) {
            if (isLike) {
                fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                    public void onLikeSent(boolean success) {
                        if (!success) {
                            fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                            likeView.resetLikeView();
                        } else if (ArticleFragment.this.context != null) {
                            likeView.onFeedbackSubmitted();
                        }
                    }
                });
            } else if (likeView.shouldOpenDialog()) {
                this.openDislikeDialog(fetchedResult, likeView);
            } else {
                this.onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    ArticleFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)5, (String)ArticleFragment.this.getString(R.string.feedback_error_message)));
                } else if (ArticleFragment.this.context != null) {
                    likeView.onFeedbackSubmitted();
                }
            }
        });
    }

    private void onDismissDislike() {
        this.nanorepInstance.updateDislikeChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = ArticleFragment.this.contentMain.getChildAt(ArticleFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                ArticleFragment.this.channelView.setVisibility(0);
                ArticleFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
                ArticleFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)(ArticleFragment.this.getString(R.string.update_channeling_error) + error.getData())));
                ArticleFragment.this.channelView.setVisibility(8);
            }
        });
    }

    private void openDislikeDialog(NRQueryResult fetchedResult, NRCustomLikeView likeView) {
        int dialogType;
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            this.getActivity().getWindow().setSoftInputMode(16);
        }
        if ((dialogType = this.configuration.getFeedbackDialogType()) != -1 && this.context != null && this.viewsProvider != null && this.fragmentManager != null) {
            NRCustomDislikeDialog dislikeDialog = this.viewsProvider.getDislikeDialog(new DislikeConfiguration(this.configuration, (Activity)activity, likeView, fetchedResult){
                final /* synthetic */ Activity val$activity;
                final /* synthetic */ NRCustomLikeView val$likeView;
                final /* synthetic */ NRQueryResult val$fetchedResult;
                {
                    this.val$activity = activity;
                    this.val$likeView = nRCustomLikeView;
                    this.val$fetchedResult = nRQueryResult;
                    super(configuration);
                }

                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener(){

                        @Override
                        public void onCancel() {
                            if (val$activity != null) {
                                val$activity.getWindow().setSoftInputMode(32);
                            }
                            val$likeView.resetLikeView();
                            ArticleFragment.this.onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            if (val$activity != null) {
                                val$activity.getWindow().setSoftInputMode(32);
                            }
                            ArticleFragment.this.onDislike(val$fetchedResult, val$likeView, type, feedbackText);
                        }
                    };
                }
            });
            dislikeDialog.show(this.fragmentManager, "dislike");
        }
    }

    public static Fragment newInstance(NRResult result, int y, String searchContext, boolean linked) {
        ArticleFragment fragment = new ArticleFragment();
        fragment.searchContextValue = searchContext;
        fragment.currentResult = result;
        fragment.y = y;
        fragment.linked = linked;
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private NRArticleView getTopView() {
        NRArticleView resultTopView = new NRArticleView((Context)this.getActivity(), this.viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitleView(this.context);
        if (titleView == null) {
            titleView = new NRArticleTitleView(this.context, this.viewsProvider);
        }
        ((NRArticleTitleView)titleView).configViewObjects(this.configuration);
        this.contentView = this.viewAdapter.getContentView(this.context);
        if (this.contentView == null) {
            this.contentView = new NRContentView(this.context);
        }
        if (this.applicationContentListener != null) {
            this.contentView.setApplicationContentListener(this.applicationContentListener);
        }
        this.contentView.setListener(this);
        NRCustomLikeView likeView = this.viewAdapter.getLikeView(this.context);
        if (likeView == null) {
            likeView = new NRLikeViewText(this.context, this.viewsProvider);
        }
        this.channelView = this.viewAdapter.getChannelView(this.context);
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.context, this.viewsProvider);
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.context);
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(this.contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("url", this.url);
        outState.putString("searchContextValue", this.searchContextValue);
        outState.putBoolean("linked", this.linked);
        Gson gson = new Gson();
        outState.putString("label", gson.toJson((Object)this.nanorepUIInstance.getLabel()));
        this.killedBySystem = true;
        this.nanorepUIInstance.addToArticleStuck(this.currentResult);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.container = container;
        this.fragmentManager = this.getFragmentManager();
        this.killedBySystem = false;
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.getWindow().setSoftInputMode(32);
        }
        this.nanorepInstance = Nanorep.getInstance();
        this.nanorepUIInstance = NanorepUI.getInstance();
        if (savedInstanceState != null) {
            this.url = savedInstanceState.getString("url");
            this.searchContextValue = savedInstanceState.getString("searchContextValue");
            this.linked = savedInstanceState.getBoolean("linked");
            Gson gson = new Gson();
            this.label = (NRLabel)gson.fromJson(savedInstanceState.getString("label"), NRLabel.class);
            this.nanorepUIInstance.setSearchContextValue(this.searchContextValue);
            this.nanorepUIInstance.setLabel(this.label);
            this.nanorepUIInstance.updateDynamicContextValue(this.searchContextValue);
        }
        this.configuration = this.nanorepInstance.getNRConfiguration();
        this.accountParams = this.nanorepInstance.getAccountParams();
        this.context = this.getContext();
        this.mFetchedDataManager = this.nanorepUIInstance.getDataManager();
        this.widgetListener = this.nanorepInstance.getWidgetListener();
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        if (this.viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = this.nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)this.nanorepInstance.getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        View view = inflater.inflate(R.layout.fragment_article, container, false);
        this.contentMain = (FrameLayout)view.findViewById(R.id.article_content_main);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.article_noConnectionView);
        this.searchContextTextView = (TextView)view.findViewById(R.id.article_user_selected_context_textview);
        this.searchContextView = (LinearLayout)view.findViewById(R.id.article_current_user_selected_context_layout);
        this.mLoadingView = (ProgressBar)this.contentMain.findViewById(R.id.article_loadingView);
        this.clearContextButton = (Button)view.findViewById(R.id.article_clear_user_selected_button);
        this.setViews(view);
        this.clearContextButton.setVisibility(this.linked ? 4 : this.searchContextVisibility);
        this.searchContextView.setVisibility(this.searchContextVisibility);
        this.searchContextValue = this.nanorepUIInstance.getSearchContextValue();
        if (this.searchContextValue != null) {
            this.searchContextTextView.setText((CharSequence)this.searchContextValue);
            this.searchContextView.setVisibility(this.searchContextVisibility);
        } else {
            this.searchContextTextView.setText((CharSequence)"");
            this.searchContextView.setVisibility(8);
        }
        this.clearContextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ArticleFragment.this.fragmentManager != null) {
                    ArticleFragment.this.fragmentManager.popBackStack();
                }
            }
        });
        this.label = this.nanorepUIInstance.getLabel();
        NRResult result = this.nanorepUIInstance.getFromArticleStack(this.getTag());
        if (result != null) {
            this.currentResult = result;
        } else {
            result = this.nanorepUIInstance.getFromArticleStack(NanorepUI.NoResults);
            if (result != null) {
                this.currentResult = result;
            }
        }
        this.loadResult(this.y, this.currentResult);
        return view;
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = this.configuration.getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            TextView actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = this.configuration.getTitleText();
            this.setActionBarTitleText(titleText);
            if (!ArticleFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!ArticleFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!ArticleFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = this.configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = this.configuration.getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        int titleBGColor = titleConfig != null && titleConfig.getTitleBGColor() != null && !titleConfig.getTitleBGColor().isEmpty() ? Color.parseColor((String)titleConfig.getTitleBGColor()) : (this.context != null ? this.context.getResources().getColor(R.color.colorPrimary) : Color.parseColor((String)"#0aa0ff"));
        this.searchBarContainer.setBackgroundColor(titleBGColor);
    }

    private void setViews(View nanoView) {
        if (this.context != null && this.viewAdapter != null) {
            this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.article_search_bar_container);
            this.searchBarView = this.viewAdapter.getSearchBar(this.context);
            this.searchBarView.setViewsProvider(this.viewsProvider);
            if (this.searchBarView == null && this.viewsProvider != null) {
                this.searchBarView = new NRSearchBar(this.context, this.viewsProvider.getSearchBarLayout());
            }
            this.searchBarView.setListener(this);
            if (this.searchBarView.getParent() != null) {
                ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
            }
            this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
        }
        if (this.label != null) {
            this.searchBarView.adaptSearchBarDisplay(true, this.label.getTitle(), true);
        }
        this.updateSearchBar();
    }

    public void loadResult(final int y, final NRResult result) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        final NRArticleView resultTopView = this.getTopView();
        if (result != null && result.getFetchedResult() != null && result.getFetchedResult().getBody() == null) {
            this.searchBarView.adaptSearchBarDisplay(true, result.getFetchedResult().getTitle(), true);
            this.articleId = result.getFetchedResult().getId();
            this.mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        resultTopView.setVisibility(8);
                        ArticleFragment.this.contentMain.addView((View)resultTopView);
                        result.setFetchedResult(queryResult);
                        ArticleFragment.this.presentResult(result, y, resultTopView);
                    } else {
                        ArticleFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(8);
            this.contentMain.addView((View)resultTopView);
            this.presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {
        String title;
        this.dismissConnectionError();
        this.setLoadingState(false);
        if (this.context == null) {
            return;
        }
        this.setLoadingState(false);
        if (result != null && result.getFetchedResult() != null) {
            result.setUnfolded(true);
            resultTopView.setVisibility(0);
            resultTopView.openOpenedView(result);
            title = result.getFetchedResult().getTitle();
            if (this.url != null) {
                this.contentView.loadUrl(this.url);
            }
        } else {
            resultTopView.showNoResult(result);
            title = this.getResources().getString(R.string.noResultsTitle);
            resultTopView.setVisibility(0);
        }
        this.updateLabelsParallel(title);
        this.requestFocus();
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        NRResult result;
        NRArticleView articleView = (NRArticleView)view;
        if (articleView != null && (result = articleView.getResult()) != null && result.getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateText(result.getFetchedResult().getTitle(), true);
            this.requestFocus();
        }
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                this.setLoadingState(true);
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                this.nanorepUIInstance.hideKeyboard(this.getView());
            }
        }
    }

    public void dismissConnectionError() {
        this.setLoadingState(false);
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        long threshold = 300L;
        if (currentTime - this.previousClickTime < 300L) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    private void setLoadingState(boolean state) {
        this.mLoadingView.setVisibility(state ? 0 : 8);
    }

    public void updateLabelsParallel(String labelTitle) {
        this.searchBarView.adaptSearchBarDisplay(true, labelTitle, true);
    }

    public void onDestroyView() {
        if (!this.killedBySystem) {
            if (this.label != null) {
                this.nanorepUIInstance.setLabel(this.label);
                this.nanorepUIInstance.updateLabelContext();
            } else {
                this.nanorepUIInstance.clearAllContexts();
            }
            if (this.currentResult.getFetchedResult() != null) {
                this.nanorepUIInstance.removeFromArticleStack(this.currentResult.getFetchedResult().getId());
            } else {
                this.nanorepUIInstance.removeFromArticleStack(NanorepUI.NoResults);
            }
        }
        super.onDestroyView();
    }

    public void onDestroy() {
        this.viewsProvider = null;
        this.widgetListener = null;
        this.configuration = null;
        super.onDestroy();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        FragmentActivity activity;
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
        }
        if ((activity = this.getActivity()) != null) {
            activity.getWindow().setSoftInputMode(32);
        }
    }

    @Override
    public void onClearSearchText() {
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
    }

    @Override
    public void searchForText(String text) {
    }

    @Override
    public void clearAutoComplete() {
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onTopBackButtonPressed() {
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }
}

