/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRQueryResultBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.DataClass.Calculate;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRTitleListener;
import nanorep.nanowidget.interfaces.OnFeedBackListener;

public class NRArticleView
extends RelativeLayout
implements NRTitleListener,
View.OnClickListener,
OnFeedBackListener {
    private Listener topViewListener;
    private NRResult mResult;
    private LinearLayout viewTitleContainer;
    private FrameLayout viewContentContainer;
    private LinearLayout viewLikeContainer;
    private LinearLayout viewChannelingContainer;
    private LinearLayout answerLayout;
    private RelativeLayout layoutAnimated;
    private LinearLayout viewTitleContainerOpened;
    private FrameLayout viewContentContainerOpened;
    private LinearLayout viewFeedbackContainerOpened;
    private LinearLayout viewLikeContainerOpened;
    private LinearLayout viewChannelingContainerOpened;
    private LinearLayout layoutOpened;
    private NRCustomChannelView channelView;
    private NRCustomContentView contentView;
    private NRCustomLikeView likeView;
    private NRCustomTitleView titleView;
    private NRCustomFeedbackView feedbackView;
    private TextView feedBackQuestion;
    private int y;

    @Override
    public void onLikeClicked(NRCustomLikeView likeView, String resultId, boolean isLike) {
        this.topViewListener.onLikeClicked(this, likeView, resultId, isLike);
        if (this.feedbackView != null) {
            this.feedbackView.onLikeClicked(null, null, isLike);
        }
    }

    public void onClick(View v) {
    }

    @Override
    public void onChannelSelected(NRChanneling channeling) {
    }

    public NRArticleView(Context context, @NonNull SearchViewsProvider viewsProvider) {
        super(context);
        if (context != null) {
            View view;
            try {
                view = LayoutInflater.from((Context)context).inflate(viewsProvider.getArticleLayout(), (ViewGroup)this);
            }
            catch (InflateException e) {
                Log.d((String)"InflateError", (String)"Custom Layout failed to be inflated");
                view = LayoutInflater.from((Context)context).inflate(R.layout.nrresult_top_view, (ViewGroup)this);
            }
            this.viewTitleContainer = (LinearLayout)view.findViewById(R.id.title_container);
            this.viewContentContainer = (FrameLayout)view.findViewById(R.id.content_container);
            this.viewLikeContainer = (LinearLayout)view.findViewById(R.id.like_container);
            this.viewChannelingContainer = (LinearLayout)view.findViewById(R.id.channel_container);
            this.answerLayout = (LinearLayout)view.findViewById(R.id.answerLayout);
            this.layoutAnimated = (RelativeLayout)view.findViewById(R.id.layoutAnimated);
            this.layoutAnimated.setOnClickListener((View.OnClickListener)this);
            this.viewTitleContainerOpened = (LinearLayout)view.findViewById(R.id.title_container_opened);
            this.viewContentContainerOpened = (FrameLayout)view.findViewById(R.id.content_container_opened);
            this.viewFeedbackContainerOpened = (LinearLayout)view.findViewById(R.id.feedback_container_opened);
            this.viewLikeContainerOpened = (LinearLayout)view.findViewById(R.id.like_container_opened);
            this.viewChannelingContainerOpened = (LinearLayout)view.findViewById(R.id.channel_container_opened);
            this.layoutOpened = (LinearLayout)view.findViewById(R.id.layoutOpened);
            this.layoutOpened.setOnClickListener((View.OnClickListener)this);
        } else {
            this.removeTopView();
        }
    }

    public void setListener(Listener listener) {
        this.topViewListener = listener;
    }

    public void configViewObjects(NRConfiguration config) {
        String titleBGColor = config.getTitle().getTitleBGColor();
        if (titleBGColor != null && !"".equals(titleBGColor)) {
            this.titleView.setBackgroundColor(Color.parseColor((String)titleBGColor));
        }
    }

    public void setResult(NRResult result) {
        this.mResult = result;
    }

    public void showNoResult(NRResult result) {
        String searchQuery = (String)result.getParams().get("originalSearch");
        this.mResult = result;
        String content = Nanorep.getInstance().getNRConfiguration().getCustomNoAnswersTextContext(searchQuery);
        NRQueryResultBody resultBody = new NRQueryResultBody(content);
        this.contentView.loadDataRAW(resultBody.getBody(), "text/html", "UTF-8");
        this.viewContentContainerOpened.addView((View)this.contentView);
        List<NRChanneling> channels = this.getChanneling(result.getParams());
        if (channels == null || channels.size() == 0) {
            return;
        }
        if (resultBody.getExtraData() != null) {
            for (NRChanneling channel : channels) {
                channel.setNoResultExtra(resultBody.getExtraData());
            }
        }
        this.channelView.setChanneling(channels);
        this.viewChannelingContainerOpened.addView((View)this.channelView);
        this.viewLikeContainerOpened.setVisibility(8);
    }

    public List<NRChanneling> getChanneling(Map<String, Object> params) {
        ArrayList<NRChanneling> channeling;
        ArrayList channels = (ArrayList)params.get("rechanneling");
        if (channels != null && channels.size() > 0) {
            channeling = new ArrayList<NRChanneling>();
            for (HashMap channel : channels) {
                channeling.add(NRChanneling.channelForParams((HashMap)channel));
            }
        } else {
            return null;
        }
        return channeling;
    }

    public void openOpenedView(NRResult result) {
        this.layoutAnimated.setVisibility(8);
        this.mResult = result;
        this.titleView.setTitleText(this.mResult.getFetchedResult().getTitle());
        this.titleView.setTitleMaxLines(100);
        this.titleView.unfold(true);
        this.viewTitleContainerOpened.addView((View)this.titleView);
        this.setContent();
        this.setLike();
        if (this.mResult.getFetchedResult().getChanneling() != null && this.mResult.getFetchedResult().getChanneling().size() > 0) {
            this.setChannel();
        }
        this.viewContentContainerOpened.addView((View)this.contentView);
        if (this.feedbackView == null) {
            this.viewLikeContainerOpened.addView((View)this.likeView);
            if (this.mResult.getFetchedResult().getChanneling() == null || this.mResult.getFetchedResult().getChanneling().size() == 0) {
                this.channelView.setVisibility(8);
            }
            this.viewChannelingContainerOpened.addView((View)this.channelView);
        } else {
            this.viewFeedbackContainerOpened.addView((View)this.feedbackView);
        }
    }

    public void openViewAnimation(int titleHeight) {
        AlphaAnimation fadeInContent = new AlphaAnimation(0.0f, 1.0f);
        fadeInContent.setDuration(700L);
        AlphaAnimation fadeInLike = new AlphaAnimation(0.0f, 1.0f);
        fadeInLike.setDuration(700L);
        fadeInLike.setStartOffset(350L);
        AlphaAnimation fadeInChannel = new AlphaAnimation(0.0f, 1.0f);
        fadeInChannel.setDuration(700L);
        fadeInChannel.setStartOffset(350L);
        this.answerLayout.setTranslationY(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.answerLayout, (String)"TranslationY", (float[])new float[]{titleHeight});
        objectAnimator.setDuration(700L);
        objectAnimator.start();
        this.viewContentContainer.startAnimation((Animation)fadeInContent);
        this.viewLikeContainer.startAnimation((Animation)fadeInLike);
        this.viewChannelingContainer.startAnimation((Animation)fadeInChannel);
    }

    public void closeViewAnimation() {
        AnimationSet replaceAnimation = new AnimationSet(false);
        replaceAnimation.setFillAfter(true);
        AlphaAnimation fadeOutContent = new AlphaAnimation(1.0f, 0.0f);
        fadeOutContent.setDuration(400L);
        this.removeViewListener((Animation)fadeOutContent, (ViewGroup)this.viewContentContainer);
        AlphaAnimation fadeOutLike = new AlphaAnimation(1.0f, 0.0f);
        fadeOutLike.setDuration(400L);
        this.removeViewListener((Animation)fadeOutLike, (ViewGroup)this.viewLikeContainer);
        AlphaAnimation fadeOutChannel = new AlphaAnimation(1.0f, 0.0f);
        fadeOutChannel.setDuration(400L);
        this.removeViewListener((Animation)fadeOutChannel, (ViewGroup)this.viewChannelingContainer);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.answerLayout, (String)"TranslationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        objectAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                NRArticleView.this.titleView.unfold(false);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        objectAnimator.setStartDelay(200L);
        objectAnimator.start();
        this.viewChannelingContainer.startAnimation((Animation)fadeOutChannel);
        this.viewLikeContainer.startAnimation((Animation)fadeOutLike);
        this.viewContentContainer.startAnimation((Animation)fadeOutContent);
    }

    private void removeViewListener(Animation animation, final ViewGroup view) {
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.removeAllViews();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void setChannel() {
        List channelings = this.mResult.getFetchedResult().getChanneling();
        for (NRChanneling channeling : channelings) {
            channeling.setQueryResult(this.mResult.getFetchedResult());
        }
        this.channelView.setChanneling(channelings);
    }

    private void setLike() {
        if (this.mResult.getFetchedResult() == null) {
            return;
        }
        if (this.mResult.getFetchedResult().getLikeState() == NRQueryResult.LikeState.notSelected) {
            this.likeView.resetLikeView();
        } else {
            this.likeView.updateLikeButton(this.mResult.getFetchedResult().getLikeState() == NRQueryResult.LikeState.positive);
        }
    }

    private void setContent() {
        NRQueryResult result = this.mResult.getFetchedResult();
        if (result.getBody() != null && !result.getBody().equals("")) {
            this.contentView.loadData(this.mResult.getFetchedResult().getBody(), "text/html", "UTF-8");
        }
    }

    private void setTitleYAnimation(int start, int end, final boolean isUnfolded) {
        ValueAnimator varl = ValueAnimator.ofInt((int[])new int[]{start, end});
        varl.setDuration(400L);
        varl.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                NRArticleView.this.setPadding(0, (Integer)animation.getAnimatedValue(), 0, 0);
            }
        });
        varl.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (!isUnfolded) {
                    NRArticleView.this.topViewListener.onFoldItemFinished(false);
                } else {
                    NRArticleView.this.titleView.unfold(true);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        varl.start();
    }

    public void removeTopView() {
        if (this.mResult != null && !this.mResult.isSingle()) {
            this.closeViewAnimation();
        } else {
            this.viewChannelingContainer.removeAllViews();
            this.viewLikeContainer.removeAllViews();
            this.viewContentContainer.removeAllViews();
            this.viewTitleContainer.removeAllViews();
            this.viewChannelingContainerOpened.removeAllViews();
            this.viewLikeContainerOpened.removeAllViews();
            this.viewContentContainerOpened.removeAllViews();
            this.viewTitleContainerOpened.removeAllViews();
        }
    }

    @Override
    public void onTitleClicked() {
        if (!this.mResult.isSingle()) {
            this.topViewListener.closeAnswer();
        }
    }

    @Override
    public void onTitleCollapsed(int height) {
        if (this.layoutAnimated.getVisibility() == 0) {
            if (this.mResult.isUnfolded()) {
                int contentHeight;
                int feedbachHeight = 50;
                if (this.mResult.getFetchedResult().getChanneling() != null && this.mResult.getFetchedResult().getChanneling().size() > 0) {
                    feedbachHeight = 100;
                    this.viewChannelingContainer.addView((View)this.channelView);
                    this.viewChannelingContainer.getLayoutParams().height = (int)Calculate.pxFromDp(this.getContext(), 50.0f);
                }
                this.viewContentContainer.addView((View)this.contentView);
                this.viewContentContainer.getLayoutParams().height = contentHeight = this.getHeight() - height - (int)Calculate.pxFromDp(this.getContext(), feedbachHeight);
                this.viewLikeContainer.addView((View)this.likeView);
                this.viewLikeContainer.getLayoutParams().height = (int)Calculate.pxFromDp(this.getContext(), 50.0f);
                this.openViewAnimation(height);
            } else {
                this.viewTitleContainer.getLayoutParams().height = this.mResult.getHeight();
                this.viewTitleContainer.requestLayout();
                this.answerLayout.setTranslationY(0.0f);
                this.topViewListener.onFoldItemFinished(true);
                this.setTitleYAnimation(0, this.y, false);
            }
        }
    }

    @Override
    public void onShareClicked() {
    }

    public void setChannelView(NRCustomChannelView channelView, NRChannelItem.OnChannelSelectedListener listener) {
        this.channelView = channelView;
        this.channelView.setListener(listener);
    }

    public void setContentView(NRCustomContentView contentView, NRContentView.Listener listener) {
        this.contentView = contentView;
        this.contentView.setListener(listener);
    }

    public void setLikeView(NRCustomLikeView likeView) {
        this.likeView = likeView;
        this.likeView.setListener(this);
    }

    public void setTitleView(NRCustomTitleView titleView) {
        this.titleView = titleView;
        this.titleView.setListener(this);
    }

    public void setFeedbackView(NRCustomFeedbackView feedbackView) {
        this.feedbackView = feedbackView;
        this.feedbackView.setListener(this);
    }

    public void removeTitleView() {
        this.viewTitleContainer.removeAllViews();
        this.titleView.resetView();
    }

    public void setResultUnFoldState(boolean unFoldState) {
        this.mResult.setUnfolded(unFoldState);
    }

    public NRResult getResult() {
        return this.mResult;
    }

    public static interface Listener {
        public void onFoldItemFinished(boolean var1);

        public void fetchBodyForResult(NRCustomContentView var1, String var2, Integer var3);

        public void closeAnswer();

        public void onLikeClicked(NRArticleView var1, NRCustomLikeView var2, String var3, boolean var4);
    }
}

