package nanorep.nanowidget.DataClass

import com.nanorep.nanoclient.model.ContextValue
import nanorep.nanowidget.Components.ContextSelectionAdapter

/**
 * Created by obenoved on 01/05/2018.
 */
class ContextSelectionHandler(private var contextValues: ContextValue?, val  listener: ContextSelectionListener)
    : ContextSelectionAdapter.ContextHandlerListener{

    private val contextBuilder: StringBuilder = StringBuilder("")

    override fun onContextSelected(adapterPosition: Int) {
        if (contextValues?.hasSubContext() == true) {

            val subContextForSelection = contextValues?.subContext?.get(adapterPosition)

            contextBuilder.append(contextValues?.contextKey)
                    .append(":")
                    .append(subContextForSelection?.parentContextValue)
                    .append(",")

            val updatedContextValues = subContextForSelection?.values?: arrayListOf()

            if (updatedContextValues.isNotEmpty()) {
                contextValues = subContextForSelection
                listener.updateContextData(contextValues!!)
            } else {
                listener.onContextSelected(contextBuilder.toString())
            }
        } else {
            contextBuilder
                    .append(contextValues?.contextKey).append(":")
                    .append(contextValues?.values?.get(adapterPosition))

            listener.onContextSelected(contextBuilder.toString())
        }
    }

    interface ContextSelectionListener {
        fun onContextSelected(searchContext: String)
        fun updateContextData(contextValues: ContextValue)
    }
}