package nanorep.nanowidget.Components.formSDK.Adapters;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

import nanorep.nanowidget.Components.formSDK.ViewHolders.CheckBoxViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.R;


/**
 * Created by Oz on 7/30/2017.
 */

public class CheckBoxListAdapter
        extends RecyclerView.Adapter<CheckBoxViewHolder> {

    private List<SelectionOptions> checkBoxes;
    private FormFields formField;
    private CheckBoxViewHolder.SelectionHandler selectionHandler;

    public CheckBoxListAdapter(List<SelectionOptions> checkBoxes, FormFields formField, CheckBoxViewHolder.SelectionHandler selectionHandler) {
        this.checkBoxes = checkBoxes;
        this.formField = formField;
        this.selectionHandler = selectionHandler;
    }

    @Override
    public CheckBoxViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.form_view_holder_checkbox, parent, false);
        return new CheckBoxViewHolder(view, formField, selectionHandler);
    }

    @Override
    public void onBindViewHolder(final CheckBoxViewHolder holder, final int position) {
        holder.checkBox.setText(checkBoxes.get(position).getText());
    }

    @Override
    public int getItemCount() {
        return checkBoxes.size();
    }


}

