/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.UriToPathHandler;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

public class NRWebContentFragment
extends Fragment {
    static String TAG = NRWebContentFragment.class.getName();
    private static final String ARG_URL = "param1";
    private static final int FILE_CHOOSER_REQUEST = 100;
    private static final int FILE_CHOOSER_REQUEST_FROM_SCRIPT = 101;
    public static String PERMISSION_GRANTED_BROADCAST = "permissionGranted";
    private static NRChanneling.NRChannelingType fragmentChannelType;
    private WebView mWebView;
    private WebFormListener mListener;
    private WebChromeClient.FileChooserParams mFileChooserParams;
    private RelativeLayout mLoadingView;
    private ArrayList<String> fileUploadPaths;
    private ConfirmationDialogsTextProvider confirmationDialogsTextProvider;
    private String stringUrl;
    private String result;
    private SearchViewsProvider viewsProvider;
    private NRChanneling channel;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private String script = "\n(function(){\n\nfunction overrideComponent(container) {\n  var fileInput = container.querySelector('input[type=\"file\"]'),\n      fileButton = container.querySelector('input[type=\"button\"]'),\n      fileList = container.querySelector('.nr-fileuploader-list');\n\n  fileInput.parentNode.removeChild(fileInput);\n  fileButton.onclick = function() {\n    location.href = 'nanorep://contactForm/attachFile';\n  }\n\n  window.nativeFileAttached = function(fileName) {\n    var row = document.createElement('div'),\n        item = document.createElement('div'),\n        icon = document.createElement('div'),\n        file = document.createElement('span'),\n        btnRemove = document.createElement('a');\n\n    row.className = 'attachmentRow';\n    item.className = 'attachment';\n    icon.className = 'attachmentIcon';\n    btnRemove.className = 'deleteFileLink';\n    file.appendChild(document.createTextNode(fileName))\n\n    btnRemove.onclick = function() {\n      var rowIndex = getRowIndex(row);\n      row.parentNode.removeChild(row);\n      location.href = 'nanorep://contactForm/removeFile?index=' + rowIndex;\n    }\n\n    item.appendChild(icon);\n    item.appendChild(file);\n    item.appendChild(btnRemove);\n    row.appendChild(item);\n    fileList.appendChild(row);\n  }\n\n  function getRowIndex(row) {\n    var index = -1;\n    for (var i = 0; i < fileList.children.length; i++) {\n      if (fileList.children[i] === row) {\n        index = i;\n        break;\n      }\n    }\n    return index;\n  }\n}\n\n\nfunction modifyFormBehavior() {\n  // override file inputs\n  var fileInputs = document.querySelectorAll('.CF_fileUploadComp');\n  for (var i = 0; i < fileInputs.length; i++) {\n    overrideComponent(fileInputs[i]);\n  }\n\n  // override method used in validation\n  nanoRep.BundleManager.define({ name: 'MobileSDK', init: function(container) {\n    var SimpleUploader = container.FileUploader.SimpleUploader\n    SimpleUploader.prototype.getFileList = function() {\n      return document.querySelectorAll('.CF_fileUploadComp .attachmentRow');\n    };\n    SimpleUploader.prototype.getUploadedFiles = function() {\n      return [];\n    }\n  }});    \n}\n\nvar formReadyTimer = setInterval(function() {\n  if (document.querySelector('.CF_fileUploadComp')) {\n    clearTimeout(formReadyTimer);\n    modifyFormBehavior();\n  }\n}, 100);\n\n}());\n";

    public static NRWebContentFragment newInstance(String url, NRChanneling.NRChannelingType channelType) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, url);
        fragmentChannelType = channelType;
        fragment.setArguments(args);
        return fragment;
    }

    public static NRWebContentFragment newInstance(@NonNull String url, @NonNull NRChanneling channeling, @NonNull SearchViewsProvider viewsProvider, @NonNull Nanorep.NanoRepWidgetListener widgetListener) {
        NRWebContentFragment fragment = new NRWebContentFragment();
        fragment.setStringUrl(url);
        fragment.channel = channeling;
        fragment.viewsProvider = viewsProvider;
        fragment.widgetListener = widgetListener;
        return fragment;
    }

    public void setConfirmationDialogsTextProvider(ConfirmationDialogsTextProvider confirmationDialogsTextProvider) {
        this.confirmationDialogsTextProvider = confirmationDialogsTextProvider;
    }

    public void setListener(WebFormListener listener) {
        this.mListener = listener;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_nrweb_content, container, false);
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null) {
                    Intent fileChooserIntent = new Intent("android.intent.action.GET_CONTENT");
                    fileChooserIntent.addCategory("android.intent.category.OPENABLE");
                    fileChooserIntent.setType("image/*");
                    try {
                        NRWebContentFragment.this.startActivityForResult(fileChooserIntent, 101);
                    }
                    catch (ActivityNotFoundException e) {
                        NRWebContentFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)NRWebContentFragment.this.getString(R.string.file_chooser_error)));
                    }
                }
            }
        };
        Context context = this.getContext();
        if (context != null) {
            LocalBroadcastManager lbm = LocalBroadcastManager.getInstance((Context)context);
            lbm.registerReceiver(receiver, new IntentFilter(PERMISSION_GRANTED_BROADCAST));
        }
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.webLoadingView);
        this.mWebView = (WebView)view.findViewById(R.id.webContentView);
        if (savedInstanceState != null) {
            this.mWebView.restoreState(savedInstanceState);
        }
        this.fileUploadPaths = new ArrayList();
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setAllowFileAccess(true);
        this.mWebView.getSettings().setAllowContentAccess(true);
        this.mWebView.getSettings().setAllowFileAccessFromFileURLs(true);
        if (fragmentChannelType == null || fragmentChannelType == NRChanneling.NRChannelingType.ChatForm) {
            this.mWebView.setWebChromeClient(new WebChromeClient(){

                @RequiresApi(api=21)
                public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                    NRWebContentFragment.this.mFileChooserParams = fileChooserParams;
                    FragmentActivity activity = NRWebContentFragment.this.getActivity();
                    if (activity != null) {
                        if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)100);
                        }
                        Intent intent = NRWebContentFragment.this.mFileChooserParams.createIntent();
                        try {
                            NRWebContentFragment.this.startActivityForResult(intent, 100);
                        }
                        catch (ActivityNotFoundException e) {
                            NRWebContentFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)NRWebContentFragment.this.getString(R.string.file_chooser_error)));
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.mWebView.setWebViewClient((WebViewClient)new NRPresentorWebClient());
        }
        try {
            URL url = new URL(this.stringUrl);
            Uri.Builder builder = Uri.parse((String)String.valueOf(url.toURI())).buildUpon();
            NRConnection.connection((Uri.Builder)builder, (OnDataResponse)new OnDataResponse<String>(){

                public void onSuccess(String response) {
                    String html_first_part = response.substring(0, response.indexOf("<script>") + "<script>".length());
                    String html_first_part_with_script = html_first_part + NRWebContentFragment.this.script;
                    String upgradedHtml = html_first_part_with_script + response.substring(html_first_part.length());
                    NRWebContentFragment.this.mWebView.loadDataWithBaseURL(NRWebContentFragment.this.stringUrl, upgradedHtml, "text/html", "UTF-8", "");
                }

                public void onError(NRConnectionException error) {
                    NRWebContentFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)(NRWebContentFragment.this.getString(R.string.form_download_error) + error.getData())));
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.mWebView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    if (event.getAction() == 0) {
                        if (NRWebContentFragment.this.mWebView.canGoBack()) {
                            NRWebContentFragment.this.mWebView.goBack();
                        } else if (NRWebContentFragment.this.mListener != null) {
                            NRWebContentFragment.this.mListener.onDismiss(null);
                        } else {
                            NRWebContentFragment.this.dismissByForce();
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        view.requestFocus();
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data != null && resultCode == -1) {
            Uri fileUploadUri = data.getData();
            this.fileUploadPaths.add(UriToPathHandler.generateFilePathFromUri((Context)this.getContext(), (Uri)fileUploadUri));
            if (requestCode == 101) {
                String fileName = null;
                if (data.getScheme().equals("content")) {
                    try (Cursor cursor = this.getContext().getContentResolver().query(data.getData(), null, null, null, null);){
                        if (cursor != null && cursor.moveToFirst()) {
                            fileName = cursor.getString(cursor.getColumnIndex("_display_name"));
                            this.mWebView.loadUrl("javascript:nativeFileAttached('" + fileName + "'" + ')');
                        }
                    }
                }
            }
        }
    }

    public void onDetach() {
        super.onDetach();
        if (this.mWebView != null) {
            this.mWebView.stopLoading();
            this.mWebView.loadUrl("about:blank");
        }
    }

    public void setStringUrl(String stringUrl) {
        this.stringUrl = stringUrl;
    }

    private int getPermissionsStatus(String permission2, int requestCode) {
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)permission2) != 0) {
            this.requestPermissions(new String[]{permission2}, requestCode);
            return -1;
        }
        return 0;
    }

    private void openFileChooser() {
        Intent fileChooserIntent = new Intent("android.intent.action.GET_CONTENT");
        fileChooserIntent.addCategory("android.intent.category.OPENABLE");
        fileChooserIntent.setType("image/*");
        try {
            this.startActivityForResult(fileChooserIntent, 101);
        }
        catch (ActivityNotFoundException e) {
            this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)this.getString(R.string.file_chooser_error)));
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 101 && grantResults.length > 0 && grantResults[0] == 0) {
            this.openFileChooser();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mWebView.saveState(outState);
    }

    private void dismissByForce() {
        FragmentManager fragmentManager = this.getFragmentManager();
        if (fragmentManager != null) {
            fragmentManager.popBackStack();
            Fragment fragment = fragmentManager.findFragmentByTag(TAG);
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitNowAllowingStateLoss();
            }
        }
    }

    public class NRPresentorWebClient
    extends WebViewClient {
        public void onPageCommitVisible(WebView view, String url) {
            NRWebContentFragment.this.mLoadingView.setVisibility(8);
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            super.onUnhandledKeyEvent(view, event);
        }

        public void onPageFinished(WebView view, String url) {
            NRWebContentFragment.this.mLoadingView.setVisibility(8);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.shouldOverrideUrl(view, url);
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.shouldOverrideUrl(view, request.getUrl().toString());
        }

        private boolean shouldOverrideUrl(WebView webView, String url) {
            String prefix = "nanorep://formData/";
            String prefixContactForm = "nanorep://contactForm";
            Log.d((String)"urlFromScript", (String)url);
            if (url.startsWith("nanorep://formData/")) {
                NRWebContentFragment.this.result = url.startsWith("nanorep://formData/") ? url.substring("nanorep://formData/".length()) : "";
                if (!NRWebContentFragment.this.result.isEmpty()) {
                    Log.i((String)"Form Result: ", (String)NRWebContentFragment.this.result);
                    try {
                        NRWebContentFragment.this.result = URLDecoder.decode(NRWebContentFragment.this.result, "UTF-8");
                        Log.i((String)"Form Result Decoded: ", (String)NRWebContentFragment.this.result);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        NRWebContentFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)NRWebContentFragment.this.getString(R.string.form_decode_error)));
                    }
                } else {
                    NRWebContentFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)NRWebContentFragment.this.getString(R.string.null_form_result)));
                }
                return true;
            }
            if (url.startsWith("nanorep://contactForm")) {
                if (url.contains("attachFile")) {
                    if (NRWebContentFragment.this.getPermissionsStatus("android.permission.READ_EXTERNAL_STORAGE", 101) == 0) {
                        NRWebContentFragment.this.openFileChooser();
                    }
                } else if (url.contains("removeFile")) {
                    Uri uri = Uri.parse((String)url);
                    int fileIndex = Integer.valueOf(uri.getQueryParameter("index"));
                    NRWebContentFragment.this.fileUploadPaths.remove(fileIndex);
                } else if (url.contains("cancel")) {
                    if (NRWebContentFragment.this.mListener != null) {
                        NRWebContentFragment.this.mListener.onDismiss(null);
                    } else {
                        NRWebContentFragment.this.dismissByForce();
                    }
                } else if (url.contains("send") && url.endsWith("result=2")) {
                    Context context = NRWebContentFragment.this.getContext();
                    if (context != null && NRWebContentFragment.this.viewsProvider != null && NRWebContentFragment.this.viewsProvider.showChannelConfirmationDialogs(NRWebContentFragment.this.channel)) {
                        NRWebContentFragment.this.confirmationDialogsTextProvider.setChannelConfirmationDialogBody(NRWebContentFragment.this.channel.getThankYouMessage());
                        View view = LayoutInflater.from((Context)context).inflate(NRWebContentFragment.this.viewsProvider.getConfirmationDialogsView(), null);
                        ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(context, true, view, NRWebContentFragment.this.confirmationDialogsTextProvider);
                        confirmationDialogFragment.setListener(new ConfirmationDialogFragment.OnOkClick(){

                            @Override
                            public void okClicked() {
                                if (NRWebContentFragment.this.widgetListener != null) {
                                    NRWebContentFragment.this.widgetListener.onSubmitSupportForm(NRWebContentFragment.this.result, NRWebContentFragment.this.fileUploadPaths);
                                }
                                if (NRWebContentFragment.this.mListener != null) {
                                    NRWebContentFragment.this.mListener.onDismiss(null);
                                } else {
                                    NRWebContentFragment.this.dismissByForce();
                                }
                            }
                        });
                        confirmationDialogFragment.show();
                    } else {
                        if (NRWebContentFragment.this.widgetListener != null) {
                            NRWebContentFragment.this.widgetListener.onSubmitSupportForm(NRWebContentFragment.this.result, NRWebContentFragment.this.fileUploadPaths);
                        }
                        if (NRWebContentFragment.this.mListener != null) {
                            NRWebContentFragment.this.mListener.onDismiss(null);
                        } else {
                            NRWebContentFragment.this.dismissByForce();
                        }
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    public static interface WebFormListener {
        public void onDismiss(String var1);
    }
}

