package nanorep.nanowidget.Fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.Calculate;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static android.view.View.GONE;
import static android.view.View.VISIBLE;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FEEDBACK;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FORM;
import static com.nanorep.nanoclient.Handlers.NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE;
import static com.nanorep.nanoclient.Response.NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;

public class ArticleFragment extends Fragment implements
        NRSearchBarListener,
        NRContentView.Listener,
        NRChannelItem.OnChannelSelectedListener,
        NRArticleView.Listener,
        NRErrorHandler.Listener {

    public static final String TAG = ArticleFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRCustomViewAdapter viewAdapter;
    
    private SearchViewsProvider viewsProvider;

    private FrameLayout contentMain;

    private Nanorep.NanoRepWidgetListener widgetListener;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private TextView searchContextTextView;

    // no connection
    private LinearLayout noConnectionView;

    private NRApplicationContentListener applicationContentListener;

    private AccountParams accountParams;
    private NRConfiguration configuration;
    private Nanorep nanorepInstance;
    private NanorepUI nanorepUIInstance;
    private NRFetchedDataManager mFetchedDataManager;

    private boolean animation = true;

    private NRCustomChannelView channelView;
    private String articleId;

    private String searchContextValue;

    private NRLabel label;
    //    private NRResult currentResult;
    private boolean fragmentPaused;
    private long previousClickTime;
    private BaseListView currentView;
    private int y;
    private NRResult currentResult;
    private String url;
    NRCustomContentView contentView;
    private ProgressBar mLoadingView;
    Button clearContextButton;
    private LinearLayout searchContextView;
    private Context context;
    private boolean killedBySystem;
    private boolean linked;
    private int searchContextVisibility = VISIBLE;
    private FragmentManager fragmentManager;

    private ViewGroup container;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        // get the last view
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (animation) {
            //view.startAnimation(AnimationUtils.loadAnimation(context, R.anim.slide_out_left));
        } else {
            if (view instanceof NRArticleView && !((NRArticleView) view).getResult().isSingle()) {
                ((NRArticleView) view).setResultUnFoldState(false);
                ((NRArticleView) view).removeTopView();
            }
        }

        contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        final String predefinedExtraData;
        NRQueryResult currentResult = getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {
            predefinedExtraData = channel.getNoResultExtra();
        } else {
            predefinedExtraData = getCurrentResult().getExtraData();
        }

        widgetListener
                .personalInfoWithExtraData(
                        channel.getChannelDescription(),
                        predefinedExtraData,
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channel.setExtraData(extraData, predefinedExtraData);
                                openChannel(channel);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresenter presenter = NRChannelStrategy.presenter(context, channeling, nanorepInstance);

        if (presenter instanceof NRCustomScriptChannelPresenter) {

            presenter.present();

        } else {

            String url = presenter.getUrl();
            View view = getView();

            if (url != null
                    && container != null
                    && view != null
                    && fragmentManager != null
                    && viewsProvider != null) {

                setLoadingState(true);

                final NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, viewsProvider, widgetListener);

                    fragment.setConfirmationDialogsTextProvider(configuration.getConfirmationDialogsText(getContext()));

                    fragment.setListener(new NRWebContentFragment.WebFormListener() {
                        @Override
                        public void onDismiss(String result) {

                            if (result == null) {
                                widgetListener.onError(NRError.error(TAG, FORM, getString(R.string.null_form_result)));
                            }

                            fragmentManager
                                    .beginTransaction()
                                    .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                                    .remove(fragment)
                                    .commitAllowingStateLoss();
                        }
                    });
                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(container.getId(), fragment, NRWebContentFragment.TAG)
                            .commit();

            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                widgetListener.onChannel(PhoneNumber, phoneNumber);
                String channelName = channeling.getName();
//                Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", phoneNumber, null));
//                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
//                try {
//                    startActivity(intent);
//                } catch (ActivityNotFoundException e) {
//
//                }
            }

        }
        nanorepInstance.reportChanneling(getCurrentResult(), channeling);
    }


    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView) view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(final String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {

                NRResult newResult = new NRResult(result, NRResult.RowType.TITLE);
                int height = Integer.valueOf(configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(context, height));
                newResult.setSingle(true);

                nanorepUIInstance.addToArticleStuck(newResult);

                if (fragmentManager != null && container != null) {
                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right)
                            .add(container.getId(), ArticleFragment.newInstance(newResult, y, searchContextValue, true), articleId)
                            .addToBackStack(getTag())
                            .commitAllowingStateLoss();
                }

                requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        this.url = url;
        if (accountParams.isOpenLinksInternally()) {
            contentView.loadUrl(url);
        } else {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            try {
                startActivity(intent);
            } catch (Exception e) {

            }
        }
    }

    @Override
    public void onError(NRError error) {
        widgetListener.onError(error);
    }

    @Override
    public void onDismiss() {
        if (fragmentManager != null) {
            fragmentManager.popBackStack();
        }
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getResult();
        if (result != null) {
            final NRQueryResult fetchedResult = result.getFetchedResult();
            if (fetchedResult != null) {
                if (isLike) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                    mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
                        @Override
                        public void onLikeSent(boolean success) {
                            if (!success) {
                                fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                                likeView.resetLikeView();
                            } else if (context != null) {
                                likeView.onFeedbackSubmitted();
                            }
                        }
                    });
                } else {
                    if (likeView.shouldOpenDialog()) {
                        openDislikeDialog(fetchedResult, likeView);
                    } else {
                        onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
                    }
                }
            }
        }
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    widgetListener.onError(NRError.error(TAG, FEEDBACK, getString(R.string.feedback_error_message)));
                    //removeTopView();
                } else if (context != null) {
                    likeView.onFeedbackSubmitted();
                }
            }
        });
    }

    private void onDismissDislike() {
        // update channeling
        nanorepInstance.updateDislikeChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView) view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.update_channeling_error) + error.getData()));
                channelView.setVisibility(GONE);
            }
        });
    }


    private void openDislikeDialog(final NRQueryResult fetchedResult, final NRCustomLikeView likeView) {

        final Activity activity = getActivity();
        if (activity != null) {
            getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
        }
        final int dialogType = configuration.getFeedbackDialogType();

        if (dialogType != NO_FEEDBACK_DIALOG_TYPE) {
            if (context != null && viewsProvider != null && fragmentManager != null) {
                NRCustomDislikeDialog dislikeDialog = viewsProvider.getDislikeDialog(new DislikeConfiguration(configuration) {
                    @Override
                    public DislikeDialogListener getDislikeDialogListener() {
                        return new DislikeDialogListener() {
                            @Override
                            public void onCancel() {
                                if (activity != null) {
                                    activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
                                }
                                likeView.resetLikeView();
                                ArticleFragment.this.onDismissDislike();
                            }

                            @Override
                            public void onDislike(NRLikeType type, String feedbackText) {
                                if (activity != null) {
                                    activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
                                }
                                ArticleFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                            }
                        };
                    }
                });
                dislikeDialog.show(fragmentManager, "dislike");
            }
        }
    }

    public static Fragment newInstance(NRResult result, int y, String searchContext, boolean linked) {

        ArticleFragment fragment = new ArticleFragment();

        fragment.searchContextValue = searchContext;
        fragment.currentResult = result;
        fragment.y = y;
        fragment.linked = linked;

        return fragment;
    }


    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private NRArticleView getTopView() {

        NRArticleView resultTopView = new NRArticleView(getActivity(), viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = viewAdapter.getTitleView(context);

        if (titleView == null) {
            titleView = new NRArticleTitleView(context, viewsProvider);
        }

        ((NRArticleTitleView) titleView).configViewObjects(configuration);

        contentView = viewAdapter.getContentView(context);

        if (contentView == null) {
            contentView = new NRContentView(context);
        }

        if (applicationContentListener != null) {
            contentView.setApplicationContentListener(applicationContentListener);
        }

        contentView.setListener(this);

        NRCustomLikeView likeView = viewAdapter.getLikeView(context);

        if (likeView == null) {
            likeView = new NRLikeViewText(context, viewsProvider);
        }

        channelView = viewAdapter.getChannelView(context);

        if (channelView == null) {
            channelView = new NRChannelingView(context, viewsProvider);
        }

        NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(context);

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);


        if (feedbackView != null) {
            feedbackView.setCustomChannelView(channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(channelView, this);
        }

        return resultTopView;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("url", url);
        outState.putString("searchContextValue", searchContextValue);
        outState.putBoolean("linked", linked);
        Gson gson = new Gson();
        outState.putString("label", gson.toJson(nanorepUIInstance.getLabel()));
        killedBySystem = true;
        nanorepUIInstance.addToArticleStuck(currentResult);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        this.container = container;
        fragmentManager = getFragmentManager();

        killedBySystem = false;

        Activity activity = getActivity();
        if (activity != null) {
            activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
        }

        nanorepInstance = Nanorep.getInstance();
        nanorepUIInstance = NanorepUI.getInstance();

        if (savedInstanceState != null) {
            url = savedInstanceState.getString("url");
            searchContextValue = savedInstanceState.getString("searchContextValue");
            linked = savedInstanceState.getBoolean("linked");

            Gson gson = new Gson();
            label = gson.fromJson(savedInstanceState.getString("label"), NRLabel.class );

            nanorepUIInstance.setSearchContextValue(searchContextValue);
            nanorepUIInstance.setLabel(label);
            nanorepUIInstance.updateDynamicContextValue(searchContextValue);
        }

        configuration = nanorepInstance.getNRConfiguration();
        accountParams = nanorepInstance.getAccountParams();
        context = getContext();

        mFetchedDataManager = nanorepUIInstance.getDataManager();
        widgetListener = nanorepInstance.getWidgetListener();

        NRErrorHandler.getInstance().setListener(this);

        if (viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider(viewsProvider);
        } else {
            if (nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) nanorepInstance.getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        View view = inflater.inflate(R.layout.fragment_article, container, false);
        contentMain = view.findViewById(R.id.article_content_main);
        noConnectionView = view.findViewById(R.id.article_noConnectionView);
        searchContextTextView = view.findViewById(R.id.article_user_selected_context_textview);
        searchContextView = view.findViewById(R.id.article_current_user_selected_context_layout);
        mLoadingView = contentMain.findViewById(R.id.article_loadingView);
        clearContextButton = view.findViewById(R.id.article_clear_user_selected_button);
        setViews(view);

        clearContextButton.setVisibility(linked? View.INVISIBLE : searchContextVisibility);
        searchContextView.setVisibility(searchContextVisibility);

        searchContextValue = nanorepUIInstance.getSearchContextValue();

        if (searchContextValue != null) {
            searchContextTextView.setText(searchContextValue);
            searchContextView.setVisibility(searchContextVisibility);
        } else {
            searchContextTextView.setText("");
            searchContextView.setVisibility(GONE);
        }

        clearContextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (fragmentManager != null) {
                    fragmentManager.popBackStack();
                }

            }
        });
        
        label = nanorepUIInstance.getLabel();

        NRResult result = nanorepUIInstance.getFromArticleStack(getTag());
        if (result != null) {
            this.currentResult = result;
        } else {
            result = nanorepUIInstance.getFromArticleStack(NanorepUI.NoResults);
            if (result != null) {
                this.currentResult = result;
            }
        }

        loadResult(y, currentResult);

        return view;
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = configuration.getTitle();
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }

            View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

            actionBar.setCustomView(customActionBar, layout);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);

            Toolbar parent = (Toolbar) customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
            parent.setContentInsetsAbsolute(0, 0);

            TextView actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


            // titleConfig text
            String titleText = configuration.getTitleText();
            setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

            // titleConfig color
            if (!isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor(titleColor));
            }

            // titleConfig background color
            if (!isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
            }

            // titleConfig font
            if (!isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = configuration.getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        searchBarView.setViewsProvider(viewsProvider);

        int titleBGColor;

        // titleConfig color
        if (titleConfig != null && titleConfig.getTitleBGColor() != null && !titleConfig.getTitleBGColor().isEmpty()) {
            titleBGColor = Color.parseColor(titleConfig.getTitleBGColor());
        } else if (context != null) {
                titleBGColor = context.getResources().getColor(R.color.colorPrimary);

        } else {
            titleBGColor = Color.parseColor("#0aa0ff");
        }

        searchBarContainer.setBackgroundColor(titleBGColor);
    }

    private void setViews(View nanoView) {

        if (context != null && viewAdapter != null) {

            // search bar
            searchBarContainer = nanoView.findViewById(R.id.article_search_bar_container);

            searchBarView = viewAdapter.getSearchBar(context);
            searchBarView.setViewsProvider(viewsProvider);

            if (searchBarView == null && viewsProvider != null) {
                searchBarView = new NRSearchBar(context, viewsProvider.getSearchBarLayout());
            }

            searchBarView.setListener(this);

            if (searchBarView.getParent() != null) {
                ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
            }

            searchBarContainer.addView(searchBarView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        }

        if (label != null) {
            searchBarView.adaptSearchBarDisplay(true, label.getTitle(), true);
        }

        updateSearchBar();
    }

    public void loadResult(final int y, final NRResult result) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        final NRArticleView resultTopView = getTopView();

        if (result != null && result.getFetchedResult() != null && result.getFetchedResult().getBody() == null) {
            searchBarView.adaptSearchBarDisplay(true, result.getFetchedResult().getTitle(), true);
            this.articleId = result.getFetchedResult().getId();

            mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched() {
                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        resultTopView.setVisibility(GONE);
                        contentMain.addView(resultTopView);
                        result.setFetchedResult(queryResult);
                        presentResult(result, y, resultTopView);
                    } else {
                        showConnectionError(TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(GONE);
            contentMain.addView(resultTopView);
            presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {

        dismissConnectionError();

        setLoadingState(false);

        if (context == null) {
            return;
        }

        setLoadingState(false);

        String title;

        if (result != null && result.getFetchedResult() != null) {
            result.setUnfolded(true);
            resultTopView.setVisibility(VISIBLE);
            //resultTopView.startAnimation(AnimationUtils.loadAnimation(context, R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
            title = result.getFetchedResult().getTitle();

            if (url != null) {
                contentView.loadUrl(url);
            }

        } else {
            resultTopView.showNoResult(result);
            title = getResources().getString(R.string.noResultsTitle);
            resultTopView.setVisibility(VISIBLE);
        }

        updateLabelsParallel(title);

        requestFocus();
    }

    private void requestFocus() {
        View view = getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    private void updateSearchBarTextForResultTop(View view) {

        NRArticleView articleView = (NRArticleView) view;

        if (articleView != null) {
            NRResult result = articleView.getResult();
            if (result != null && result.getFetchedResult() instanceof NRAnswer) {
                searchBarView.updateText(result.getFetchedResult().getTitle(), true);
                requestFocus();
            }
        }
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) { }

    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                setLoadingState(true);
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(VISIBLE);
                    nanorepUIInstance.hideKeyboard(getView());
                }

                break;
        }

    }

    @Override
    public void dismissConnectionError() {
        setLoadingState(false);

        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(GONE);
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        final long threshold = 300;
        if (currentTime - this.previousClickTime < threshold) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    private void setLoadingState(boolean state) {
        mLoadingView.setVisibility(state? VISIBLE : GONE);
    }

    public void updateLabelsParallel(String labelTitle) {
        searchBarView.adaptSearchBarDisplay(true, labelTitle, true);
    }

    @Override
    public void onDestroyView() {
        if (!killedBySystem) {
            if (label != null) {
                nanorepUIInstance.setLabel(label);
                nanorepUIInstance.updateLabelContext();
            } else {
                nanorepUIInstance.clearAllContexts();
            }

            if (currentResult.getFetchedResult() != null) {
                nanorepUIInstance.removeFromArticleStack(currentResult.getFetchedResult().getId());
            } else {
                nanorepUIInstance.removeFromArticleStack(NanorepUI.NoResults);
            }
        }
        super.onDestroyView();
    }

    @Override
    public void onDestroy() {
        viewsProvider = null;
        widgetListener = null;
        configuration = null;

        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            fragmentPaused = false;
        }
        Activity activity = getActivity();
        if (activity != null) {
            activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
        }
    }

    // SearchBar listener:

    @Override
    public void onClearSearchText() {}

    @Override
    public void onStartRecording(ImageButton button) {}

    @Override
    public void fetchSuggestionsForText(String text) {}

    @Override
    public void searchForText(String text) {}

    @Override
    public void clearAutoComplete() {}

    @Override
    public void onEmptyQuery() {}


    @Override
    public void onTopBackButtonPressed() {
        if (fragmentManager != null) {
            fragmentManager.popBackStack();
        }
    }

}   