package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.TextView;

import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;

import nanorep.nanowidget.R;

/**
 * Created by obenoved on 9 Jan 2018.
 */

public class ConfirmationDialogFragment extends AlertDialog.Builder {

    private OnOkClick listener;
    private AlertDialog alert;

    public interface OnOkClick {
        void okClicked();
    }

    public void setListener(OnOkClick listener){
        this.listener = listener;
    }

    public ConfirmationDialogFragment(Context context, Boolean isChannelConfirmationDialog, final View confirmationView, ConfirmationDialogsTextProvider confirmationDialogsTextProvider){
        super(context);
        setView(confirmationView);

        String buttonText;
        String bodyText;
        String titleText;

        TextView titleTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_title);
        TextView bodyTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_text);

        if (confirmationDialogsTextProvider != null) {

            titleText = confirmationDialogsTextProvider.getConfirmationDialogTitle();
            buttonText = confirmationDialogsTextProvider.getConfirmationDialogButton();

            if (isChannelConfirmationDialog) {
                bodyText = confirmationDialogsTextProvider.getChannelConfirmationDialogBody();
            } else {
                bodyText = confirmationDialogsTextProvider.getFeedbackConfirmationDialogBody();
            }

            if (titleText != null) {
                titleTextView.setText(titleText);
            }

            if (bodyText != null) {
                bodyTextView.setText(bodyText);
            }

            if (buttonText == null) {
                buttonText = "ok";
            }

        } else {
            buttonText = "ok";
        }

        setPositiveButton(buttonText, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                alert.dismiss();
                if (listener != null) {
                    listener.okClicked();
                }
            }
        });

        alert = create();

        alert.setCanceledOnTouchOutside(false);
    }
}
