/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRFetcherListener;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.Fragments.ArticleFragment;
import nanorep.nanowidget.Fragments.ResultsFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRLabelsAdapter.NRLabelsListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRErrorHandler.Listener,
NanorepUI.FaqsListener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private ProgressBar mLoadingView;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private FragmentManager fragmentManager;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private String previousQueryText;
    private ArrayList<Spannable> previousSuggestions;
    private boolean autocompleteEnabled = true;
    private LinearLayout noConnectionView;
    private AccountParams accountParams;
    private NRConfiguration configuration;
    private Nanorep nanorepInstance;
    private NanorepUI nanorepUIInstance;
    private NRLabel currentLabel;
    private boolean fragmentPaused;
    private long previousClickTime;
    private boolean killedBySystem;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    public static NRMainFragment newInstance(String context) {
        return new NRMainFragment();
    }

    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();
        fragment.viewsProvider = injector.getUiProvider();
        return fragment;
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private void initDataManager() {
        NRFetcherListener fetcherListener = new NRFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<NRResult> results, String searchContext) {
                if (NRMainFragment.this.isDetached() || NRMainFragment.this.getContext() == null) {
                    return;
                }
                NRMainFragment.this.nanorepUIInstance.hideKeyboard(NRMainFragment.this.getView());
                NRMainFragment.this.clearSuggestionsView();
                NRMainFragment.this.nanorepUIInstance.updateDynamicContextValue(searchContext);
                if (results == null || results.size() == 1 && results.get(0).getFetchedResult() == null) {
                    NRResult result;
                    if (NRMainFragment.this.searchBarView.getSearchQuery() != null) {
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                    }
                    if (results == null) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = results.get(0);
                    }
                    NRMainFragment.this.openArticleFragment(result, ArticleFragment.TAG);
                } else if (results.size() == 1) {
                    NRQueryResult fetchedResult;
                    NRResult currentResult = results.get(0);
                    if (currentResult != null && (fetchedResult = currentResult.getFetchedResult()) != null) {
                        NRResult result = results.get(0);
                        result.setSingle(true);
                        NRMainFragment.this.openArticleFragment(result, fetchedResult.getId());
                        NRMainFragment.this.requestFocus();
                    }
                } else if (results.size() > 1) {
                    NRMainFragment.this.openResultsFragment(results, null, true);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getSearchQuery().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.mSuggestionViewContainer.setVisibility(0);
                    NRMainFragment.this.nanorepInstance.onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)NRMainFragment.this.getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                NRMainFragment.this.nanorepUIInstance.updateDynamicContextValue(null);
                NRMainFragment.this.resetSuggestions = true;
                NRMainFragment.this.clearSuggestionsView();
            }
        };
        this.nanorepUIInstance.initDataManager(new NanorepUI.DataManagerErrorListener(){

            @Override
            public void onError(NRError error) {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                if (error.getCode() == 1) {
                    NRErrorView errorView = new NRErrorView(NRMainFragment.this.getContext());
                    errorView.setListener(new NRErrorView.Listener(){

                        @Override
                        public void tryAgain() {
                            NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                            NRMainFragment.this.mLoadingView.setVisibility(0);
                        }
                    });
                    NRMainFragment.this.contentMain.addView((View)errorView);
                }
            }
        });
        this.mFetchedDataManager = this.nanorepUIInstance.getDataManager(fetcherListener);
        if (this.previousSuggestions != null && this.previousQueryText != null) {
            this.previousQueryText = this.nanorepInstance.getPreviousQueryText();
            this.previousSuggestions = this.nanorepInstance.getPreviousSuggestions();
            fetcherListener.presentSuggestion(this.previousQueryText, this.previousSuggestions);
        }
    }

    private void openArticleFragment(NRResult result, String tag) {
        this.setLoadingState(true);
        this.mLoadingView.setVisibility(0);
        this.nanorepInstance.clearSuggestionsData();
        int container = ((View)this.getView().getParent()).getId();
        this.nanorepUIInstance.addToArticleStuck(result);
        this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).replace(container, ArticleFragment.newInstance(result, 0, this.nanorepUIInstance.getSearchContextValue(), false), tag).addToBackStack(null).commitAllowingStateLoss();
    }

    private void openResultsFragment(List<NRResult> results, String title, boolean animateAndAddToBackStack) {
        int container;
        this.nanorepUIInstance.setResults(results);
        this.setLoadingState(true);
        FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
        if (animateAndAddToBackStack) {
            fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
        }
        if (animateAndAddToBackStack) {
            container = ((View)this.getView().getParent()).getId();
            fragmentTransaction.addToBackStack(null);
        } else {
            container = R.id.categories_content_main;
        }
        fragmentTransaction.replace(container, (Fragment)ResultsFragment.newInstance(this.viewsProvider, results, title), ResultsFragment.TAG);
        fragmentTransaction.commitAllowingStateLoss();
    }

    private void openResultsFragment(boolean animateAndAddToBackStack) {
        int container;
        this.setLoadingState(true);
        FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
        if (animateAndAddToBackStack) {
            fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
        }
        if (animateAndAddToBackStack) {
            container = ((View)this.getView().getParent()).getId();
            fragmentTransaction.addToBackStack(null);
        } else {
            container = R.id.categories_content_main;
        }
        fragmentTransaction.replace(container, (Fragment)ResultsFragment.newInstance(this.viewsProvider), ResultsFragment.TAG);
        fragmentTransaction.commitAllowingStateLoss();
    }

    private void openListView() {
        if (!this.nanorepInstance.getAccountParams().isLabelsMode() && this.fragmentManager.findFragmentByTag(ResultsFragment.TAG) == null) {
            this.openResultsFragment(false);
            return;
        }
        this.nanorepUIInstance.prepareDataSource(new NanorepUI.DataListener(){

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                if (NRMainFragment.this.nanorepInstance.getAccountParams().isLabelsMode()) {
                    NRMainFragment.this.contentMain = (FrameLayout)NRMainFragment.this.getView().findViewById(R.id.categories_content_main);
                    NRMainFragment.this.contentMain.requestFocus();
                    NRMainFragment.this.mLoadingView = (ProgressBar)NRMainFragment.this.contentMain.findViewById(R.id.categories_loadingView);
                    NRMainFragment.this.noConnectionView = (LinearLayout)NRMainFragment.this.getView().findViewById(R.id.categories_noConnectionView);
                    NRMainFragment.this.mLoadingView.setVisibility(8);
                    NRMainFragment.this.setViews(NRMainFragment.this.getView());
                    View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                    if (view instanceof NRErrorView) {
                        NRMainFragment.this.contentMain.removeView(view);
                    }
                    if (NRMainFragment.this.viewsProvider != null) {
                        NRMainFragment.this.categoriesView = new NRCategoriesView((Context)NRMainFragment.this.getActivity(), NRMainFragment.this.viewsProvider.getResultsViewLayout());
                        NRMainFragment.this.categoriesView.setLabelItemTitleView(NRMainFragment.this.viewsProvider.getLabelItemTitleLayout());
                        if (NRMainFragment.this.accountParams.isLabelsMode()) {
                            NRMainFragment.this.categoriesView.initLabelsAdapter(NRMainFragment.this.configuration.getLabels(), NRMainFragment.this);
                        } else {
                            NRMainFragment.this.categoriesView.setCategories(groups, NRMainFragment.this.viewAdapter, NRMainFragment.this);
                        }
                        NRMainFragment.this.setLoadingState(false);
                        NRMainFragment.this.contentMain.addView((View)NRMainFragment.this.categoriesView);
                    }
                    NRMainFragment.this.clearSuggestionsView();
                }
            }

            @Override
            public void onError(NRError error) {
                if (NRMainFragment.this.widgetListener == null) {
                    NRMainFragment.this.widgetListener = NRMainFragment.this.nanorepInstance.getWidgetListener();
                }
                if (NRMainFragment.this.widgetListener != null) {
                    NRMainFragment.this.widgetListener.onError(error);
                }
            }
        });
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.nanorepInstance = Nanorep.getInstance();
        this.nanorepUIInstance = NanorepUI.getInstance();
        this.nanorepUIInstance.setContext(this.getContext());
        this.nanorepUIInstance.setResults(null);
        this.accountParams = this.nanorepInstance.getAccountParams();
        this.widgetListener = this.nanorepInstance.getWidgetListener();
        this.fragmentManager = this.getFragmentManager();
        this.configuration = this.nanorepInstance.getNRConfiguration();
        if (this.viewsProvider != null) {
            this.nanorepInstance.setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = this.nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)this.nanorepInstance.getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_categories, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.initDataManager();
        this.openListView();
    }

    @Override
    public void onClearSearchText() {
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        if (this.categoriesView != null) {
            this.categoriesView.enableAdapterClicks(true);
        }
        this.setLoadingState(false);
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = this.configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = this.configuration.getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        String titleBGColor = !NRMainFragment.isEmpty(titleConfig.getTitleBGColor()) ? titleConfig.getTitleBGColor() : "#0aa0ff";
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = this.configuration.getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            TextView actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = this.configuration.getTitleText();
            this.setActionBarTitleText(titleText);
            if (!NRMainFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = this.accountParams.getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.dismissConnectionError();
        Context context = nanoView.getContext();
        this.mLoadingView.setVisibility(8);
        if (context != null && this.viewAdapter != null) {
            this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.categories_suggestion_view_container);
            this.mSuggestionsView = this.viewAdapter.getSuggestionsView(context);
            if (this.mSuggestionsView == null) {
                this.mSuggestionsView = new NRSuggestionsView(context);
            }
            this.mSuggestionsView.setListener(this);
            if (this.mSuggestionsView.getParent() != null) {
                ((LinearLayout)this.mSuggestionsView.getParent()).removeView((View)this.mSuggestionsView);
            }
            this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
            this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.categories_search_bar_container);
            this.searchBarView = this.viewAdapter.getSearchBar(context);
            if (this.searchBarView == null && this.viewsProvider != null) {
                this.searchBarView = new NRSearchBar(context, this.viewsProvider.getSearchBarLayout());
            }
            this.searchBarView.setListener(this);
            if (this.searchBarView.getParent() != null) {
                ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
            }
            this.searchBarView.presentSuggestions(false);
            this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
        }
        this.updateTitleNormalText();
        this.updateSearchBar();
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        this.clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        this.fragmentManager.popBackStack();
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onSuggestionSelected(String suggestion) {
        this.resetSuggestions = true;
        this.nanorepUIInstance.hideKeyboard(this.getView());
        this.searchBarView.updateText(suggestion, false);
        this.mFetchedDataManager.searchText(suggestion);
        this.clearSuggestionsView();
    }

    private void enableSuggestionsView() {
        if (!this.configuration.getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (localCurrentView instanceof NRArticleView) {
            this.updateSearchBarTextForResultTop(localCurrentView);
        } else {
            if (localCurrentView == null || !(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1) instanceof NRResultsView)) {
                this.searchBarView.updateText("", false);
            }
            String title = this.configuration.getTitleText();
            this.categoriesView.enableAdapterClicks(true);
            this.setActionBarTitleText(this.currentLabel == null ? title : this.currentLabel.getTitle());
        }
        this.requestFocus();
        this.setLoadingState(false);
        if (localCurrentView != null) {
            localCurrentView.setVisibility(0);
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        NRResult result;
        NRArticleView articleView = (NRArticleView)view;
        if (articleView != null && (result = articleView.getResult()) != null && result.getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateText(result.getFetchedResult().getTitle(), true);
            this.resetSuggestions = true;
            this.clearSuggestionsView();
            this.requestFocus();
        }
    }

    private void clearSuggestionsView() {
        if (this.mSuggestionsView != null) {
            this.mSuggestionsView.setSuggestions(null);
        }
        if (this.mSuggestionViewContainer != null) {
            this.mSuggestionViewContainer.setVisibility(8);
        }
    }

    private void fadeViews(View view, float f, long duration, final boolean removeTopTitle) {
        view.animate().alpha(f).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (removeTopTitle) {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, NRResultsAdapter.ViewHolder titleViewHolder) {
        int colorFrom = this.getResources().getColor(R.color.nr_background_color);
        int colorTo = this.getResources().getColor(R.color.white);
        if (!unfold) {
            colorFrom = -1;
            colorTo = this.getResources().getColor(R.color.nr_background_color);
        }
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)milliseconds);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (unfold) {
                    // empty if block
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        if (unfold) {
            colorAnimation.setStartDelay(300L);
        }
        colorAnimation.start();
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                if (this.categoriesView != null) {
                    this.categoriesView.enableAdapterClicks(true);
                }
                this.setLoadingState(true);
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                this.nanorepUIInstance.hideKeyboard(this.getView());
            }
        }
    }

    public void dismissConnectionError() {
        this.setLoadingState(false);
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        if (label.getContext().isEmpty()) {
            this.openResultsFragment(true);
        } else {
            this.nanorepInstance.setContext(label.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

                public void onSuccess(DefaultResponse response) {
                    NRMainFragment.this.nanorepUIInstance.setLabel(label);
                    NRMainFragment.this.nanorepUIInstance.updateLabelContext();
                    NRMainFragment.this.openResultsFragment(true);
                }

                public void onError(NRConnectionException error) {
                    NRMainFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)error.getMessage()));
                }
            });
        }
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        long threshold = 300L;
        if (currentTime - this.previousClickTime < 300L) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        if (this.isBouncing()) {
            return;
        }
        this.openResultsFragment(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.getContext()), groupItem.getTitle(), true);
    }

    private void setLoadingState(boolean state) {
        if (this.categoriesView != null) {
            this.categoriesView.setLoading(state);
        }
    }

    public void updateLabelsParallel(String labelTitle) {
        if (labelTitle != null) {
            this.setActionBarTitleText(labelTitle);
        }
        this.searchBarView.adaptSearchBarDisplay(true, labelTitle, false);
    }

    public void onDestroy() {
        this.viewsProvider = null;
        this.widgetListener = null;
        this.configuration = null;
        this.clearSuggestionsView();
        if (!this.killedBySystem) {
            for (Fragment fragment : this.fragmentManager.getFragments()) {
                this.fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            this.nanorepUIInstance.clearInstance();
        }
        super.onDestroy();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
            NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.killedBySystem = true;
    }

    @Override
    public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
        this.openResultsFragment(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), this.getContext()), groups.get(0).getTitle(), true);
    }
}

