package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.OpenableColumns;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;

import com.nanorep.nanoclient.Handlers.UriToPathHandler;

import java.util.Calendar;
import java.util.List;

import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.DATE_ADDITIONAL_TYPE_ANSWER;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.TIME_ADDITIONAL_TYPE_ANSWER;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.ATTACHMENT;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.GENERAL;

/**
 * Created by Oz on 7/27/2017.
 */

public class PickerViewHolder
        extends FormFieldViewHolder
        implements View.OnClickListener {

    private TextView pickerTitleTextView;
    private TextView pickerDataTextView;
    private ImageView pickerIcon;
    private Calendar correctDataFromCalender;
    private Uri fileUri;
    private FormFields formField;
    private ImageButton clearButton;

    public PickerViewHolder(View itemView, List<FormFields> formFields,
                            FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);

        pickerTitleTextView = itemView.findViewById(R.id.holder_picker_title);
        pickerDataTextView = itemView.findViewById(R.id.holder_picker_data_textview);
        pickerIcon = itemView.findViewById(R.id.holder_picker_imageView);
        ViewGroup pickerLayout = itemView.findViewById(R.id.holder_picker_layout);
        fieldDataLayout = itemView.findViewById(R.id.holder_picker_dataLayout);

        clearButton = itemView.findViewById(R.id.holder_picker_clear_button);

        correctDataFromCalender = Calendar.getInstance();

        pickerLayout.setOnClickListener(this);
        clearButton.setOnClickListener(this);
    }

    @Override
    public void bind() {
        formField = formFields.get(getAdapterPosition());

        if (formField.isRequired() && !formField.isChecked() && isSendClicked()) {
            pickerTitleTextView.requestFocus();
            setFieldError();
        }

        pickerTitleGenerator();

        pickerIconSelector();

        setInitialHint();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.holder_picker_layout) {
            formViewHolderAdapterInteraction.selectFromPickerAndUpdateView(getAdapterPosition(), this);
        } else {
            pickerDataTextView.setText("");
            setInitialHint();
            clearButton.setAlpha(0f);
            formField.setFieldChecked(false);
        }
    }


    private void pickerTitleGenerator() {
        String fieldLabel = formField.getFieldLabel();
        String title;
        if (formField.isDatePickerField()) {
            title = fieldLabel.substring(0, fieldLabel.indexOf('Y'));
        } else if (formField.isTimePickerField()) {
            title = fieldLabel.substring(0, fieldLabel.indexOf('H'));
        } else {
            title = fieldLabel;

        }

        if (title.indexOf("(") > 0) {
            title = title.replace("(", "");
        }

        if (formField.isRequired()) {
            pickerTitleTextView.setText(redStarEnding(title));
        } else {
            pickerTitleTextView.setText(title);
        }
    }

    private void pickerIconSelector() {
        if (formField.isDatePickerField()) {
            pickerIcon.setImageResource(R.drawable.ic_date_range_black_24dp);
        } else if (formField.isTimePickerField()) {
            pickerIcon.setImageResource(R.drawable.ic_access_time_black_24dp);
        } else {
            pickerIcon.setImageResource(R.drawable.ic_attach_file_black_24dp);
        }
    }

    private void setInitialHint() {
        if (formField.isDatePickerField()) {
            pickerDataTextView.setHint(getDateString(correctDataFromCalender.get(Calendar.YEAR), correctDataFromCalender.get(Calendar.MONTH), correctDataFromCalender.get(Calendar.DAY_OF_MONTH)));
        } else if (formField.isTimePickerField()) {
            pickerDataTextView.setHint(getTimeString(correctDataFromCalender.get(Calendar.HOUR_OF_DAY), correctDataFromCalender.get(Calendar.MINUTE)));
        } else {
            pickerDataTextView.setHint(R.string.chooseFile);
        }
    }

    @Override
    public void handleUserInput(FormFields formField) {
        String additionalFieldTypeData;
        if (formField.isDatePickerField() || formField.isTimePickerField()) {
            if (formField.isDatePickerField()) {
                additionalFieldTypeData = DATE_ADDITIONAL_TYPE_ANSWER;
            } else {
                additionalFieldTypeData = TIME_ADDITIONAL_TYPE_ANSWER;
            }
            formField.setUserInput(new UserInput(formField.getFieldLabel(), GENERAL + additionalFieldTypeData, pickerDataTextView.getText().toString(), GENERAL));
        } else {
            String fileNameInput = String.valueOf("0 - " + getFileName(fileUri));
            formField.setUserInput(new UserInput(formField.getFieldLabel(), fileNameInput, "{}", ATTACHMENT));
        }
    }

    @Override
    public void setFieldError() {
        pickerTitleTextView.setError(pickerErrorMessage());
    }

    @Override
    public View getErrorFieldPresenter() {
        return pickerTitleTextView;
    }

    private String pickerErrorMessage() {
        if (formField.isTimePickerField()) {
            return itemView.getContext().getString(R.string.time_error_message);
        } else if (formField.isDatePickerField()) {
            return itemView.getContext().getString(R.string.data_error_message);
        } else {
            return itemView.getContext().getString(R.string.file_error_message);
        }
    }

    public String getTimeString(int hourOfDay, int minute) {
        return ((hourOfDay < 10) ? "0" + hourOfDay : hourOfDay) + ":" + ((minute < 10) ? "0" + minute : minute);
    }

    public String getDateString(int year, int month, int dayOfMonth) {
        return year + "-" + ((month < 10) ? "0" + month : month) + "-" + ((dayOfMonth < 10) ? "0" + dayOfMonth : dayOfMonth);
    }

    public void setPickedDataTextView(String pickedData) {
        pickerDataTextView.setText(pickedData);
    }

    public void setFileUri(Uri fileUri) {
        this.fileUri = fileUri;
    }


    public TextView getPickerTitleTextView() {
        return pickerTitleTextView;
    }

    public String getFileName(Uri uri) {
        String fileName = null;
        Cursor cursor = itemView.getContext().getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    int nameReference = cursor.getColumnIndex(OpenableColumns.DISPLAY_NAME);
                    fileName = cursor.getString(nameReference);
                }
            } finally {
                cursor.close();
            }
        }
        return fileName;
    }

    public String getFilePath(Context context, Uri uri){
        return UriToPathHandler.generateFilePathFromUri(context, uri);
    }


    public TextView getFieldStaticTitle() {
        return pickerTitleTextView;
    }

    public Uri getFileUri() {
        return fileUri;
    }

    public void setPickerTitleTextView(TextView pickerTitleTextView) {
        this.pickerTitleTextView = pickerTitleTextView;
    }

    public FormViewHolderAdapterInteraction getFormViewHolderAdapterInteraction() {
        return formViewHolderAdapterInteraction;
    }

    public void setFormViewHolderAdapterInteraction(FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        this.formViewHolderAdapterInteraction = formViewHolderAdapterInteraction;
    }

    public FormFields getFormField() {
        return formField;
    }

    public void setFormField(FormFields formField) {
        this.formField = formField;
    }

    public Calendar getCorrectDataFromCalender() {
        return correctDataFromCalender;
    }

    public void setCorrectDataFromCalender(Calendar correctDataFromCalender) {
        this.correctDataFromCalender = correctDataFromCalender;
    }

    public ImageButton getClearButton() {
        return clearButton;
    }
}

