/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRFetcherListener;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.Fragments.ArticleFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

public class ResultsFragment
extends Fragment
implements NRSearchBarListener,
NRSuggestionsListener,
NRResultsView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = ResultsFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private ProgressBar mLoadingView;
    private boolean resetSuggestions = false;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private FragmentManager fragmentManager;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private List<NRResult> results;
    private String title;
    private boolean autocompleteEnabled = true;
    private LinearLayout noConnectionView;
    private NRConfiguration configuration;
    private Nanorep nanorepInstance;
    private NanorepUI nanorepUIInstance;
    private boolean fragmentPaused;
    private NRResultsView resultsView;
    private boolean killedBySystem;
    private NRLabel label;

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider, List<NRResult> results, String title) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.viewsProvider = viewsProvider;
        fragment.results = results;
        fragment.title = title;
        return fragment;
    }

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.viewsProvider = viewsProvider;
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        NRFetcherListener fetcherListener = new NRFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<NRResult> results, String searchContext) {
                if (ResultsFragment.this.isDetached() || ResultsFragment.this.getContext() == null) {
                    return;
                }
                ResultsFragment.this.nanorepUIInstance.hideKeyboard(ResultsFragment.this.getView());
                ResultsFragment.this.nanorepUIInstance.updateDynamicContextValue(searchContext);
                String tag = null;
                NRResult result = null;
                if (results == null || results.size() == 1 && results.get(0).getFetchedResult() == null) {
                    if (ResultsFragment.this.searchBarView.getSearchQuery() != null) {
                        while (ResultsFragment.this.contentMain.getChildCount() > 2) {
                            ResultsFragment.this.contentMain.removeViewAt(ResultsFragment.this.contentMain.getChildCount() - 1);
                        }
                    }
                    if (results == null) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = results.get(0);
                    }
                    tag = ArticleFragment.TAG;
                    ResultsFragment.this.openArticleFragment(result, 0, null, tag);
                } else if (results.size() == 1) {
                    NRQueryResult fetchedResult;
                    NRResult currentResult = results.get(0);
                    if (currentResult != null && (fetchedResult = currentResult.getFetchedResult()) != null) {
                        result = results.get(0);
                        result.setSingle(true);
                        tag = result.getFetchedResult().getId();
                        ResultsFragment.this.requestFocus();
                    }
                    ResultsFragment.this.openArticleFragment(result, 0, null, tag);
                } else if (results.size() > 1) {
                    ResultsFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!ResultsFragment.this.resetSuggestions && ResultsFragment.this.searchBarView.getSearchQuery().length() - querytext.length() <= 1 && ResultsFragment.this.autocompleteEnabled) {
                    ResultsFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    ResultsFragment.this.mSuggestionViewContainer.setVisibility(0);
                    ResultsFragment.this.nanorepInstance.onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                ResultsFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)ResultsFragment.this.getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                ResultsFragment.this.nanorepUIInstance.updateDynamicContextValue(null);
                ResultsFragment.this.resetSuggestions = true;
            }
        };
        this.nanorepUIInstance.setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener(){

            @Override
            public void onError(NRError error) {
                ResultsFragment.this.mLoadingView.setVisibility(8);
                if (error.getCode() == 1) {
                    NRErrorView errorView = new NRErrorView(ResultsFragment.this.getContext());
                    errorView.setListener(new NRErrorView.Listener(){

                        @Override
                        public void tryAgain() {
                            ResultsFragment.this.mFetchedDataManager.fetchConfiguration();
                            ResultsFragment.this.mLoadingView.setVisibility(0);
                        }
                    });
                    ResultsFragment.this.contentMain.addView((View)errorView);
                }
            }
        });
        this.mFetchedDataManager = this.nanorepUIInstance.getDataManager(fetcherListener);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.nanorepInstance = Nanorep.getInstance();
        this.nanorepUIInstance = NanorepUI.getInstance();
        this.label = this.nanorepUIInstance.getLabel();
        if (savedInstanceState != null) {
            Gson gson = new Gson();
            this.label = (NRLabel)gson.fromJson(savedInstanceState.getString("label"), NRLabel.class);
            this.nanorepUIInstance.setLabel(this.label);
        }
        this.killedBySystem = false;
        this.nanorepUIInstance.updateDynamicContextValue(null);
        this.configuration = this.nanorepInstance.getNRConfiguration();
        this.widgetListener = this.nanorepInstance.getWidgetListener();
        this.fragmentManager = this.getFragmentManager();
        if (this.viewsProvider != null) {
            this.nanorepInstance.setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = this.nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)this.nanorepInstance.getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_results, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.contentMain = (FrameLayout)view.findViewById(R.id.results_content_main);
        this.mLoadingView = (ProgressBar)this.contentMain.findViewById(R.id.results_loadingView);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.results_noConnectionView);
        this.mLoadingView.setVisibility(0);
        this.initDataManager();
        this.setViews(view);
        this.results = this.nanorepUIInstance.getResults();
        NRLabel label = this.nanorepUIInstance.getLabel();
        if (this.results == null) {
            if (label == null) {
                label = new NRLabel();
            }
            this.nanorepUIInstance.getDataManager().fetchLabelFAQ(label, new NanorepUI.FaqsListener(){

                @Override
                public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
                    if (groups != null) {
                        ResultsFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), ResultsFragment.this.getContext()), groups.get(0).getTitle());
                    } else {
                        ResultsFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                        ResultsFragment.this.mLoadingView.setVisibility(0);
                    }
                }
            });
        } else {
            this.openNRResultView(this.results, this.title);
        }
    }

    private void enableSuggestionsView() {
        if (!this.configuration.getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onClearSearchText() {
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        if (this.resultsView != null) {
            this.resultsView.enableAdapterClicks(true);
        }
        this.setLoadingState(false);
    }

    private void clearSuggestionsView() {
        if (this.mSuggestionsView != null) {
            this.mSuggestionsView.setSuggestions(null);
        }
        if (this.mSuggestionViewContainer != null) {
            this.mSuggestionViewContainer.setVisibility(8);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = this.configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = this.configuration.getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        String titleBGColor = !ResultsFragment.isEmpty(titleConfig.getTitleBGColor()) ? titleConfig.getTitleBGColor() : "#0aa0ff";
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
        if (this.viewsProvider != null && this.label != null && !this.viewsProvider.isSearchBarAlwaysOnTop()) {
            this.searchBarView.adaptSearchBarDisplay(true, this.label.getTitle());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        Context context = nanoView.getContext();
        if (context != null && this.viewAdapter != null) {
            this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.results_suggestion_view_container);
            this.mSuggestionsView = this.viewAdapter.getSuggestionsView(context);
            if (this.mSuggestionsView == null) {
                this.mSuggestionsView = new NRSuggestionsView(context);
            }
            this.mSuggestionsView.setListener(this);
            this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
            this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.results_search_bar_container);
            this.searchBarView = this.viewAdapter.getSearchBar(context);
            if (this.searchBarView == null && this.viewsProvider != null) {
                this.searchBarView = new NRSearchBar(context, this.viewsProvider.getSearchBarLayout());
            }
            this.searchBarView.setListener(this);
            if (this.searchBarView.getParent() != null) {
                ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
            }
            this.searchBarView.presentSuggestions(false);
            this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
            this.updateTitleNormalText();
            this.updateSearchBar();
        }
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        this.clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        this.fragmentManager.popBackStack();
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onSuggestionSelected(String suggestion) {
        this.resetSuggestions = true;
        this.nanorepUIInstance.hideKeyboard(this.getView());
        this.searchBarView.updateText(suggestion, false);
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(suggestion);
    }

    @Override
    public void onResultSelected(int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        this.resetSuggestions = true;
        NRResult result = titleViewHolder.getResult();
        String tag = result != null && result.getFetchedResult() != null ? result.getFetchedResult().getId() : ArticleFragment.TAG;
        this.openArticleFragment(result, y, null, tag);
    }

    private void openArticleFragment(NRResult result, int y, String searchContext, String tag) {
        View view = this.getView();
        this.nanorepInstance.clearSuggestionsData();
        if (view != null) {
            this.mLoadingView.setVisibility(0);
            this.setLoadingState(true);
            int container = ((View)view.getParent()).getId();
            this.nanorepUIInstance.addToArticleStuck(result);
            this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).replace(container, ArticleFragment.newInstance(result, y, searchContext, false), tag).addToBackStack(null).commitAllowingStateLoss();
        }
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view;
                if (this.resultsView != null) {
                    this.resultsView.enableAdapterClicks(true);
                    this.setLoadingState(true);
                }
                if ((view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1)) instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                this.nanorepUIInstance.hideKeyboard(this.getView());
            }
        }
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = this.configuration.getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            TextView actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = this.configuration.getTitleText();
            this.setActionBarTitleText(titleText);
            if (!ResultsFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!ResultsFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!ResultsFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public void dismissConnectionError() {
    }

    private void openNRResultView(List<NRResult> results, String title) {
        try {
            this.nanorepUIInstance.setResults(results);
            View fragmentView = this.getView();
            if (fragmentView != null && this.viewsProvider != null) {
                this.dismissConnectionError();
                this.resultsView = new NRResultsView((Context)this.getActivity());
                this.nanorepUIInstance.hideKeyboard(fragmentView);
                this.resultsView.setListener(this);
                int labelLayout = this.viewsProvider.getLabelItemTitleLayout();
                this.resultsView.setResults(results, title, this.viewAdapter, labelLayout);
                this.resultsView.setIsAnimated(true);
                this.resultsView.enableAdapterClicks(true);
                this.contentMain.requestFocus();
                this.requestFocus();
                this.setLoadingState(false);
                this.mLoadingView.setVisibility(8);
                this.contentMain.addView((View)this.resultsView);
                String queryText = this.nanorepInstance.getPreviousQueryText();
                ArrayList suggestions = this.nanorepInstance.getPreviousSuggestions();
                if (queryText != null && suggestions != null) {
                    this.nanorepUIInstance.getDataManager().getFetcherListener().presentSuggestion(queryText, suggestions);
                }
            }
            this.enableSuggestionsView();
            this.clearSuggestionsView();
        }
        catch (Exception e) {
            this.widgetListener.onError(NRError.error((String)TAG, (int)7, (String)this.getString(R.string.results_view_error)));
        }
    }

    private void setLoadingState(boolean state) {
        this.resultsView.setLoading(state);
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onDestroy() {
        this.viewsProvider = null;
        this.widgetListener = null;
        this.configuration = null;
        this.clearSuggestionsView();
        this.nanorepUIInstance.clearAllContexts();
        this.nanorepUIInstance.setResults(null);
        super.onDestroy();
    }

    public void onStart() {
        super.onStart();
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
        }
        if (this.resultsView != null) {
            this.resultsView.enableAdapterClicks(true);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.killedBySystem = true;
        Gson gson = new Gson();
        outState.putString("label", gson.toJson((Object)this.nanorepUIInstance.getLabel()));
    }
}

