package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRFetcherListener;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

import static android.view.View.GONE;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.ARTICLE;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Handlers.NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE;

public class ResultsFragment extends Fragment implements
        NRSearchBarListener,
        NRSuggestionsListener,
        NRResultsView.Listener,
        NRErrorHandler.Listener {

    public static final String TAG = ResultsFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRFetchedDataManager mFetchedDataManager;

    private NRCustomViewAdapter viewAdapter;

    private ProgressBar mLoadingView;

    private boolean resetSuggestions = false;

    private SearchViewsProvider viewsProvider;

    private FrameLayout contentMain;

    private Nanorep.NanoRepWidgetListener widgetListener;

    private FragmentManager fragmentManager;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private List<NRResult> results;
    private String title;

    private boolean autocompleteEnabled = true;

    // no connection
    private LinearLayout noConnectionView;

    private NRConfiguration configuration;
    private Nanorep nanorepInstance;
    private NanorepUI nanorepUIInstance;

    private boolean fragmentPaused;
    private NRResultsView resultsView;
    private boolean killedBySystem;
    private NRLabel label;

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider, List<NRResult> results, String title) {

        ResultsFragment fragment = new ResultsFragment();

        fragment.viewsProvider = viewsProvider;
        fragment.results = results;
        fragment.title = title;

        return fragment;
    }

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider) {

        ResultsFragment fragment = new ResultsFragment();

        fragment.viewsProvider = viewsProvider;

        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private void initDataManager() {

        NRFetcherListener fetcherListener = new NRFetcherListener() {

            @Override
            public void reloadWithAnimation() {

            }

            @Override
            public void reload() {

            }

            @Override
            public void insertRows(final List<NRResult> results, final String searchContext) {
                if (isDetached() || getContext() == null) {
                    return;
                }

                nanorepUIInstance.hideKeyboard(getView());

                nanorepUIInstance.updateDynamicContextValue(searchContext);

                //String searchContextValue = nanorepUIInstance.getSearchContextValue();

                String tag = null;

                NRResult result = null;

                if (results == null || (results.size() == 1 && results.get(0).getFetchedResult() == null)) {
                    if (searchBarView.getSearchQuery() != null) {
                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    if (results == null) {
                        Map<String, Object> params = new HashMap<>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = results.get(0);
                    }

                    tag = ArticleFragment.TAG;
                    openArticleFragment(result, 0, null, tag);


                } else if (results.size() == 1) {
                    final NRResult currentResult = results.get(0);
                    if (currentResult != null) {
                        final NRQueryResult fetchedResult = currentResult.getFetchedResult();
                        if (fetchedResult != null) {


                            result = results.get(0);

                            result.setSingle(true);

                            tag = result.getFetchedResult().getId();

                            requestFocus();
                        }
                    }
                    openArticleFragment(result, 0, null, tag);

                } else if (results.size() > 1) {
                    openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!resetSuggestions && searchBarView.getSearchQuery().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);
                    mSuggestionViewContainer.setVisibility(View.VISIBLE);
                    nanorepInstance.onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                nanorepUIInstance.updateDynamicContextValue(null);

                resetSuggestions = true;
            }
        };

        nanorepUIInstance.setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener() {
            @Override
            public void onError(NRError error) {
                mLoadingView.setVisibility(GONE);

                if (error.getCode() == CONNECTION) {

                    NRErrorView errorView = new NRErrorView(getContext());
                    errorView.setListener(new NRErrorView.Listener() {
                        @Override
                        public void tryAgain() {
                            mFetchedDataManager.fetchConfiguration();
                            mLoadingView.setVisibility(View.VISIBLE);
                        }
                    });
                    contentMain.addView(errorView);
                }
            }
        });

        mFetchedDataManager = nanorepUIInstance.getDataManager(fetcherListener);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        nanorepInstance = Nanorep.getInstance();
        nanorepUIInstance = NanorepUI.getInstance();

        label = nanorepUIInstance.getLabel();

        if (savedInstanceState != null) {
            Gson gson = new Gson();

            label = gson.fromJson(savedInstanceState.getString("label"), NRLabel.class );
            nanorepUIInstance.setLabel(label);
        }

        killedBySystem = false;

        nanorepUIInstance.updateDynamicContextValue(null);
        
        configuration = nanorepInstance.getNRConfiguration();
        widgetListener = nanorepInstance.getWidgetListener();
        fragmentManager = getFragmentManager();

        if (viewsProvider != null) {
            nanorepInstance.setSearchViewsProvider(viewsProvider);
        } else {
            if (nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) nanorepInstance.getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        NRErrorHandler.getInstance().setListener(this);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_results, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        contentMain = view.findViewById(R.id.results_content_main);
        mLoadingView = contentMain.findViewById(R.id.results_loadingView);
        noConnectionView = view.findViewById(R.id.results_noConnectionView);

        mLoadingView.setVisibility(View.VISIBLE);

        initDataManager();

        setViews(view);

        results = nanorepUIInstance.getResults();

        NRLabel label = nanorepUIInstance.getLabel();

        if (results == null) {
            if (label == null) {
                label = new NRLabel();
            }
            nanorepUIInstance.getDataManager().fetchLabelFAQ(label, new NanorepUI.FaqsListener() {
                @Override
                public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
                    if (groups != null) {
                        openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), getContext()), groups.get(0).getTitle());
                    } else {
                        showConnectionError(TIMEOUT_UPPER_LINE);
                        mLoadingView.setVisibility(View.VISIBLE);
                    }
                }
            });
        } else {
            openNRResultView(results, title);
        }

    }

    private void enableSuggestionsView() {
        if (!configuration.getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    @Override
    public void onClearSearchText() {

        //nanorepUIInstance.clearAllContexts();

        resetSuggestions = true;

        clearSuggestionsView();

        if (resultsView != null) {
            resultsView.enableAdapterClicks(true);
        }

        setLoadingState(false);
    }

    private void clearSuggestionsView() {
        if (mSuggestionsView != null) {
            mSuggestionsView.setSuggestions(null);
        }

        if (mSuggestionViewContainer != null) {
            mSuggestionViewContainer.setVisibility(GONE);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = configuration.getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        searchBarView.setViewsProvider(viewsProvider);

        String titleBGColor;

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        } else {
            titleBGColor = "#0aa0ff";
        }

        searchBarContainer.setBackgroundColor(Color.parseColor(titleBGColor));

        if (viewsProvider != null && label != null && !viewsProvider.isSearchBarAlwaysOnTop()) {
            searchBarView.adaptSearchBarDisplay(true, label.getTitle());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {

        Context context = nanoView.getContext();

        if (context != null && viewAdapter != null) {
            // suggestion view
            mSuggestionViewContainer = nanoView.findViewById(R.id.results_suggestion_view_container);

            mSuggestionsView = viewAdapter.getSuggestionsView(context);

            if (mSuggestionsView == null) {
                mSuggestionsView = new NRSuggestionsView(context);
            }

            mSuggestionsView.setListener(this);

            mSuggestionViewContainer.addView(mSuggestionsView);

            // search bar
            searchBarContainer = nanoView.findViewById(R.id.results_search_bar_container);

            searchBarView = viewAdapter.getSearchBar(context);

            if (searchBarView == null && viewsProvider != null) {
                searchBarView = new NRSearchBar(context, viewsProvider.getSearchBarLayout());
            }

            searchBarView.setListener(this);

            if (searchBarView.getParent() != null) {
                ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
            }

            searchBarView.presentSuggestions(false);

            searchBarContainer.addView(searchBarView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

            updateTitleNormalText();
            updateSearchBar();

        }
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        resetSuggestions = true;
        clearSuggestionsView();
        mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        fragmentManager.popBackStack();
    }

    @Override
    public void onEmptyQuery() {

    }

    @Override
    public void onSuggestionSelected(String suggestion) {
        resetSuggestions = true;

        nanorepUIInstance.hideKeyboard(getView());

        searchBarView.updateText(suggestion, false);

        clearSuggestionsView();

        mFetchedDataManager.searchText(suggestion);
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {

        String tag;

        resetSuggestions = true;

        NRResult result = titleViewHolder.getResult();
        if (result != null && result.getFetchedResult() != null) {
            tag = result.getFetchedResult().getId();
        } else {
            tag = ArticleFragment.TAG;

        }

        openArticleFragment(result, y, null, tag);
    }

    private void openArticleFragment(NRResult result, int y, String searchContext, String tag) {

        View view = getView();

        nanorepInstance.clearSuggestionsData();

        if (view != null) {
            mLoadingView.setVisibility(View.VISIBLE);
            setLoadingState(true);

            int container = ((View) view.getParent()).getId();

            nanorepUIInstance.addToArticleStuck(result);

            fragmentManager
                    .beginTransaction()
                    .setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right)
                    .replace(container, ArticleFragment.newInstance(result, y, searchContext, false), tag)
                    .addToBackStack(null)
                    .commitAllowingStateLoss();
        }
    }

    private void requestFocus() {
        View view = getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                if (resultsView != null) {
                    resultsView.enableAdapterClicks(true);
                    setLoadingState(true);
                }
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                    nanorepUIInstance.hideKeyboard(getView());
                }

                break;
        }
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = configuration.getTitle();
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }

            View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

            actionBar.setCustomView(customActionBar, layout);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);

            Toolbar parent = (Toolbar) customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
            parent.setContentInsetsAbsolute(0, 0);

            TextView actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


            // titleConfig text
            String titleText = configuration.getTitleText();
            setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

            // titleConfig color
            if (!isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor(titleColor));
            }

            // titleConfig background color
            if (!isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
            }

            // titleConfig font
            if (!isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    @Override
    public void dismissConnectionError() { }

    private void openNRResultView(List<NRResult> results, String title) {
        try {

            nanorepUIInstance.setResults(results);

            View fragmentView = getView();

            if (fragmentView != null && viewsProvider != null) {

                dismissConnectionError();

                resultsView = new NRResultsView(getActivity());

                nanorepUIInstance.hideKeyboard(fragmentView);

                resultsView.setListener(ResultsFragment.this);

                int labelLayout = viewsProvider.getLabelItemTitleLayout();

                resultsView.setResults(results, title, viewAdapter, labelLayout);

                resultsView.setIsAnimated(true);
                resultsView.enableAdapterClicks(true);

                contentMain.requestFocus();

                requestFocus();

                setLoadingState(false);
                mLoadingView.setVisibility(GONE);

                contentMain.addView(resultsView);

                String queryText = nanorepInstance.getPreviousQueryText();
                ArrayList<Spannable> suggestions = nanorepInstance.getPreviousSuggestions();

                if (queryText != null && suggestions != null) {
                    nanorepUIInstance.getDataManager().getFetcherListener().presentSuggestion(queryText, suggestions);
                }
            }

            enableSuggestionsView();
            clearSuggestionsView();

        } catch(Exception e){
            widgetListener.onError(NRError.error(TAG, ARTICLE, getString(R.string.results_view_error)));
        }
    }

    private void setLoadingState(boolean state) {
        resultsView.setLoading(state);
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onDestroy() {
        viewsProvider = null;
        widgetListener = null;
        configuration = null;
        clearSuggestionsView();
        nanorepUIInstance.clearAllContexts();
        nanorepUIInstance.setResults(null);

        super.onDestroy();
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            fragmentPaused = false;
        }

        if (resultsView != null) {
            resultsView.enableAdapterClicks(true);
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        killedBySystem = true;

        Gson gson = new Gson();
        outState.putString("label", gson.toJson(nanorepUIInstance.getLabel()));
    }
}
