package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.GENERIC;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.RADIO_LIST;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.SELECT_BOX;

/**
 * Created by Oz on 7/20/2017.
 */

public class SpinnerViewHolder
        extends FormFieldViewHolder {

    private Spinner spinner;
    private TextView fieldTitle;
    private TextView selectedItemText;
    private int selectedPosition;

    public SpinnerViewHolder(View itemView, List<FormFields> formFields,
                             FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);
        fieldTitle = itemView.findViewById(R.id.holder_field_title);
        spinner = itemView.findViewById(R.id.holder_spinner);
        fieldDataLayout = (LinearLayout) itemView.findViewById(R.id.holder_spinner_dataLayout);
    }

    @Override
    public void bind() {
        final FormFields formField = formFields.get(getAdapterPosition());
        final List<SelectionOptions> options = formField.getSelectionOptions();

        if (formField.isRequired() && !formField.isChecked() && isSendClicked()) {
            fieldTitle.requestFocus();
            setFieldError();
        }

        if (String.valueOf(options.get(0)).contains("Please select")) {
            options.remove(0);
            options.add(0, new SelectionOptions());
        }

        final ArrayAdapter<String> spinnerArrayAdapter =
                new ArrayAdapter<>(itemView.getContext(), R.layout.form_simple_spinner_item, getSelectionOptionsStrings(options));
        spinner.setAdapter(spinnerArrayAdapter);
        spinner.setSelection(selectedPosition);

        if (formField.isRequired()) {
            fieldTitle.setText(redStarEnding(formField.getFieldLabel()));
        } else {
            fieldTitle.setText(formField.getFieldLabel());
        }
        spinner.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                selectedItemText = (TextView) view;
                if (selectedItemText.getText().length() > 0) {
                    selectedPosition = position;
                    selectedItemText.setTextColor(itemView.getResources().getColor(R.color.blue_background));

                    for (int i = 0; i < options.size(); i++) {
                        if (i != position) {
                            formField.getSelectionOptions().get(i).setSelected(false);
                        }
                    }
                    options.get(position).setSelected(true);
                    formField.setFieldChecked(true);
                    formField.setValid(true);
                    fieldTitle.setError(null);
                } else {
                    formField.setFieldChecked(false);
                }
                handleUserInput(formField);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

                if (selectedItemText.getText().length() == 0) {
                    formField.setFieldChecked(false);
                }

            }
        });
    }

    private List<String> getSelectionOptionsStrings(List<SelectionOptions> options) {
        List<String> stringsList = new ArrayList<>();
        for (SelectionOptions option : options) {
            stringsList.add(option.getText());
        }
        return stringsList;
    }

    @Override
    public void handleUserInput(FormFields formField) {
        String name = null;
        if (formField.getInputType() == 5) {
            name = RADIO_LIST;
        } else if (formField.getInputType() == 2) {
            name = SELECT_BOX;
        }
        formField.setUserInput(new UserInput(formField.getFieldLabel(), name, selectedItemText.getText().toString(), GENERIC));
    }

    @Override
    public void setFieldError() {
        fieldTitle.setError(itemView.getResources().getString(R.string.spinner_error_message));
        fieldTitle.requestFocus();
    }

    @Override
    public View getErrorFieldPresenter() {
        return fieldTitle;
    }
}
