package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.view.View;
import android.widget.Button;

import org.json.JSONException;

import java.util.List;

import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.R;

/**
 * Created by Oz on 7/20/2017.
*/

public class AutoButtonsViewHolder
        extends FormFieldViewHolder
        implements View.OnClickListener {

    private Button button_yes;
    private Button button_no;
    private ButtonClicked buttonClickedListener;
    private FormFields formField;

    public interface ButtonClicked {
        void yesButtonClicked() throws JSONException;

        void noButtonClicked();
    }

    public AutoButtonsViewHolder(View itemView, List<FormFields> formFields
            , ButtonClicked buttonClickedListener) {
        super(itemView, formFields, null);
        button_yes = itemView.findViewById(R.id.holder_auto_button_yes);
        button_no = itemView.findViewById(R.id.holder_auto_button_no);

        this.buttonClickedListener = buttonClickedListener;

        button_yes.setOnClickListener(this);
        button_no.setOnClickListener(this);

    }

    @Override
    public void bind() {
        formField = formFields.get(getAdapterPosition());
        formField.setFieldChecked(false);
        button_yes.setText(formFields.get(getAdapterPosition()).getLabel_button_yes());
        button_no.setText(formFields.get(getAdapterPosition()).getLabel_button_no());

    }

    @Override
    public void handleUserInput(FormFields formField) {

    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.holder_auto_button_yes) {
            formField.setFieldChecked(true);
            try {
                buttonClickedListener.yesButtonClicked();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            buttonClickedListener.noButtonClicked();
        }
    }

    @Override
    public void setFieldError() {

    }

    @Override
    public View getErrorFieldPresenter() {
        return null;
    }
}
