package nanorep.nanowidget.Components;

import android.content.Context;
import android.graphics.Color;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRSearchBarListener;


/**
 * Created by nissimpardo on 07/06/16.
 */
public class NRSearchBar extends NRCustomSearchBarView implements TextWatcher, TextView.OnEditorActionListener {

    private final int searchIconResourceId = R.drawable.ic_search_black_24dp;
    private final int closeIconResourceId = R.drawable.ic_close_black_24dp;
    private NRSearchBarListener mListener;
    private ImageButton mSearchButton;
    private ImageButton mTopBackButton;
    private TextView labelName;
    private LinearLayout searchBarLayout;
    private LinearLayout labelLayout;
    private SearchViewsProvider viewsProvider;
    private String searchQuery;
    private boolean presentSuggestions = true;

    @Override
    public void presentSuggestions(boolean presentSuggestions) {
        this.presentSuggestions = presentSuggestions;
    }

    public NRSearchBar(Context context, int searchBarLayout) {
        super(context);
        LayoutInflater.from(context).inflate(searchBarLayout, this);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        searchBarLayout = child.findViewById(R.id.searchBarLayout);
        mSearchEditText = child.findViewById(R.id.searchText);
        labelLayout = child.findViewById(R.id.labelLayout);
        labelName = child.findViewById(R.id.search_bar_label_name_textView);

        mSearchEditText.addTextChangedListener(this);
        mSearchEditText.setOnEditorActionListener(this);
        mSearchButton = child.findViewById(R.id.searchButton);
        mSearchButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                if (mSearchEditText.getText().length() > 0) {
                    mSearchButton.setImageResource(searchIconResourceId);
                    clearView();
                }
            }
        });

        mTopBackButton = child.findViewById(R.id.search_bar_back_button);
        mTopBackButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                mListener.onTopBackButtonPressed();
            }
        });

        /*mSearchEditText.setOnKeyListener(new OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_UP) {
                    if (keyCode == KeyEvent.KEYCODE_BACK && !mSearchEditText.getText().toString().isEmpty()) {
                        clearView();
                        return true;
                    }
                }
                return false;
            }
        });*/
    }

    public void setListener(NRSearchBarListener listener) {
        mListener = listener;
    }


    private int resId(String resName) {
        return getResources().getIdentifier(resName, "drawable", getContext().getPackageName());
    }

    public void updateText(String text, boolean presentSuggestions) {
        this.presentSuggestions = presentSuggestions;
        mSearchEditText.clearFocus();
        mSearchEditText.setText(text);
        if (!presentSuggestions) {
            this.presentSuggestions = true;
        }
        getSearchQuery();
    }

    @Override
    public void clearText() {
        mSearchEditText.setText("");
    }


    private void clearView() {
        mSearchEditText.clearFocus();
        hideKeyboard();
        updateText("", false);
        searchQuery = "";
        mListener.onClearSearchText();
    }

    /**
     *  @param displayLabel = false : Shows the search layout
     * @param labelTitle = if (show) this is the Label text. Else, it is the search text. Being ignored if empty
     */

    public void adaptSearchBarDisplay(boolean displayLabel, String labelTitle) {
        if (displayLabel && !viewsProvider.isSearchBarAlwaysOnTop() && (labelTitle != null && !labelTitle.isEmpty())) {
            searchBarLayout.setVisibility(GONE);
            labelName.setText(labelTitle);
            labelLayout.setVisibility(VISIBLE);
        } else if (!displayLabel || labelTitle == null) {
            labelLayout.setVisibility(GONE);
            if (searchQuery != null && !searchQuery.isEmpty()) {
                mSearchEditText.setText(searchQuery);
            }
            searchBarLayout.setVisibility(VISIBLE);
        }
    }

    public void setHint(String text) {
        mSearchEditText.setHint(text);
    }

    @Override
    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public String getSearchQuery() {
        searchQuery = mSearchEditText.getText().toString();
        return searchQuery;
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        boolean isSequenceEmpty = (charSequence == null || charSequence.length() == 0);
        mSearchButton.setImageResource(!isSequenceEmpty ? closeIconResourceId : searchIconResourceId);
        if (isSequenceEmpty) {
            hideKeyboard();
            mListener.clearAutoComplete();
        }
    }

    @Override
    public void afterTextChanged(Editable editable) {
        if (editable != null && editable.length() > 0 && presentSuggestions) {
            mListener.fetchSuggestionsForText(mSearchEditText.getText().toString());
        } else  {
            mListener.onEmptyQuery();
        }
        this.presentSuggestions = true;
    }

    @Override
    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == EditorInfo.IME_ACTION_SEARCH) {
            mListener.searchForText(mSearchEditText.getText().toString());
            hideKeyboard();
            return true;
        }
        return false;
    }

    @Override
    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
        searchBarLayout.setBackgroundColor(Color.WHITE);
    }



}
