package nanorep.nanowidget;

import android.content.Context;

import com.nanorep.nanoclient.Channeling.NRChanneling;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.ViewIdsFactory;
import nanorep.nanowidget.Components.AbstractViews.ViewIdsFactory.IDsProducer;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRDislikeDialog;

/**
 * Created by obenoved on 11/03/2018.
 */

public class SearchViewsProvider {

    public SearchViewsProvider() {

    }

    public IDsProducer getDislikeIdsProducer() {
        return new IDsProducer() {
            @Override
            public int getTitleId() {
                return R.id.dislikeTitle;
            }

            @Override
            public int getFeedbackEditTextId() {
                return R.id.feedbackEditText;
            }

            @Override
            public int getRadioId() {
                return R.id.feedback_radiogroup;
            }

            @Override
            public int getCancelButtonId() {
                return R.id.cancelButton;
            }

            @Override
            public int getSubmitButtonId() {
                return R.id.okButton;
            }

            @Override
            public int getFirstRadioButtonId() {
                return R.id.feedback_radiobutton_first;
            }

            @Override
            public int getSecondRadioButtonId() {
                return R.id.feedback_radiobutton_second;
            }
        };
    }

    public NRCustomDislikeDialog getDislikeDialog(DislikeConfiguration configuration) {
        return NRDislikeDialog.newInstance(configuration, new ViewIdsFactory(getDislikeDialogLayout(), getDislikeIdsProducer()));
    }

    public int getDislikeDialogLayout() {
        return R.layout.dislike_dialog_mixed;
    }

    public int getLikeViewLayout() {
        return R.layout.like_view_text;
    }

    public int getChannelingLayout() {
        return R.layout.channeling_view;
    }

    public int getChannelItemLayout() {
        return R.layout.channel_item;
    }

    public int getArticleLayout() {
        return R.layout.nrresult_top_view;
    }

    public int getSearchBarLayout() {
        return R.layout.search_bar;
    }

    public int getResultsViewLayout() { return R.layout.results_view; }

    public int getLabelItemTitleLayout() {return R.layout.title_item_label; }

    public int getArticleTitleLayout() { return R.layout.article_title; }

    public int getConfirmationDialogsView() {return R.layout.confirmation_dialog; }

    public NRCustomLikeView getLikeView(Context context) {
        return new NRLikeViewText(context ,this);
    }

    public NRCustomChannelView getChannelView(Context context) {
        return new NRChannelingView(context, this);
    }

    public NRCustomSuggestionsView getSuggestionsView(Context context) {
        return new NRSuggestionsView(context);
    }

    public NRCustomSearchBarView getSearchBarView(Context context) {
        return new NRSearchBar(context, getSearchBarLayout());
    }

    public NRCustomContentView getContentView (Context context) {
        return new NRContentView(context);
    }

    public boolean isSearchBarAlwaysOnTop () {
        return true;
    }

    public boolean showChannelConfirmationDialogs(NRChanneling channeling) { return true; }

    public boolean showFeedbackConfirmationDialogs() { return true; }

}
