package nanorep.nanowidget.Fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import com.google.gson.Gson;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.Components.formSDK.FormFragment;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ChatForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ContactForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FEEDBACK;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FORM;
import static com.nanorep.nanoclient.Response.NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;
import static nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog.TAG;

/**
 * Created by obenoved on 14 Feb 2018.
 */

public class DeepLinkFragment extends Fragment
        implements NRArticleView.Listener, NRErrorHandler.Listener, NRChannelItem.OnChannelSelectedListener, NRContentView.Listener {
    private FrameLayout contentMain;
    private NRCustomViewAdapter viewAdapter;
    private NRFetchedDataManager mFetchedDataManager;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private NRConfiguration configuration;
    private NRConfiguration.ConfirmationDialogsText confirmationDialogsText;
    private LinearLayout noConnectionView;
    private NRCustomChannelView channelView;
    private String articleId;
    private Map<String, String> articleExtraData = new HashMap<>();
    private SearchViewsProvider viewsProvider;
    private Nanorep nanorepInstance;
    private AccountParams accountParams;
    private FragmentManager fragmentManager;
    private ProgressBar progressBar;

    public interface deepLinkingServicesProvider {
        /***
         * If returns null, an independent widget listener would be created
         */
        Nanorep.NanoRepWidgetListener getWidgetListener();

        /***
         * If returns null, a default views provider would be created
         */
        SearchViewsProvider getSearchViewsProvider();
    }

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public void setArticleId(String articleId) {
        this.articleId = articleId;
    }

    public void setmFetchedDataManager(NRFetchedDataManager mFetchedDataManager) {
        this.mFetchedDataManager = mFetchedDataManager;
    }

    public void setArticleExtraData(Map<String, String> extraData) {
        this.articleExtraData = extraData;
    }

    /**
     * A Constructor that gets an existing Nanorep instance
     * Try not to use this constructor, use the independent "newInstance(String articleId, AccountParams accountParams, SearchViewsProvider searchViewsProvider)" instead
     * @param articleId
     * @param nanorepInstance - If equals to null, A new nanorep instance would be created
     * @param servicesProvider - If equals to null, a default views provider and an independent widget listener would be created
     * @return
     */
    public static DeepLinkFragment newInstance(String articleId, Nanorep nanorepInstance, deepLinkingServicesProvider servicesProvider) {

        DeepLinkFragment fragment = new DeepLinkFragment();

        if (servicesProvider != null) {
            fragment.viewsProvider = servicesProvider.getSearchViewsProvider();
            fragment.widgetListener = servicesProvider.getWidgetListener();
        }

        fragment.accountParams = nanorepInstance.getAccountParams();
        fragment.articleId = articleId;

        return fragment;
    }

    /**
     * A Constructor that creates the Nanorep instance
     * @param articleId
     * @param accountParams
     * @param servicesProvider - If equals to null, a default views provider and an independent widget listener would be created
     * @return
     */
    public static DeepLinkFragment newInstance( @NonNull String articleId, @NonNull AccountParams accountParams, deepLinkingServicesProvider servicesProvider) {

        DeepLinkFragment fragment = new DeepLinkFragment();

        if (servicesProvider != null) {
            fragment.viewsProvider = servicesProvider.getSearchViewsProvider();
            fragment.widgetListener = servicesProvider.getWidgetListener();
        }

        fragment.articleId = articleId;
        fragment.accountParams = accountParams;

        Nanorep.initialize(accountParams);

        return fragment;
    }

    /**
     * A Constructor that creates the Nanorep instance and an independent WidgetListener
     * @param articleId
     * @param accountParams
     * @param searchViewsProvider - If equals to null, a default views provider would be created
     * @return
     */
    @Deprecated
    public static DeepLinkFragment newInstance( @NonNull String articleId,  @NonNull AccountParams accountParams, SearchViewsProvider searchViewsProvider) {
        DeepLinkFragment fragment = new DeepLinkFragment();

        fragment.viewsProvider = searchViewsProvider;
        fragment.articleId = articleId;
        fragment.accountParams = accountParams;

        Nanorep.initialize(accountParams);

        return fragment;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Gson gson = new Gson();
        String accountParamsJson = gson.toJson(accountParams);

        outState.putString("articleId", articleId);
        outState.putString("accountParamsJson", accountParamsJson);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_deeplink, container, false);

        if (savedInstanceState != null) {
            String accountParamsJson = savedInstanceState.getString("accountParamsJson");
            Gson gson = new Gson();

            accountParams = gson.fromJson(accountParamsJson, AccountParams.class);
            articleId = savedInstanceState.getString("articleId");
        }

        noConnectionView = view.findViewById(R.id.noConnectionView);
        contentMain = view.findViewById(R.id.content_main);
        progressBar = view.findViewById(R.id.progressBar);

        if (!Nanorep.isInitialized()) {
            Nanorep.initialize(accountParams);
        }

        nanorepInstance = Nanorep.getInstance();
        nanorepInstance.setHttpRequestTimeout(15);

        if (widgetListener == null) {
            initIndependentWidgetListener(configuration != null);
        }

        setLoadingState(true);

        if (viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider(viewsProvider);
        } else {
            if (nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) nanorepInstance.getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        viewAdapter = new NRViewAdapter(viewsProvider);

        fragmentManager = getFragmentManager();

        nanorepInstance.setWidgetListener(widgetListener);

        initIndependentDataManager();

        return view;
    }


    private void initIndependentWidgetListener(final boolean hasConfiguration) {

        // In case the fragment is being recycled, "onConfigurationFetched" won't be called for the existed nanorep instance
        if (nanorepInstance.getNRConfiguration() != null) {
            configuration = nanorepInstance.getNRConfiguration();
        }

        widgetListener = new Nanorep.NanoRepWidgetListener() {

            @Override
            public void onError(NRError error) {

                Log.e("Widget Error", "error location: " + error.getDomain() +", error code: " + error.getCode() + ", error description: " + error.getDescription());
                if (fragmentManager != null) {
                   // fragmentManager.popBackStack();
                }

                if (nanorepInstance != null) {
                    nanorepInstance.clearSession();
                }
            }

            @Override
            public void personalInfoWithExtraData(String channelDescription, String extraData, NRExtraDataListener listener) {
                if (articleExtraData != null) {
                    listener.onExtraData(articleExtraData);
                }
            }

            @Override
            public void onSubmitSupportForm(String formData, ArrayList<String> fileUploadPaths) {
                if (formData != null) {
                    Log.i("formData", formData);
                } else {
                    onError(NRError.error(TAG, FORM, getString(R.string.null_form_result)));
                }

                if (fileUploadPaths != null) {
                    Log.i("filesToUpload", fileUploadPaths.toString());
                } else {
                    onError(NRError.error(TAG, FORM, getString(R.string.null_form_result)));
                }
            }

            @Override
            public void onConfigurationFetched() {

                if (!hasConfiguration && getActivity() != null) {

                    configuration = nanorepInstance.getNRConfiguration();
                    fetchAnswer();
                }
            }

            @Override
            public void onCachedImageRequest(String url, Nanorep.NRCachedImageResponder responder) {

            }

            @Override
            public void onInitializationFailure() {
                Log.e("Widget Error", getString(R.string.initialization_failure));
            }

            @Override
            public void onEmptyDataResponse() {
                Log.d("Widget Error", getString(R.string.empty_data_response));
            }

            @Override
            public void onChannel(NRChanneling.NRChannelingType channelingType, Object extraData) {
                switch (channelingType) {
                    case PhoneNumber:
                        Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", (String) extraData, null));
                        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
                        try {
                            startActivity(intent);
                        } catch (ActivityNotFoundException e) {
                            Log.d("dialerError", getString(R.string.dialer_error));
                        }
                        break;

                }
            }
        };
    }

    private NRArticleView getTopView() {

        Context context = getContext();

        if (context != null) {
            NRArticleView resultTopView = new NRArticleView(getContext(), viewsProvider);
            resultTopView.setListener(this);

            NRCustomTitleView titleView = viewAdapter.getTitleView(getContext());

            ((NRArticleTitleView) titleView).configViewObjects(configuration);

            NRCustomContentView contentView = viewAdapter.getContentView(getContext());

            NRCustomLikeView likeView = viewAdapter.getLikeView(getContext());

            if (likeView == null) {
                likeView = new NRLikeViewText(getContext(), viewsProvider);
            }

            channelView = viewAdapter.getChannelView(getContext());

            if (channelView == null) {
                channelView = new NRChannelingView(getContext(), viewsProvider);
            }

            NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(getContext());

            resultTopView.setTitleView(titleView);
            resultTopView.setContentView(contentView, this);


            if (feedbackView != null) {
                feedbackView.setCustomChannelView(channelView);
                feedbackView.setCustomLikeView(likeView);
                resultTopView.setLikeView(feedbackView.getCustomLikeView());
                resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
                resultTopView.setFeedbackView(feedbackView);
            } else {
                resultTopView.setLikeView(likeView);
                resultTopView.setChannelView(channelView, this);
            }

            return resultTopView;
        }

        return null;
    }


    private void initIndependentDataManager() {

        mFetchedDataManager = new NRFetchedDataManager(getContext(), new NRConfigFetcherListener() {
            @Override
            public void onConfigurationReady() {
                Log.d("", "");
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {

            }

            @Override
            public void onError(NRError error) {
                widgetListener.onError(error);
            }

            @Override
            public void noResultFound(NRResult response, String searchContext) {

            }

            @Override
            public void showContextSelectionDialog(ContextValue contextValues) {

            }
        });

        if (configuration != null && getActivity() != null) {
            fetchAnswer();
        }

    }

    public void fetchAnswer() {

        if (configuration != null) {
            confirmationDialogsText = configuration.getConfirmationDialogsText();
        }

        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult queryResult) {
                setLoadingState(false);

                NRResult deepLinkingResult = new NRResult(queryResult, null);

                final NRArticleView resultTopView = getTopView();
                if (resultTopView != null) {
                    resultTopView.setResult(deepLinkingResult);
                    contentMain.addView(resultTopView);
                    resultTopView.openOpenedView(deepLinkingResult);
                    contentMain.requestFocus();
                }

            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {

    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        if (getActivity() != null) {
            this.articleId = resultID;
            mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
                @Override
                public void onAnswerFetched(NRQueryResult result) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            });
        }
    }

    @Override
    public void closeAnswer() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            NRArticleView articleView = (NRArticleView) view;
            if (!articleView.getResult().isSingle()) {
                articleView.setResultUnFoldState(false);
                articleView.removeTopView();
            }
        }
        contentMain.removeView(view);
    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getResult();

        if (result != null) {
            final NRQueryResult fetchedResult = result.getFetchedResult();
            if (fetchedResult != null) {
                if (isLike) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                    mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
                        @Override
                        public void onLikeSent(boolean success) {
                            if (!success) {
                                fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                                widgetListener.onError(NRError.error(TAG, FEEDBACK, getString(R.string.feedback_error_message)));
                                likeView.resetLikeView();
                            } else if (getActivity() != null && viewsProvider != null){
                                View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                                if (viewsProvider != null && viewsProvider.showFeedbackConfirmationDialogs()) {
                                    ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(getContext(), false, view, confirmationDialogsText);
                                    confirmationDialogFragment.show();
                                }
                            }
                        }
                    });
                } else {
                    if (likeView.shouldOpenDialog()) {
                        openDislikeDialog(fetchedResult, view, likeView);
                    } else {
                        onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
                    }
                }
            }
        }
    }

    private void openDislikeDialog(final NRQueryResult fetchedResult, final NRArticleView view, final NRCustomLikeView likeView) {
        // String reasons[] = new String[]{getString(R.string.missing_information), getString(R.string.didnt_find)};

        final int dialogType = configuration.getFeedbackDialogType();

        if (viewsProvider != null && dialogType != NO_FEEDBACK_DIALOG_TYPE) {
            NRCustomDislikeDialog dislikeDialog = viewsProvider.getDislikeDialog(new DislikeConfiguration(configuration) {
                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener() {
                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            DeepLinkFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                        }
                    };
                }
            });
            if (fragmentManager != null) {
                dislikeDialog.show(fragmentManager, TAG);
            }
        }
    }

    private void onDismissDislike() {
        // update channeling
        nanorepInstance.updateDislikeChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView) view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(View.VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.update_channeling_error) + error.getData()));
                channelView.setVisibility(View.GONE);
            }
        });
    }
    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    NRError.error(TAG, CONNECTION, getResources().getString(R.string.delete_last_context_error));
                    removeTopView();
                } else if (getActivity() != null){
                    View view = getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(getContext(), false, view, confirmationDialogsText);
                    confirmationDialogFragment.show();
                }
            }
        });
    }


    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                }
                break;
        }
    }

    @Override
    public void dismissConnectionError() {
        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(View.GONE);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        final String predefinedExtraData;
        NRQueryResult currentResult = getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {

//            if (channel.getNoResultExtra() == null) {
//                openChannel(channel);
//                return;
//            }
            predefinedExtraData = channel.getNoResultExtra();
        } else {
            predefinedExtraData = getCurrentResult().getExtraData();
        }

        widgetListener
                .personalInfoWithExtraData(
                        channel.getChannelDescription(),
                        predefinedExtraData,
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channel.setExtraData(extraData, predefinedExtraData);
                                openChannel(channel);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresenter presenter = NRChannelStrategy.presenter(getContext(), channeling, nanorepInstance);

        if (presenter instanceof NRCustomScriptChannelPresenter) {

            presenter.present();

        } else {

            final FragmentManager fragmentManager = getFragmentManager();

            String url = presenter.getUrl();
            if (url != null && fragmentManager != null && viewsProvider != null) {

                if (channeling.getType() == ContactForm
                        && TextUtils.isDigitsOnly(channeling.getContactForm())
                        && android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {

                    FormFragment fragment = FormFragment.newInstance(channeling, configuration.getConfirmationDialogsText(), widgetListener);
                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment, FormFragment.TAG)
                            .addToBackStack(null)
                            .commit();
                } else {
                    View view = getView();
                    if (channeling.getType() == ChatForm && view != null) {
                        final RelativeLayout holder = view.findViewById(R.id.fragment_place_holder);
                        holder.setVisibility(View.VISIBLE);
                    }

                    final NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, viewsProvider, widgetListener);

                    fragment.setConfirmationDialogsText(configuration.getConfirmationDialogsText());

                    fragment.setListener(new NRWebContentFragment.WebFormListener() {
                        @Override
                        public void onDismiss(String result) {

                            if (result == null) {
                                widgetListener.onError(NRError.error(TAG, FORM, getString(R.string.null_form_result)));
                            }

                            fragmentManager.popBackStack();

                            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();

                            hideKeyboard();

                            requestFocus();

                        }
                    });

                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment, NRWebContentFragment.TAG)
                            .addToBackStack(null)
                            .commit();
                }
            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                widgetListener.onChannel(PhoneNumber, phoneNumber);
            }

        }
        nanorepInstance.reportChanneling(getCurrentResult(), channeling);
    }


    private void hideKeyboard() {
        View view = getView();
        if (view != null) {
            Context context = view.getContext();
            if (context != null) {
                InputMethodManager imm = (InputMethodManager) context.getSystemService(Context.INPUT_METHOD_SERVICE);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(getView().getWindowToken(), 0);
                    requestFocus();
                }
            }
        }
    }

    private void requestFocus() {
        if (getView() != null) {
            getView().requestFocus();
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView) view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(getContext(), height));
                newResult.setSingle(true);

                NRArticleView resultTopView = getTopView();

                if (resultTopView != null) {

                    contentMain.addView(resultTopView);

                    resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));

                    resultTopView.openOpenedView(newResult);

                    requestFocus();
                }
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (nanorepInstance.getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
                @Override
                public void onDismiss() {
                    contentMain.removeViewAt(contentMain.getChildCount() - 1);
                    requestFocus();
                }
            });

            contentMain.addView(webView);
            requestFocus();
        } else {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            try {
                startActivity(intent);
            } catch (Exception e) {
                Log.d("StartActivityError", "Unable to start activity");
            }
        }
    }

    @Override
    public void onError(NRError error) {
        widgetListener.onError(error);
    }

    @Override
    public void onDismiss() {

        if (fragmentManager != null) {
            Fragment fragment = fragmentManager.findFragmentByTag(NRWebContentFragment.TAG);
            if (fragment == null) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

                if (view instanceof NRArticleView) {
                    view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                }
            }
        }

        removeTopView();

    }

    @Override
    public void onDestroy() {
        clear();
        super.onDestroy();
    }

    private void clear() {

        viewsProvider = null;
        widgetListener = null;
        configuration = null;

        if (nanorepInstance != null) {
            nanorepInstance.clearSession();
        }
    }

    private void removeTopView() {
        dismissConnectionError();

        if (contentMain != null) {
            int oldChildCount = contentMain.getChildCount();

            contentMain.removeViewAt(oldChildCount - 1);

            loadCurrentViewAfterRemoval();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (localCurrentView != null && localCurrentView != progressBar) {
            requestFocus();
            localCurrentView.setVisibility(View.VISIBLE);
        } else {
            fragmentManager.popBackStack();
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        requestFocus();
        hideKeyboard();

        View.OnKeyListener onKeyListener = new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {

                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        removeTopView();
                        return true;
                    }
                }
                return false;
            }
        };

        View view = getView();
        if (view != null) {
            view.setOnKeyListener(onKeyListener);
        }
    }

    private void setLoadingState(boolean state) {
        progressBar.setVisibility(state? View.VISIBLE : View.GONE);
    }
}

