package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.graphics.Color;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;

import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.AUTO_BUTTONS;

/**
 * Created by Oz on 7/20/2017.
 */

public abstract class FormFieldViewHolder
        extends RecyclerView.ViewHolder {

    FormViewHolderAdapterInteraction formViewHolderAdapterInteraction;
    List<FormFields> formFields;
    ViewGroup fieldDataLayout;
    private boolean sendClicked;

    FormFieldViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView);
        this.formViewHolderAdapterInteraction = formViewHolderAdapterInteraction;
        this.formFields = formFields;
    }

    public abstract void bind();

    SpannableStringBuilder redStarEnding(String redStarEndingIsRequired) {
        redStarEndingIsRequired = redStarEndingIsRequired + "*";
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(redStarEndingIsRequired);
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(Color.RED);
        spannableStringBuilder.setSpan(foregroundColorSpan, redStarEndingIsRequired.length() - 1,
                redStarEndingIsRequired.length(),
                Spanned.SPAN_INCLUSIVE_INCLUSIVE);
        return spannableStringBuilder;
    }

    public abstract void handleUserInput(FormFields formField);

    public ViewGroup getFieldDataLayout() {
        return fieldDataLayout;
    }

    public abstract void setFieldError();

    boolean isSendClicked() {
        FormFields lastFormField = formFields.get(formFields.size()-1);
        return lastFormField.getInputType() == AUTO_BUTTONS && lastFormField.isChecked();
    }

    public abstract View getErrorFieldPresenter();
}
