package nanorep.nanowidget.Components.ChannelPresenters;

import android.net.Uri;
import android.util.Log;

import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingChatForm;
import com.nanorep.nanoclient.Channeling.NRChannelingContactForm;
import com.nanorep.nanoclient.Channeling.NRChannelingOpenCustomURL;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;

import org.json.JSONObject;

import nanorep.nanowidget.DataClass.NRResult;

/**
 * Created by nissimpardo on 28/06/16.
 */
public class NRWebContentChannelPresenter implements NRChannelPresenter {
    private Nanorep mNanoRep;
    private NRChanneling mChanneling;

    public NRWebContentChannelPresenter(Nanorep nanoRep) {
//        mResultFragment = resultFragment;
        mNanoRep = nanoRep;
    }

    @Override
    public void present() {
//        mNanoWidget.getChannelingWebView().setVisibility(View.VISIBLE);

        String mUrl;
        Uri.Builder channelUri = new Uri.Builder();
        channelUri.scheme("http").authority("dev4.nanorep.com");
        AccountParams accountParams = mNanoRep.getAccountParams();
        NRQueryResult queryResult = mChanneling.getQueryResult();

        String url = null;

        switch (mChanneling.getType()) {
            case ContactForm:
                channelUri.appendEncodedPath("sdk/mobile/contactform.html");
                channelUri.appendQueryParameter("account", accountParams.getAccount());
                channelUri.appendQueryParameter("articleId", queryResult.getId());
                channelUri.appendQueryParameter("context", "null").appendQueryParameter("host", "my.nanorep.com");
                channelUri.appendQueryParameter("kb", accountParams.getKnowledgeBase());
                channelUri.appendQueryParameter("text", queryResult.getTitle());
                channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm) mChanneling).getContactForms());
                channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                break;
            case ChatForm:
                channelUri.appendEncodedPath("sdk/mobile/chat.html");
                channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm) mChanneling).getChatProvider());
                channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm) mChanneling).getAccountNum());
                channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                break;
            case OpenCustomURL:
                channelUri = null;
                url = ((NRChannelingOpenCustomURL) mChanneling).getLinkUrl();
                break;
        }
        mUrl = url == null ? channelUri.toString() : url;
//        mResultFragment.getParentFragment().getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.slide_in_left, R.anim.slide_out_left, R.anim.slide_in_left, R.anim.slide_out_left).add(R.id.content_id, NRWebContentFragment.newInstance(passUrl, null)).addToBackStack("nanowidget").commit();
    }

    @Override
    public String getUrl() {

        if (mChanneling != null) {

            NRQueryResult queryResult = mChanneling.getQueryResult();
            AccountParams accountParams = mNanoRep.getAccountParams();
            JSONObject channelingExtraData = mChanneling.getExtraData();

            Uri.Builder channelUri = accountParams.getUri();

            String host = accountParams.getHost() != null ?
                    accountParams.getHost() + ".nanorep.com" :
                    accountParams.getAccount() + ".nanorep.co";

            String url = null;

            String articleId = "0";
            String title = "No Results";

            if (queryResult != null) {
                articleId = queryResult.getId();
                title = queryResult.getTitle();
            }

            switch (mChanneling.getType()) {
                case ContactForm:
                    channelUri.appendEncodedPath("sdk/mobile/contactform.html");

                    if (mChanneling.getQueryResult() != null) {
                        channelUri.appendQueryParameter("articleId", articleId);
                        channelUri.appendQueryParameter("text", title);
                    }

                    channelUri.appendQueryParameter("account", accountParams.getAccount());
                    channelUri.appendQueryParameter("kb", accountParams.getKnowledgeBase());
                    channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm) mChanneling).getContactForms());
                    channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                    channelUri.appendQueryParameter("channelName", mChanneling.getName());
                    channelUri.appendQueryParameter("host", host);

                    if (channelingExtraData != null) {
                        channelUri.appendQueryParameter("predefinedValues", channelingExtraData.toString());
                    }
                    break;

                case ChatForm:
                    channelUri.appendEncodedPath("sdk/mobile/chat.html");
                    channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm) mChanneling).getChatProvider());
                    channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm) mChanneling).getAccountNum());
                    channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                    break;

                case OpenCustomURL:
                    channelUri = null;
                    url = ((NRChannelingOpenCustomURL) mChanneling).getLinkUrl();
                    break;
            }

            url = (url == null && channelUri != null) ? channelUri.toString() : url;
            Log.d("NRWebContentChannel", url);
            return url;
        }
        return null;
    }

    @Override
    public void setChannel(NRChanneling channeling) {
        mChanneling = channeling;
    }

    @Override
    public NRResult getResult() {
        return null;
    }
}
