package nanorep.nanowidget.Components.AbstractViews;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.OnLikeListener;

/**
 * Created by nanorep on 05/10/2016.
 */

public abstract class NRCustomLikeView extends LinearLayout {

    protected NRConfiguration configuration;

    protected SearchViewsProvider viewsProvider;

    protected OnLikeListener mListener;

    public void setListener(OnLikeListener listener) {
        mListener = listener;
    }

    public NRCustomLikeView(Context context, SearchViewsProvider viewsProvider) {
        super(context);

        configuration = Nanorep.getInstance().getNRConfiguration();
        this.viewsProvider = viewsProvider;

    }

    /**
     * Update the button UI after clicking it
     * @param isLike
     */
    public abstract void updateLikeButton(boolean isLike);

    public abstract void resetLikeView();

    public abstract boolean getLikeSelection();

    public abstract boolean shouldOpenDialog();

    public void onFeedbackSubmitted() {
        if (configuration != null && viewsProvider != null && viewsProvider.showFeedbackConfirmationDialogs()) {
            View view = LayoutInflater.from(getContext()).inflate(viewsProvider.getConfirmationDialogsView(), null);
            ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(view.getContext(), false, view, configuration.getConfirmationDialogsText());
            confirmationDialogFragment.show();
        }
    }
}
