package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.EMAIL;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.GENERAL;

/**
 * Created by Oz on 7/20/2017.
 */

public class EditTextViewHolder
        extends FormFieldViewHolder
        implements View.OnClickListener, TextWatcher {

    private EditText editText;
    private TextView fieldTitle;
    private ImageButton clearButton;
    private ImageView emailIcon;
    private FormFields formField;

    public EditTextViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);

        fieldTitle = itemView.findViewById(R.id.holder_field_title);
        editText = itemView.findViewById(R.id.holder_editText);
        clearButton = itemView.findViewById(R.id.holder_editText_clearButton);
        emailIcon = itemView.findViewById(R.id.holder_editText_email);

        clearButton.setOnClickListener(this);
        editText.addTextChangedListener(this);
    }

    @Override
    public void bind() {
        formField = formFields.get(getAdapterPosition());

        if (isSendClicked() && formField.isRequired() && !formField.isValid()) {
            editText.requestFocus();
            setFieldError();
        }

        if (formField.getTextInputType() == 1) {
            emailIcon.setVisibility(View.VISIBLE);
        }
        String fieldLabel = formField.getFieldLabel();
        String placeHolder = formField.getTextPlaceholder();
        if (placeHolder.length() > 0) {
            editText.setHint(placeHolder);
            appendFieldTitle(formField);
        } else {
            appendFieldHint(formField, fieldLabel);
        }
        keyboardInputConfig(formField.getTextInputType());
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_NEXT) {
                    formViewHolderAdapterInteraction.onNextClicked(getAdapterPosition());
                    return true;
                }
                return false;
            }
        });
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    handleUserInput(formField);
                }
            }
        });
    }

    private void appendFieldTitle(FormFields formField) {
        fieldTitle.setVisibility(View.VISIBLE);
        if (formField.isRequired()) {
            fieldTitle.setText(redStarEnding(formField.getFieldLabel()));
        } else {
            fieldTitle.setText(formField.getFieldLabel());
        }
    }

    private void appendFieldHint(FormFields formField, String fieldLabel) {
        if (formField.isRequired()) {
            editText.setHint(redStarEnding(fieldLabel));
        } else {
            editText.setHint(fieldLabel);
        }
    }

    private void keyboardInputConfig(int inputType) {
        switch (inputType) {
            case 1:
                editText.setInputType(InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS);
                break;
            case 2:
                editText.setInputType(InputType.TYPE_CLASS_PHONE);
                break;
            case 3:
                editText.setInputType(InputType.TYPE_CLASS_NUMBER);
                break;
            case 10:
                editText.setInputType(InputType.TYPE_CLASS_PHONE);
                break;
            default:
                editText.setInputType(InputType.TYPE_CLASS_TEXT);
                break;
        }
        editText.setImeOptions(EditorInfo.IME_ACTION_NEXT);
    }

    @Override
    public void handleUserInput(FormFields formField) {
        String value = editText.getText().toString();
        if (value.length() > 0) {
            formField.setFieldChecked(true);
            if (formField.getTextInputType() == 1) {
                if (!android.util.Patterns.EMAIL_ADDRESS.matcher(value).matches()) {
                    formField.setValid(false);
                } else {
                    formField.setValid(true);
                    formField.setUserInput(new UserInput(formField.getFieldLabel(), EMAIL, value, EMAIL));
                }
            } else {
                formField.setValid(true);
                formField.setUserInput(new UserInput(formField.getFieldLabel(), GENERAL, value, GENERAL));
            }
        } else {
            formField.setFieldChecked(false);
            formField.setValid(true);
        }
    }

    @Override
    public void setFieldError() {
        clearButton.setVisibility(View.INVISIBLE);
        if (formField.getValidationErrorMessage().length() > 0) {
            editText.setError(formField.getValidationErrorMessage());
        } else {
            editText.setError(itemView.getResources().getString(R.string.edit_text_error_message));
        }
    }

    @Override
    public View getErrorFieldPresenter() {
        return editText;
    }

    @Override
    public void onClick(View v) {
        editText.setText("");
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {}

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (editText.getText().length() > 0) {
            clearButton.setVisibility(View.VISIBLE);
        } else {
            clearButton.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public void afterTextChanged(Editable s) {

    }
}
