package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import nanorep.nanowidget.R;

/**
 * Created by nanorep on 26/09/2016.
 */

public class SimpleDividerItemDecoration extends RecyclerView.ItemDecoration{
    private Drawable mDivider;
    public static int PAGE_LABELS = 0;
    public static int PAGE_RESULTS = 1;


    private boolean disableDecoration = false;

    public SimpleDividerItemDecoration(Context context, Resources resources, int page) {
        if (page == PAGE_LABELS) {
            mDivider = ContextCompat.getDrawable(context, R.drawable.divider_labels);
        } else {
            mDivider = ContextCompat.getDrawable(context, R.drawable.divider_results);
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {

        if((parent.getItemAnimator() != null && parent.getItemAnimator().isRunning()) || disableDecoration) {
            return;
        }

        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();

        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; i++) {
            View child = parent.getChildAt(i);

            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) child.getLayoutParams();

            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + mDivider.getIntrinsicHeight();

            mDivider.setBounds(left, top, right, bottom);
            mDivider.draw(c);
        }
    }

    public void setDisableDecoration(boolean disableDecoration) {
        this.disableDecoration = disableDecoration;
    }


//    @Override
//    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
//        super.onDraw(c, parent, state);
//
//        final int left = parent.getPaddingLeft();
//        final int right = parent.getWidth() - parent.getPaddingRight();
//        final int childCount = parent.getChildCount();
//        final int dividerHeight = mDivider.getIntrinsicHeight();
//
//        for (int i = 1; i < childCount; i++) {
//            final View child = parent.getChildAt(i);
//            final RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) child.getLayoutParams();
//            final int ty = (int)(child.getTranslationY() + 0.5f);
//            final int top = child.getTop() - params.topMargin + ty;
//            final int bottom = top + dividerHeight;
//            mDivider.setBounds(left, top, right, bottom);
//            mDivider.draw(c);
//        }
//    }
}
