/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClass;

import android.app.AlertDialog;
import android.content.Context;
import android.util.Log;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NRFetchedDataManager {
    private NRFAQData mFaqData;
    private NRFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    private Context context;
    private String preContextSelectionQuery;
    private String searchContext;
    private List<Map<String, Object>> contextList;
    private String selectionDialogTitle;
    private AlertDialog contextSelectionDialog;
    private NRConfigFetcherListener fetcherListener;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        this.context = context;
        this.mconfigFetcherListener = configFetcherListener;
        this.fetchConfiguration();
    }

    public void fetchConfiguration() {
        if (Nanorep.getInstance().getNRConfiguration() != null) {
            this.mconfigFetcherListener.onConfigurationReady();
            this.prepareDatasource();
        }
    }

    public NRFetcherListener getFetcherListener() {
        return this.mFetcherListener;
    }

    public void setFetcherListener(NRFetcherListener listener) {
        this.mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            this.updateCategoriesResults(null);
            return;
        }
        NRConnection.Listener listener = new NRConnection.Listener(){

            public void response(Object responseParam, int status, NRError error) {
                ArrayList<NRFAQGroupItem> groups = new ArrayList<NRFAQGroupItem>();
                if (responseParam instanceof HashMap) {
                    HashMap map = (HashMap)responseParam;
                    NRFAQGroupItem group = new NRFAQGroupItem(map);
                    groups.add(group);
                    NRFetchedDataManager.this.mconfigFetcherListener.insertRows(groups);
                }
            }

            public void log(String tag, String msg) {
            }
        };
        Nanorep.getInstance().updateFaqList(null, Nanorep.getInstance().getAccountParams().getContext(), true, listener);
    }

    private void updateCategoriesResults(ArrayList<NRFAQGroupItem> groups) {
        if (groups != null) {
            this.mconfigFetcherListener.insertRows(groups);
        } else {
            this.mconfigFetcherListener.insertRows(null);
        }
    }

    public static ArrayList<NRResult> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
            ArrayList<NRResult> results = new ArrayList<NRResult>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResultItem.RowType.TITLE);
                currentResult.setHeight((int)Calculate.pxFromDp(context, height));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    public void searchText(final String text) {
        Nanorep.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener(){

            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error != null) {
                    Log.d((String)"RequestError", (String)error.getDescription());
                } else {
                    boolean contextSelectionOnly;
                    if (response == null || response.getAnswerList() == null || response.getAnswerList().isEmpty()) {
                        NRResult noResult = NRFetchedDataManager.this.getNoResultResponse(response, text);
                        NRFetchedDataManager.this.mconfigFetcherListener.noResultFound(noResult, NRFetchedDataManager.this.searchContext);
                        return;
                    }
                    String contextName = null;
                    ArrayList<NRResult> results = NRFetchedDataManager.generateNRResultArray(response.getAnswerList(), NRFetchedDataManager.this.context);
                    try {
                        if (NRFetchedDataManager.this.contextList == null && response.getParams().containsKey("context")) {
                            NRFetchedDataManager.this.contextList = (List)((Map)response.getParams().get("context")).get("values");
                        }
                        contextSelectionOnly = (Boolean)((NRQueryResult)response.getAnswerList().get(0)).getParams().get("contextSelectionOnly");
                        List selectionContextIds = response.getSelectionContextId();
                        if (NRFetchedDataManager.this.contextList != null && !NRFetchedDataManager.this.contextList.isEmpty()) {
                            contextName = NRFetchedDataManager.this.findContextName(selectionContextIds, NRFetchedDataManager.this.contextList);
                        }
                        if (contextName != null && contextName.length() == 0) {
                            contextSelectionOnly = false;
                        }
                    }
                    catch (ClassCastException | NullPointerException e) {
                        contextSelectionOnly = false;
                    }
                    if (contextSelectionOnly && contextName != null && !contextName.isEmpty()) {
                        NRFetchedDataManager.this.preContextSelectionQuery = text;
                        NRFetchedDataManager.this.fetchContextSelectionData(contextName);
                    } else {
                        NRFetchedDataManager.this.mFetcherListener.insertRows(results, NRFetchedDataManager.this.searchContext);
                    }
                }
            }
        });
    }

    private String findContextName(List<Integer> ids, List<Map<String, Object>> contextList) {
        StringBuilder ctx = new StringBuilder();
        for (int id2 : ids) {
            for (Map<String, Object> map : contextList) {
                String _id = String.valueOf(map.get("id"));
                if (!_id.equals(String.valueOf(id2))) continue;
                if (ctx.length() > 0) {
                    ctx.append(",");
                }
                this.selectionDialogTitle = (String)map.get("selectionText");
                ctx.append((String)map.get("name"));
            }
        }
        return ctx.toString();
    }

    private NRResult getNoResultResponse(NRSearchResponse response, String text) {
        response.getParams().put("originalSearch", text);
        return new NRResult(response.getParams());
    }

    private void fetchContextSelectionData(final String contextName) {
        Nanorep.getInstance().getContextValues(contextName, (OnDataResponse)new OnDataResponse<String>(){

            public void onSuccess(String response) {
                try {
                    String[] keys = contextName.split(",");
                    ContextValue contextValues = new ContextValue(keys[0]);
                    NRFetchedDataManager.this.extractContext(new JSONObject(response), contextValues, keys, 0);
                    NRFetchedDataManager.this.mconfigFetcherListener.showContextSelectionDialog(contextValues);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    private void extractContext(JSONObject json, ContextValue contextValue, String[] key, int depth) throws JSONException {
        Iterator jsonKeys = json.keys();
        while (jsonKeys.hasNext()) {
            ContextValue subContext;
            String propName = (String)jsonKeys.next();
            if (propName.equals("values")) {
                subContext = contextValue;
            } else {
                subContext = new ContextValue(key[depth]);
                subContext.setParentContextValue(propName);
                contextValue.getSubContext().add(subContext);
            }
            JSONArray arr = json.getJSONArray(propName);
            for (int i = 0; i < arr.length(); ++i) {
                if (arr.get(i) instanceof String) {
                    subContext.getValues().add((String)arr.get(i));
                    continue;
                }
                this.extractContext((JSONObject)arr.get(i), subContext, key, depth + 1);
            }
        }
    }

    public void presentResultsForSelectedContext(final String selectedSearchContext) {
        Nanorep.getInstance().setContext(selectedSearchContext, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().removeFromSearchCache(NRFetchedDataManager.this.preContextSelectionQuery);
                if (NRFetchedDataManager.this.searchContext == null) {
                    NRFetchedDataManager.this.searchContext = "";
                }
                NRFetchedDataManager.this.searchContext = selectedSearchContext;
                Nanorep.getInstance().searchText(NRFetchedDataManager.this.preContextSelectionQuery, new Nanorep.OnSearchResultsFetchedListener(){

                    public void onSearchResponse(NRSearchResponse response, NRError error) {
                        ArrayList<NRResult> results = NRFetchedDataManager.generateNRResultArray(response.getAnswerList(), NRFetchedDataManager.this.context);
                        if (results != null) {
                            NRFetchedDataManager.this.mFetcherListener.insertRows(results, NRFetchedDataManager.this.searchContext);
                        } else {
                            NRResult noResult = NRFetchedDataManager.this.getNoResultResponse(response, NRFetchedDataManager.this.preContextSelectionQuery);
                            ArrayList<NRResult> noResultsArrayList = new ArrayList<NRResult>();
                            noResultsArrayList.add(noResult);
                            NRFetchedDataManager.this.mFetcherListener.insertRows(noResultsArrayList, NRFetchedDataManager.this.searchContext);
                        }
                    }
                });
            }

            public void onError(NRConnectionException error) {
            }
        });
    }

    public void searchSuggestion(final String suggestion) {
        Nanorep.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener(){

            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null) {
                    Log.d((String)"Fetcher", (String)error.getDomain());
                } else if (suggestions != null && suggestions.getSuggestions() != null) {
                    NRFetchedDataManager.this.mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
    }

    public void sendLike(NRLikeType likeType, String feedbackText, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
        NRFAQLikeParams likeParams = new NRFAQLikeParams(result, feedbackText);
        likeParams.setLikeType(likeType);
        likeParams.setAnswerId(result.getId());
        Nanorep.getInstance().likeForFAQResult(likeParams, completion);
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : ((NRFAQGroupItem)this.mFaqData.getGroups().get(0)).getAnswers()) {
            if (!result.getId().equals(resultId)) continue;
            result.setLikeState(NRQueryResult.LikeState.notSelected);
        }
    }

    public void faqAnswer(String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        Nanorep.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener(){

            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched((NRQueryResult)faqAnswer);
                } else {
                    answerFetcher.onAnswerFetched(null);
                }
            }
        });
    }

    private void onRequestError(NRError error) {
    }

    public void clearSearchContext() {
        this.searchContext = null;
    }

    public void fetchLabelFAQ(final NRLabel label) {
        Nanorep.getInstance().updateFaqList(null, label.getContext(), false, new NRConnection.Listener(){

            public void response(Object responseParam, int status, NRError error) {
                try {
                    ArrayList<NRFAQGroupItem> groups = new ArrayList<NRFAQGroupItem>();
                    if (responseParam instanceof HashMap) {
                        HashMap map = (HashMap)responseParam;
                        NRFAQGroupItem group = new NRFAQGroupItem(map);
                        groups.add(group);
                        if (!groups.isEmpty()) {
                            NRFetchedDataManager.this.mconfigFetcherListener.insertRows(groups);
                        } else {
                            Log.e((String)"labelError", (String)("no data for label " + label.getTitle()));
                        }
                    }
                }
                catch (ClassCastException e) {
                    Log.d((String)"ResponseError", (String)"Response cast error");
                }
            }

            public void log(String tag, String msg) {
            }
        });
    }

    private boolean duplicateFAQ(NRQueryResult nrQueryResult, ArrayList<NRQueryResult> answers) {
        for (NRQueryResult answer : answers) {
            if (!answer.getId().equals(nrQueryResult.getId())) continue;
            return true;
        }
        return false;
    }
}

