package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;

import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.R;

/**
 * Created by Oz on 7/23/2017.
 */

public class CheckBoxViewHolder
        extends RecyclerView.ViewHolder {

    public CheckBox checkBox;

    public interface SelectionHandler {
        void addSelection();

        void subtractSelection();
    }

    public CheckBoxViewHolder(View itemView, final FormFields formField, final SelectionHandler selectionHandler) {
        super(itemView);
        checkBox = itemView.findViewById(R.id.holder_checkbox);
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    formField.getSelectionOptions().get(getAdapterPosition()).setSelected(true);
                    selectionHandler.addSelection();
                } else {
                    formField.getSelectionOptions().get(getAdapterPosition()).setSelected(false);
                    selectionHandler.subtractSelection();
                }
            }
        });
    }
}
