package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

/**
 * Created by nissimpardo on 18/06/16.
 */
public class NRLikeViewText extends NRCustomLikeView  {

    private TextView mLikeButton;
    private TextView mDislikeButton;
    private TextView feedBackQuestion;
    private boolean mLikeSelection;

    private LinearLayout likeLayout;
    private LinearLayout dislikeLayout;

    public NRLikeViewText(Context context, SearchViewsProvider searchViewsProvider) {
        super(context);

        try {
            LayoutInflater.from(context).inflate(searchViewsProvider.getLikeViewLayout(), this);
        } catch (NullPointerException | InflateException e) {
            LayoutInflater.from(context).inflate(R.layout.like_view_text, this);
        }
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        resetLikeView();
        if (isLike) {
            mLikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_like_color));
            mDislikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_text_color));
        } else {
            mLikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_text_color));
            mDislikeButton.setTextColor(ContextCompat.getColor(getContext(), R.color.nr_dislike_color));
        }
        mLikeButton.setEnabled(false);
        mDislikeButton.setEnabled(false);
        mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        mLikeButton.setEnabled(true);
        mDislikeButton.setEnabled(true);
        mLikeButton.setTextColor(getResources().getColor(R.color.nr_text_color));
        mDislikeButton.setTextColor(getResources().getColor(R.color.nr_text_color));
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        feedBackQuestion = child.findViewById(R.id.likeText);
        mLikeButton = child.findViewById(R.id.likeButton);
        mDislikeButton = child.findViewById(R.id.dislikeButton);

        if (Nanorep.getInstance().getNRConfiguration() != null){
            String feedBackQuestionData = Nanorep.getInstance().getNRConfiguration().getFeedbackCustomiseText();
            if (feedBackQuestionData != null) {
                feedBackQuestion.setText(feedBackQuestionData);
            }
            String mLikeButtonData = Nanorep.getInstance().getNRConfiguration().getFeedbackPositiveButtonText();
            if (mLikeButtonData != null) {
                mLikeButton.setText(mLikeButtonData);
            }

            String mDislikeButtonData = Nanorep.getInstance().getNRConfiguration().getFeedbackNegativeButtonText();
            if (mDislikeButtonData != null) {
                mDislikeButton.setText(mDislikeButtonData);
            }
        }

        mLikeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(true);
            }
        });
        mDislikeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        mLikeSelection = selection;
        updateLikeButton(mLikeSelection);
        mListener.onLikeClicked(NRLikeViewText.this, null, mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        return Nanorep.getInstance().getNRConfiguration().getFeedbackDialogType() != NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;
    }
}