/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import nanorep.nanowidget.R;

public class SimpleDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    public static int PAGE_LABELS = 0;
    public static int PAGE_RESULTS = 1;
    private boolean disableDecoration = false;

    public SimpleDividerItemDecoration(Context context, Resources resources, int page) {
        this.mDivider = page == PAGE_LABELS ? ContextCompat.getDrawable((Context)context, (int)R.drawable.divider_labels) : ContextCompat.getDrawable((Context)context, (int)R.drawable.divider_results);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (parent.getItemAnimator() != null && parent.getItemAnimator().isRunning() || this.disableDecoration) {
            return;
        }
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin;
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void setDisableDecoration(boolean disableDecoration) {
        this.disableDecoration = disableDecoration;
    }
}

