package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;

import java.util.List;

import nanorep.nanowidget.Components.formSDK.Adapters.CheckBoxListAdapter;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.R;

/**
 * Created by Oz on 7/30/2017.
 */

public class CheckBoxListViewHolder
        extends FormFieldViewHolder
        implements CheckBoxViewHolder.SelectionHandler {

    private TextView checkBoxListTitle;
    private RecyclerView checkBoxListRecycler;
    private FormFields formField;
    private List<SelectionOptions> options;

    public CheckBoxListViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);

        checkBoxListTitle = itemView.findViewById(R.id.holder_checkbox_list_title);
        checkBoxListRecycler = itemView.findViewById(R.id.holder_checkbox_recycler_list);
        fieldDataLayout = itemView.findViewById(R.id.holder_checkbox_list_dataLayout);

        checkBoxListRecycler.setLayoutManager(new LinearLayoutManager(itemView.getContext()));
        checkBoxListRecycler.setHasFixedSize(true);
    }

    @Override
    public void bind() {
        formField = formFields.get(getAdapterPosition());

        if (formField.isRequired() && !formField.isChecked() && isSendClicked()) {
            checkBoxListTitle.requestFocus();
            setFieldError();
        }

        checkBoxListTitle.setText(formField.getFieldLabel());

        options = formField.getSelectionOptions();

        CheckBoxListAdapter adapter = new CheckBoxListAdapter(options, formField, this);

        checkBoxListRecycler.setAdapter(adapter);

        formField.setValid(true);
    }

    @Override
    public void handleUserInput(FormFields formField) {

    }

    @Override
    public void setFieldError() {
        checkBoxListTitle.setError(itemView.getResources().getString(R.string.check_boxlist_error_message));
    }

    @Override
    public View getErrorFieldPresenter() {
        return checkBoxListTitle;
    }

    @Override
    public void addSelection() {
        formField.setFieldChecked(true);
        formField.setValid(true);
        checkBoxListTitle.setError(null);
    }

    @Override
    public void subtractSelection() {
        for (SelectionOptions option : options)
            if (option.isSelected()) {
                return;
            }
        formField.setFieldChecked(false);
        formField.setValid(false);
    }
}

