/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

public class NRLikeViewText
extends NRCustomLikeView {
    private TextView mLikeButton;
    private TextView mDislikeButton;
    private TextView feedBackQuestion;
    private boolean mLikeSelection;

    public NRLikeViewText(Context context, SearchViewsProvider searchViewsProvider) {
        super(context, searchViewsProvider);
        try {
            LayoutInflater.from((Context)context).inflate(searchViewsProvider.getLikeViewLayout(), (ViewGroup)this);
        }
        catch (InflateException e) {
            Log.d((String)"InflateError", (String)"Custom Layout failed to be inflated");
            LayoutInflater.from((Context)context).inflate(R.layout.like_view_text, (ViewGroup)this);
        }
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        this.resetLikeView();
        if (isLike) {
            this.mLikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_like_color));
            this.mDislikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_text_color));
        } else {
            this.mLikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_text_color));
            this.mDislikeButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.nr_dislike_color));
        }
        this.mLikeButton.setEnabled(false);
        this.mDislikeButton.setEnabled(false);
        this.mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        this.mLikeButton.setEnabled(true);
        this.mDislikeButton.setEnabled(true);
        this.mLikeButton.setTextColor(this.getResources().getColor(R.color.nr_text_color));
        this.mDislikeButton.setTextColor(this.getResources().getColor(R.color.nr_text_color));
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.feedBackQuestion = (TextView)child.findViewById(R.id.likeText);
        this.mLikeButton = (TextView)child.findViewById(R.id.likeButton);
        this.mDislikeButton = (TextView)child.findViewById(R.id.dislikeButton);
        if (this.configuration != null) {
            String mDislikeButtonData;
            String mLikeButtonData;
            String feedBackQuestionData = this.configuration.getFeedbackCustomiseText();
            if (feedBackQuestionData != null) {
                this.feedBackQuestion.setText((CharSequence)feedBackQuestionData);
            }
            if ((mLikeButtonData = this.configuration.getFeedbackPositiveButtonText()) != null) {
                this.mLikeButton.setText((CharSequence)mLikeButtonData);
            }
            if ((mDislikeButtonData = this.configuration.getFeedbackNegativeButtonText()) != null) {
                this.mDislikeButton.setText((CharSequence)mDislikeButtonData);
            }
        }
        this.mLikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeViewText.this.sendSelection(true);
            }
        });
        this.mDislikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeViewText.this.sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        this.mLikeSelection = selection;
        this.updateLikeButton(this.mLikeSelection);
        this.mListener.onLikeClicked(this, null, this.mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return this.mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        if (this.configuration != null) {
            return this.configuration.getFeedbackDialogType() != -1;
        }
        return true;
    }
}

