package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.NRLabel;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.R;

/**
 * Created by Aviran Abady on 4/23/17.
 */

public class NRLabelsAdapter extends NRBaseAdapter<NRLabelsAdapter.ViewHolder> {

    private final NRLabelsListener listener;
    private int titleItemLabel;

    @Override
    public void setEnabledViewHolderClicks(boolean enable) {
        enableClicks = enable;
    }

    public interface NRLabelsListener {
        void onLabelSelected(NRLabel label);
    }

    private List<NRLabel> labels;

    public NRLabelsAdapter(NRLabelsListener listener, int titleItemLabel) {
        this.titleItemLabel = titleItemLabel;
        enableClicks = true;
        this.listener = listener;
        labels = Nanorep.getInstance().getNRConfiguration().getLabels();
        if (labels == null) {
            labels = new ArrayList<>();
        }
    }

    @Override
    public NRLabelsAdapter.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from(context).inflate(titleItemLabel, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        NRLabel label = labels.get(position);
        holder.textView.setText(label.getTitle());
        loadImage(holder.imageView, label.getIcon());
    }

    private void loadImage(final ImageView imageView, String url) {
        if(url == null || url.length() == 0) {
            return;
        }

        Nanorep.getInstance().getWidgetListener().onCachedImageRequest(url, new Nanorep.NRCachedImageResponder() {
            @Override
            public void onBitmapResponse(Bitmap bitmap) {
                if(bitmap != null) {
                    imageView.setImageBitmap(bitmap);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return labels.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        public ImageView imageView;
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener(this);
            textView = view.findViewById(R.id.titleTextView);
            imageView = view.findViewById(R.id.label_image);

        }

        @Override
        public void onClick(View v) {
            if (enableClicks) {
                enableClicks = false;
                listener.onLabelSelected(labels.get(getAdapterPosition()));
            }
        }
    }
}