package nanorep.nanowidget.Components.formSDK.Decorators;

import android.app.Activity;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.Window;

import nanorep.nanowidget.Components.formSDK.ViewHolders.AutoButtonsViewHolder;

/**
 * Created by Oz on 8/23/2017.
 */

public class AutoButtonsDecorator extends RecyclerView.ItemDecoration {

    private int viewHeight;
    private Activity activity;
    private Drawable divider;

    public AutoButtonsDecorator(Activity activity, Drawable divider) {
        viewHeight = 0;
        this.divider = divider;
        this.activity = activity;
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);

        if (parent.getChildViewHolder(view) instanceof AutoButtonsViewHolder && state.getItemCount() > 1) {

            int activityWindowHeight = activity.getWindow().findViewById(Window.ID_ANDROID_CONTENT).getHeight();
            View relativeView = parent.getChildAt(state.getItemCount() - 2);
            if (relativeView != null) {
                RecyclerView.LayoutParams relativeViewParams = (RecyclerView.LayoutParams) relativeView.getLayoutParams();
                viewHeight = view.getLayoutParams().height;

                if (activityWindowHeight - relativeView.getBottom() - relativeViewParams.bottomMargin - viewHeight >= 0) {
                    outRect.top = activityWindowHeight
                            - relativeView.getBottom()
                            - relativeViewParams.bottomMargin
                            - divider.getMinimumHeight()
                            - viewHeight;
                }
            }
        }
    }
}
