/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.List;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.SimpleDividerItemDecoration;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsView
extends BaseListView
implements NRResultsAdapter.Listener {
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private ProgressBar loadingView;
    private TextView faqTitle;
    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.results_view, (ViewGroup)this);
    }

    @Override
    public void enableAdapterClicks(boolean enable) {
        this.adapter.setEnabledViewHolderClicks(enable);
    }

    @Override
    public void setLoading(boolean loading) {
        this.loadingView.setVisibility(loading ? 0 : 4);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.adapter = new NRResultsAdapter();
        this.mResultsRecyclerView = (RecyclerView)child.findViewById(R.id.resultsListRecycler);
        this.faqTitle = (TextView)child.findViewById(R.id.faqTitle);
        this.mResultsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SimpleDividerItemDecoration(this.getContext(), this.getResources(), SimpleDividerItemDecoration.PAGE_RESULTS));
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.loadingView = (ProgressBar)child.findViewById(R.id.loading_view);
        this.faqTitle.setVisibility(0);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<NRResult> results, String title, NRCustomViewAdapter viewAdapter, int labelItemTitleLayout) {
        this.title = title;
        this.adapter.setTitleItemLabelView(labelItemTitleLayout);
        this.adapter.setListener(this);
        this.adapter.setViewAdapter(viewAdapter);
        this.adapter.addItems(results);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        this.listener.onResultSelected(0, titleViewHolder);
    }

    public static interface Listener {
        public void onResultSelected(int var1, NRResultsAdapter.ViewHolder var2);
    }
}

