/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.ChannelPresenters;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingCustomScript;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Nanorep;
import java.util.Map;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import org.json.JSONException;
import org.json.JSONObject;

public class NRCustomScriptChannelPresenter
implements NRChannelPresenter {
    private static String TAG = NRCustomScriptChannelPresenter.class.getName();
    private Context mContext;
    private NRChanneling mChanneling;
    private String to;
    private String subject;
    private Nanorep.ErrorListener errorListener;

    public NRCustomScriptChannelPresenter(Context context, Nanorep.ErrorListener errorListener) {
        this.mContext = context;
        this.errorListener = errorListener;
    }

    @Override
    public void present() {
        this.parseJson();
        Intent i = new Intent("android.intent.action.SEND");
        i.setType("message/rfc822");
        i.putExtra("android.intent.extra.EMAIL", new String[]{this.to});
        i.putExtra("android.intent.extra.SUBJECT", this.subject);
        try {
            this.mContext.startActivity(Intent.createChooser((Intent)i, (CharSequence)"Send mail..."));
        }
        catch (ActivityNotFoundException ex) {
            this.errorListener.onError(NRError.error((String)TAG, (int)6, (String)this.mContext.getString(R.string.email_error)));
        }
    }

    private void parseJson() {
        String jsonString = ((NRChannelingCustomScript)this.mChanneling).getScriptContent();
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Map map = NRUtilities.mapFromJson((JSONObject)jsonObject);
        this.subject = (String)map.get("title");
        this.to = (String)map.get("url");
    }

    @Override
    public void setChannel(NRChanneling channeling) {
        this.mChanneling = channeling;
    }

    @Override
    public NRResult getResult() {
        return null;
    }

    @Override
    public String getUrl() {
        return ((NRChannelingCustomScript)this.mChanneling).getScriptContent();
    }
}

