/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.ConnectivityReceiver;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.Components.formSDK.FormFragment;
import nanorep.nanowidget.DataClass.ContextSelectionAdapter;
import nanorep.nanowidget.DataClass.ContextSelectionHandler;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;
import org.jetbrains.annotations.NotNull;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRLabelsAdapter.NRLabelsListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRResultsView.Listener,
NRContentView.Listener,
NRChannelItem.OnChannelSelectedListener,
NRArticleView.Listener,
NRErrorHandler.Listener,
ConnectivityReceiver.ConnectivityListener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private ConnectivityReceiver connectivityReceiver = new ConnectivityReceiver();
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private RelativeLayout mLoadingView;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private boolean autocompleteEnabled = true;
    private boolean isFromSuggestion;
    private LinearLayout noConnectionView;
    private boolean animation = true;
    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private NRCustomLikeView likeView;
    private String articleId;
    private TextView searchContextTextView;
    private LinearLayout searchContextView;
    private String searchContextKey;
    private String searchContextValue;
    private NRLabel currentLabel;
    private TextView actionBarTextView;
    private boolean fragmentPaused;
    private NRChannelingView noResultsChannelingRecycler;
    private long previousClickTime;
    private NRConfiguration configuration;
    private NRResultsView resultsView;
    private AlertDialog contextSelectionDialog;
    private NRConfiguration.ConfirmationDialogsText confirmationDialogsText;
    private boolean connectionOk;
    private BaseListView currentView;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.connectivityReceiver.register(this.getContext(), (ConnectivityReceiver.ConnectivityListener)this);
    }

    @Override
    public void closeAnswer() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (this.animation) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        } else if (view instanceof NRArticleView && !((NRArticleView)view).getResult().isSingle()) {
            ((NRArticleView)view).setResultUnFoldState(false);
            ((NRArticleView)view).removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        NRQueryResult currentResult = this.getCurrentResult();
        final String predefinedExtraData = currentResult == null || currentResult.getExtraData() == null ? channel.getNoResultExtra() : this.getCurrentResult().getExtraData();
        this.widgetListener.personalInfoWithExtraData(channel.getChannelDescription(), predefinedExtraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData, predefinedExtraData);
                NRMainFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresenter presenter = NRChannelStrategy.presenter(this.getContext(), channeling, Nanorep.getInstance());
        if (presenter instanceof NRCustomScriptChannelPresenter) {
            presenter.present();
        } else {
            final FragmentManager fragmentManager = this.getFragmentManager();
            String url = presenter.getUrl();
            if (url != null && fragmentManager != null) {
                if (channeling.getType() == NRChanneling.NRChannelingType.ContactForm && TextUtils.isDigitsOnly((CharSequence)channeling.getContactForm()) && Build.VERSION.SDK_INT < 19) {
                    FormFragment fragment = FormFragment.newInstance(channeling, this.configuration.getConfirmationDialogsText(), (Nanorep.ErrorListener)this.widgetListener);
                    fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)fragment).addToBackStack("ContactForm").commit();
                } else {
                    View view = this.getView();
                    if (channeling.getType() == NRChanneling.NRChannelingType.ChatForm && view != null) {
                        RelativeLayout holder = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
                        holder.setVisibility(0);
                    }
                    NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, this.viewsProvider, this.widgetListener);
                    fragment.setConfirmationDialogsText(this.configuration.getConfirmationDialogsText());
                    fragment.setListener(new NRWebContentFragment.WebFormListener(){

                        @Override
                        public void onDismiss(String result) {
                            if (result == null) {
                                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)8, (String)NRMainFragment.this.getString(R.string.null_form_result)));
                            }
                            fragmentManager.popBackStack();
                            NRMainFragment.this.hideKeyboard();
                            NRMainFragment.this.requestFocus();
                        }
                    });
                    fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)fragment).addToBackStack("chatForm").commit();
                }
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                this.widgetListener.onChannel(NRChanneling.NRChannelingType.PhoneNumber, (Object)phoneNumber);
                String string2 = channeling.getName();
            }
        }
        Nanorep.getInstance().reportChanneling(this.getCurrentResult(), channeling);
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(NRMainFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(NRMainFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRArticleView resultTopView = NRMainFragment.this.getTopView();
                NRMainFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                NRMainFragment.this.requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

                @Override
                public void onDismiss() {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                    NRMainFragment.this.requestFocus();
                }
            });
            this.contentMain.addView((View)webView);
            this.requestFocus();
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onError(NRError error) {
        this.widgetListener.onError(error);
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    NRMainFragment.this.searchBarView.adaptSearchBarDisplay(false, "");
                    NRMainFragment.this.searchBarView.clearText();
                }

                public void onAnimationEnd(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            view.setAnimation(animation);
        }
        this.removeTopView();
    }

    @Override
    public void onLikeClicked(NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRQueryResult fetchedResult;
        NRResult result = view.getResult();
        if (result != null && (fetchedResult = result.getFetchedResult()) != null) {
            if (isLike) {
                fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                    public void onLikeSent(boolean success) {
                        Context context = NRMainFragment.this.getContext();
                        if (!success) {
                            fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                            likeView.resetLikeView();
                        } else if (context != null) {
                            likeView.onFeedbackSubmitted();
                        }
                    }
                });
            } else if (likeView.shouldOpenDialog()) {
                this.openDislikeDialog(fetchedResult, likeView);
            } else {
                this.onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                Context context = NRMainFragment.this.getContext();
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)5, (String)NRMainFragment.this.getString(R.string.feedback_error_message)));
                    NRMainFragment.this.removeTopView();
                } else if (context != null) {
                    likeView.onFeedbackSubmitted();
                }
            }
        });
    }

    private void onDismissDislike() {
        Nanorep.getInstance().updateDislikeChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                NRMainFragment.this.channelView.setVisibility(0);
                NRMainFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)(NRMainFragment.this.getString(R.string.update_channeling_error) + error.getData())));
                NRMainFragment.this.channelView.setVisibility(8);
            }
        });
    }

    private void openDislikeDialog(final NRQueryResult fetchedResult, final NRCustomLikeView likeView) {
        Context context;
        int dialogType = this.configuration.getFeedbackDialogType();
        if (dialogType != -1 && (context = this.getContext()) != null && this.getFragmentManager() != null) {
            NRCustomDislikeDialog dislikeDialog = this.viewsProvider.getDislikeDialog(new DislikeConfiguration(this.configuration){

                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener(){

                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            NRMainFragment.this.onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            NRMainFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                        }
                    };
                }
            });
            dislikeDialog.show(this.getFragmentManager(), "dislike");
        }
    }

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();
        SearchViewsProvider viewsProvider = injector.getUiProvider();
        fragment.setViewsProvider(viewsProvider == null ? new SearchInjector.DefaultsInjector().getUiProvider() : viewsProvider);
        return fragment;
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            @RequiresApi(api=21)
            public void onConfigurationReady() {
                View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    NRMainFragment.this.contentMain.removeView(view);
                }
                NRMainFragment.this.updateTitleNormalText();
                NRMainFragment.this.updateSearchBar();
                NRMainFragment.this.showSuggestionsView();
                NRMainFragment.this.mLoadingView.setVisibility(8);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                try {
                    if (groups != null && groups.size() > 1 || Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                        NRMainFragment.this.openCategoriesView(groups);
                    } else if (groups != null && groups.size() == 1) {
                        NRMainFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), NRMainFragment.this.getContext()), groups.get(0).getTitle());
                    }
                }
                catch (Exception e) {
                    return;
                }
            }

            @Override
            public void onError(NRError error) {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                if (error.getCode() == 1) {
                    NRErrorView errorView = new NRErrorView(NRMainFragment.this.getContext());
                    errorView.setListener(new NRErrorView.Listener(){

                        @Override
                        public void tryAgain() {
                            NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                            NRMainFragment.this.mLoadingView.setVisibility(0);
                        }
                    });
                    NRMainFragment.this.contentMain.addView((View)errorView);
                }
                NRMainFragment.this.widgetListener.onError(error);
            }

            @Override
            public void noResultFound(NRResult result, String searchContext) {
                ArrayList<NRResult> results = new ArrayList<NRResult>();
                results.add(result);
                NRMainFragment.this.mFetchedDataManager.getFetcherListener().insertRows(results, searchContext);
                if (NRMainFragment.this.searchContextValue == null) {
                    NRMainFragment.this.clearContextFromSession();
                }
            }

            @Override
            public void showContextSelectionDialog(ContextValue contextValues) {
                View contextSelectionDialogView = LayoutInflater.from((Context)NRMainFragment.this.getContext()).inflate(R.layout.context_selection_dialog, null);
                final TextView contextTitle = (TextView)contextSelectionDialogView.findViewById(R.id.context_selection_title);
                final Button cancelButton = (Button)contextSelectionDialogView.findViewById(R.id.cancelButton);
                RecyclerView recycler = (RecyclerView)contextSelectionDialogView.findViewById(R.id.context_selection_recycler);
                recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(contextSelectionDialogView.getContext()));
                recycler.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(contextSelectionDialogView.getContext(), 1));
                final ContextSelectionAdapter adapter = new ContextSelectionAdapter(contextValues);
                ContextSelectionHandler contextSelectionHandler = new ContextSelectionHandler(contextValues, new ContextSelectionHandler.ContextSelectionListener(){

                    @Override
                    public void updateContextData(@NotNull ContextValue contextValues) {
                        contextTitle.setText(R.string.dynamicContextTitle);
                        contextTitle.append((CharSequence)(" " + contextValues.getContextKey()));
                        adapter.setContextList(contextValues);
                        adapter.notifyDataSetChanged();
                    }

                    @Override
                    public void onContextSelected(@NonNull String searchContext) {
                        NRMainFragment.this.mFetchedDataManager.presentResultsForSelectedContext(searchContext);
                        NRMainFragment.this.contextSelectionDialog.dismiss();
                    }
                });
                adapter.setContextListener(contextSelectionHandler);
                recycler.setAdapter((RecyclerView.Adapter)adapter);
                cancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        NRMainFragment.this.clearContext();
                        NRMainFragment.this.resetSuggestions = true;
                        NRMainFragment.this.clearSuggestionsView();
                        NRMainFragment.this.contentMain.setVisibility(0);
                        NRMainFragment.this.contextSelectionDialog.dismiss();
                    }
                });
                contextTitle.setText(R.string.dynamicContextTitle);
                contextTitle.append((CharSequence)(" " + contextValues.getContextKey()));
                AlertDialog.Builder builder = new AlertDialog.Builder(contextSelectionDialogView.getContext());
                NRMainFragment.this.contextSelectionDialog = builder.setView(contextSelectionDialogView).create();
                NRMainFragment.this.contextSelectionDialog.setCanceledOnTouchOutside(false);
                NRMainFragment.this.contextSelectionDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {
                        if (keyCode == 4) {
                            cancelButton.callOnClick();
                            return true;
                        }
                        return true;
                    }
                });
                NRMainFragment.this.contextSelectionDialog.show();
            }
        });
        this.mFetchedDataManager.setFetcherListener(new NRFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<NRResult> results, final String searchContext) {
                if (NRMainFragment.this.isDetached() || NRMainFragment.this.getContext() == null) {
                    return;
                }
                NRMainFragment.this.hideKeyboard();
                NRMainFragment.this.clearSuggestionsView();
                NRMainFragment.this.updateContextView(searchContext);
                if (results == null || results.size() == 1 && results.get(0).getFetchedResult() == null) {
                    NRResult result;
                    if (NRMainFragment.this.searchBarView.getSearchQuery() != null) {
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                    }
                    if (results == null) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = results.get(0);
                    }
                    NRArticleView resultTopView = NRMainFragment.this.getTopView();
                    resultTopView.setVisibility(0);
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.contentMain.addView((View)resultTopView);
                    NRMainFragment.this.presentResult(result, 0, resultTopView);
                } else if (results.size() == 1) {
                    NRQueryResult fetchedResult;
                    NRResult currentResult = results.get(0);
                    if (currentResult != null && (fetchedResult = currentResult.getFetchedResult()) != null) {
                        NRMainFragment.this.articleId = fetchedResult.getId();
                        NRArticleView resultTopView = NRMainFragment.this.getTopView();
                        NRMainFragment.this.contentMain.setVisibility(0);
                        NRMainFragment.this.contentMain.addView((View)resultTopView);
                        Animation animation = AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_in_left);
                        animation.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                                NRMainFragment.this.updateLabelsParallel(fetchedResult.getTitle());
                                NRMainFragment.this.updateContextView(searchContext);
                            }

                            public void onAnimationEnd(Animation animation) {
                                NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1).setVisibility(0);
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }
                        });
                        resultTopView.setAnimation(animation);
                        resultTopView.startAnimation(animation);
                        NRResult result = results.get(0);
                        result.setSingle(true);
                        resultTopView.openOpenedView(result);
                        NRMainFragment.this.requestFocus();
                    }
                } else if (results.size() > 1) {
                    NRMainFragment.this.contentMain.setVisibility(0);
                    NRMainFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getSearchQuery().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.mSuggestionViewContainer.setVisibility(0);
                    NRMainFragment.this.contentMain.setVisibility(8);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
            }
        });
    }

    private void hideKeyboard() {
        InputMethodManager imm;
        View view = this.getView();
        if (view != null && (imm = (InputMethodManager)this.getActivity().getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onDestroyView() {
        Nanorep.getInstance().clearSession();
        this.connectivityReceiver.unregister(this.getContext());
        this.connectivityReceiver = null;
        super.onDestroyView();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.renewSession();
            this.fragmentPaused = false;
        }
    }

    private void renewSession() {
        if (Nanorep.getInstance().getSessionId() == null) {
            return;
        }
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {
        this.categoriesView = new NRCategoriesView((Context)this.getActivity(), this.viewsProvider.getResultsViewLayout());
        this.currentView = this.categoriesView;
        this.categoriesView.setLabelItemTitleView(this.viewsProvider.getLabelItemTitleLayout());
        if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {
            this.categoriesView.setLabels(this);
        } else {
            this.categoriesView.setCategories(groups, this.viewAdapter, this);
        }
        this.contentMain.addView((View)this.categoriesView);
    }

    private NRArticleView getTopView() {
        NRArticleView resultTopView = new NRArticleView((Context)this.getActivity(), this.viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitleView(this.getContext());
        if (titleView == null) {
            titleView = new NRArticleTitleView(this.getContext(), this.viewsProvider);
        }
        ((NRArticleTitleView)titleView).configViewObjects(this.configuration);
        NRCustomContentView contentView = this.viewAdapter.getContentView(this.getContext());
        if (contentView == null) {
            contentView = new NRContentView(this.getContext());
        }
        if (this.applicationContentListener != null) {
            contentView.setApplicationContentListener(this.applicationContentListener);
        }
        this.likeView = this.viewAdapter.getLikeView(this.getContext());
        if (this.likeView == null) {
            this.likeView = new NRLikeViewText(this.getContext(), this.viewsProvider);
        }
        this.channelView = this.viewAdapter.getChannelView(this.getContext());
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.getContext(), this.viewsProvider);
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(this.likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(this.likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.configuration = Nanorep.getInstance().getNRConfiguration();
        this.confirmationDialogsText = this.configuration.getConfirmationDialogsText();
        this.widgetListener = Nanorep.getInstance().getWidgetListener();
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        this.mLoadingView = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.noConnectionView);
        this.searchContextTextView = (TextView)view.findViewById(R.id.user_selected_context_textview);
        this.searchContextView = (LinearLayout)view.findViewById(R.id.current_user_selected_context_layout);
        this.noResultsChannelingRecycler = (NRChannelingView)view.findViewById(R.id.channelingView);
        Button clearContextButton = (Button)view.findViewById(R.id.clear_user_selected_button);
        clearContextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRMainFragment.this.removeAllTopLayers();
                NRMainFragment.this.categoriesView.enableAdapterClicks(true);
                NRMainFragment.this.clearContext();
            }
        });
        this.setViews(view);
        this.initDataManager();
        return view;
    }

    @Override
    public void onClearSearchText() {
        this.removeAllTopLayers();
        this.clearContext();
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        if (this.categoriesView != null) {
            this.categoriesView.enableAdapterClicks(true);
        }
        this.setLoadingState(false);
    }

    private void clearContext() {
        this.searchContextView.setVisibility(8);
        if (this.searchContextValue != null || this.currentLabel != null) {
            this.searchContextValue = null;
            this.currentLabel = null;
            this.mFetchedDataManager.clearSearchContext();
            this.clearContextFromSession();
        }
        this.clearSuggestionsView();
        this.contentMain.setVisibility(0);
    }

    private void deleteLastContext() {
        this.mFetchedDataManager.clearSearchContext();
        this.clearContextFromSession();
        this.clearSuggestionsView();
        Nanorep.getInstance().setContext(this.currentLabel.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                Log.d((String)"DeleteLastContext", (String)"Last Context deleted successfully");
            }

            public void onError(NRConnectionException error) {
                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)NRMainFragment.this.getString(R.string.delete_last_context_error)));
            }
        });
        this.searchContextValue = this.currentLabel.getContext();
    }

    private void clearContextFromSession() {
        Nanorep.getInstance().setContext(null, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                Log.d((String)"ClearContext", (String)"Context cleared successfully");
            }

            public void onError(NRConnectionException error) {
                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)NRMainFragment.this.getString(R.string.clear_context_error)));
            }
        });
    }

    private void removeAllTopLayers() {
        int viewLayers = this.contentMain.getChildCount() - 1;
        while (0 < viewLayers) {
            this.contentMain.removeViewAt(viewLayers--);
        }
        this.searchBarView.adaptSearchBarDisplay(false, null);
    }

    private void updateContextView(String updatedContext) {
        if (updatedContext == null || updatedContext.isEmpty()) {
            this.clearContext();
        } else {
            if (!updatedContext.equals(this.searchContextValue) || this.currentLabel != null) {
                StringBuilder builder = new StringBuilder();
                if (this.currentLabel != null && !this.currentLabel.getContext().equals(updatedContext)) {
                    updatedContext = this.currentLabel.getContext() + ',' + updatedContext;
                }
                for (String context : updatedContext.split(",")) {
                    String[] ctx = context.split(":");
                    if (ctx.length != 2) {
                        return;
                    }
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(ctx[1]);
                }
                this.searchContextValue = builder.toString();
            }
            this.searchContextTextView.setText((CharSequence)this.searchContextValue);
            this.searchContextView.setVisibility(0);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = this.configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = this.configuration.getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        String titleBGColor = !NRMainFragment.isEmpty(titleConfig.getTitleBGColor()) ? titleConfig.getTitleBGColor() : "#0aa0ff";
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = this.configuration.getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            this.actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = this.configuration.getTitleText();
            this.setActionBarTitleText(titleText);
            if (!NRMainFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                this.actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                this.actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.suggestion_view_container);
        this.mSuggestionsView = this.viewAdapter.getSuggestionsView(this.getContext());
        if (this.mSuggestionsView == null) {
            this.mSuggestionsView = new NRSuggestionsView(this.getContext());
        }
        this.mSuggestionsView.setListener(this);
        if (this.mSuggestionsView.getParent() != null) {
            ((LinearLayout)this.mSuggestionsView.getParent()).removeView((View)this.mSuggestionsView);
        }
        this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
        this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.search_bar_container);
        this.searchBarView = this.viewAdapter.getSearchBar(this.getContext());
        if (this.searchBarView == null) {
            this.searchBarView = new NRSearchBar(this.getContext(), this.viewsProvider.getSearchBarLayout());
        }
        this.searchBarView.setListener(this);
        if (this.searchBarView.getParent() != null) {
            ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
        }
        this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        this.clearSuggestionsView();
        this.contentMain.setVisibility(0);
    }

    @Override
    public void onTopBackButtonPressed() {
        BaseInputConnection inputConnection = new BaseInputConnection(this.getView(), true);
        inputConnection.sendKeyEvent(new KeyEvent(0, 4));
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        this.resetSuggestions = true;
        this.isFromSuggestion = true;
        this.hideKeyboard();
        this.searchBarView.updateText(suggestion);
        this.resetSuggestions = true;
        this.mFetchedDataManager.searchText(suggestion);
        this.clearSuggestionsView();
    }

    private void showSuggestionsView() {
        if (!this.configuration.getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.ViewHolder titleViewHolder) {
        if (this.isBouncing()) {
            return;
        }
        this.isFromSuggestion = false;
        this.setLoadingState(true);
        final NRArticleView resultTopView = this.getTopView();
        final NRResult result = titleViewHolder.getResult();
        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            this.mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        NRMainFragment.this.updateLabelsParallel(queryResult.getTitle());
                        resultTopView.setVisibility(8);
                        NRMainFragment.this.contentMain.addView((View)resultTopView);
                        result.setFetchedResult(queryResult);
                        NRMainFragment.this.presentResult(result, y, resultTopView);
                    } else {
                        NRMainFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(8);
            this.contentMain.addView((View)resultTopView);
            this.presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {
        String title;
        this.dismissConnectionError();
        if (this.getContext() == null) {
            return;
        }
        this.hideKeyboard();
        this.setLoadingState(false);
        if (result != null && result.getFetchedResult() != null) {
            result.setUnfolded(true);
            resultTopView.setVisibility(0);
            resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
            title = result.getFetchedResult().getTitle();
        } else {
            resultTopView.showNoResult(result);
            title = this.getResources().getString(R.string.noResultsTitle);
        }
        if (this.currentLabel != null && (result == null || result.getFetchedResult() != null && result.getFetchedResult().getTitle().isEmpty())) {
            title = this.currentLabel.getTitle();
        }
        this.updateLabelsParallel(title);
        this.requestFocus();
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.requestFocus();
        this.hideKeyboard();
        View.OnKeyListener onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0) {
                    if (keyCode == 4) {
                        FragmentManager fragmentManager;
                        if (NRMainFragment.this.contentMain.getChildCount() == 2) {
                            NRMainFragment.this.searchBarView.clearText();
                            NRMainFragment.this.searchBarView.adaptSearchBarDisplay(false, null);
                            NRMainFragment.this.clearContext();
                        }
                        if ((fragmentManager = NRMainFragment.this.getFragmentManager()) != null && fragmentManager.getBackStackEntryCount() == 1) {
                            fragmentManager.popBackStack();
                            return true;
                        }
                        if (NRMainFragment.this.mSuggestionViewContainer.getVisibility() == 0) {
                            NRMainFragment.this.resetSuggestions = true;
                            NRMainFragment.this.clearSuggestionsView();
                            NRMainFragment.this.contentMain.setVisibility(0);
                            return true;
                        }
                        if (NRMainFragment.this.contentMain.getChildCount() > 1) {
                            View view = NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                            if (NRMainFragment.this.animation) {
                                if (view instanceof NRArticleView) {
                                    if (NRMainFragment.this.currentLabel != null) {
                                        view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                        NRMainFragment.this.updateLabelsParallel(NRMainFragment.this.currentLabel.getTitle());
                                        NRMainFragment.this.searchContextView.setVisibility(8);
                                        if (NRMainFragment.this.currentLabel != null && NRMainFragment.this.isFromSuggestion && NRMainFragment.this.searchContextValue.split(",").length > 1) {
                                            NRMainFragment.this.deleteLastContext();
                                        }
                                    } else if (NRMainFragment.this.contentMain.getChildCount() > 2) {
                                        NRMainFragment.this.updateContextView(NRMainFragment.this.searchContextValue);
                                    } else {
                                        NRMainFragment.this.updateLabelsParallel("");
                                    }
                                } else if (view instanceof NRResultsView) {
                                    view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                    NRMainFragment.this.searchBarView.adaptSearchBarDisplay(false, null);
                                    NRMainFragment.this.searchBarView.clearText();
                                    NRMainFragment.this.searchContextView.setVisibility(8);
                                }
                                view.startAnimation(AnimationUtils.loadAnimation((Context)NRMainFragment.this.getContext(), (int)R.anim.slide_out_left));
                                NRMainFragment.this.removeTopView();
                            } else if (view instanceof NRArticleView) {
                                if (!((NRArticleView)view).getResult().isSingle()) {
                                    ((NRArticleView)view).setResultUnFoldState(false);
                                    ((NRArticleView)view).removeTopView();
                                    NRMainFragment.this.updateSearchBarTextForResultTop(view);
                                } else {
                                    NRMainFragment.this.removeTopView();
                                }
                            } else {
                                NRMainFragment.this.removeTopView();
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        };
        View view = this.getView();
        if (view != null) {
            view.setOnKeyListener(onKeyListener);
        }
    }

    private void removeTopView() {
        this.dismissConnectionError();
        if (this.contentMain != null) {
            int oldChildCount = this.contentMain.getChildCount();
            if (oldChildCount == 2 && this.currentLabel != null) {
                this.clearContext();
                this.currentLabel = null;
            }
            this.contentMain.removeViewAt(oldChildCount - 1);
            this.loadCurrentViewAfterRemoval();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (localCurrentView != null && localCurrentView instanceof NRArticleView) {
            this.updateSearchBarTextForResultTop(localCurrentView);
        } else {
            if (localCurrentView == null || !(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1) instanceof NRResultsView)) {
                this.searchBarView.clearText();
            }
            this.requestFocus();
            String title = this.configuration.getTitleText();
            if (localCurrentView instanceof NRResultsView) {
                if (!NRMainFragment.isEmpty(((NRResultsView)localCurrentView).getTitle())) {
                    title = ((NRResultsView)localCurrentView).getTitle();
                }
                this.resultsView.enableAdapterClicks(true);
                this.currentView = (NRResultsView)localCurrentView;
            }
            if (localCurrentView instanceof NRCategoriesView) {
                this.categoriesView.enableAdapterClicks(true);
                this.currentView = (NRCategoriesView)localCurrentView;
            }
            this.setActionBarTitleText(this.currentLabel == null ? title : this.currentLabel.getTitle());
        }
        this.setLoadingState(false);
        localCurrentView.setVisibility(0);
    }

    private void updateSearchBarTextForResultTop(View view) {
        NRResult result;
        NRArticleView articleView = (NRArticleView)view;
        if (articleView != null && (result = articleView.getResult()) != null && result.getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateText(result.getFetchedResult().getTitle());
            this.resetSuggestions = true;
            this.clearSuggestionsView();
            this.contentMain.setVisibility(0);
            this.requestFocus();
        }
    }

    private void clearSuggestionsView() {
        if (this.mSuggestionsView != null) {
            this.mSuggestionsView.setSuggestions(null);
        }
        if (this.mSuggestionViewContainer != null) {
            this.mSuggestionViewContainer.setVisibility(8);
        }
    }

    private void fadeViews(View view, float f, long duration, final boolean removeTopTitle) {
        view.animate().alpha(f).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (removeTopTitle) {
                    NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            this.animateBGColor(50, this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), false, null);
        } else {
            this.fadeViews(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1), 0.0f, 500L, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, NRResultsAdapter.ViewHolder titleViewHolder) {
        int colorFrom = this.getResources().getColor(R.color.nr_background_color);
        int colorTo = this.getResources().getColor(R.color.white);
        if (!unfold) {
            colorFrom = -1;
            colorTo = this.getResources().getColor(R.color.nr_background_color);
        }
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)milliseconds);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (unfold) {
                    // empty if block
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        if (unfold) {
            colorAnimation.setStartDelay(300L);
        }
        colorAnimation.start();
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                this.setLoadingState(true);
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                this.hideKeyboard();
            }
        }
    }

    public void dismissConnectionError() {
        this.setLoadingState(false);
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        this.currentLabel = label;
        this.searchBarView.clearText();
        Nanorep.getInstance().setContext(label.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                NRMainFragment.this.searchContextValue = label.getContext();
                NRMainFragment.this.mFetchedDataManager.fetchLabelFAQ(label);
            }

            public void onError(NRConnectionException error) {
                NRMainFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                NRMainFragment.this.widgetListener.onError(NRError.error((String)TAG, (int)1, (String)error.getMessage()));
            }
        });
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        long threshold = 300L;
        if (currentTime - this.previousClickTime < 300L) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {
        try {
            this.dismissConnectionError();
            this.hideKeyboard();
            this.setLoadingState(false);
            this.resultsView = new NRResultsView((Context)this.getActivity());
            this.currentView = this.resultsView;
            this.resultsView.setListener(this);
            int labelLayout = this.viewsProvider.getLabelItemTitleLayout();
            this.resultsView.setResults(results, title, this.viewAdapter, labelLayout);
            this.resultsView.setIsAnimated(this.animation);
            this.resultsView.enableAdapterClicks(true);
            if (!NRMainFragment.isEmpty(title)) {
                this.setActionBarTitleText(title);
            }
            this.contentMain.addView((View)this.resultsView);
            this.contentMain.setVisibility(0);
            Animation animation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_in_left);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    NRMainFragment.this.contentMain.getChildAt(NRMainFragment.this.contentMain.getChildCount() - 1).setVisibility(0);
                    if (NRMainFragment.this.currentLabel != null) {
                        NRMainFragment.this.updateLabelsParallel(NRMainFragment.this.currentLabel.getTitle());
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.resultsView.startAnimation(animation);
            this.contentMain.requestFocus();
            this.requestFocus();
        }
        catch (Exception e) {
            this.widgetListener.onError(NRError.error((String)TAG, (int)7, (String)this.getString(R.string.results_view_error)));
        }
    }

    private void setLoadingState(boolean state) {
        if (this.contentMain.getChildCount() == 0) {
            return;
        }
        this.currentView.setLoading(state);
    }

    public void updateLabelsParallel(String labelTitle) {
        if (labelTitle != null) {
            this.setActionBarTitleText(labelTitle);
        }
        this.searchBarView.adaptSearchBarDisplay(true, labelTitle);
    }

    public void connectionChanged(boolean isConnected) {
        this.connectionOk = isConnected;
        if (isConnected) {
            this.dismissConnectionError();
            this.currentView.enableAdapterClicks(true);
        } else {
            this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
        }
    }
}

