/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.SimpleDividerItemDecoration;
import nanorep.nanowidget.DataClass.NRBaseAdapter;
import nanorep.nanowidget.DataClass.NRCategoriesAdapter;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRCategoriesView
extends BaseListView {
    private RecyclerView mResultsRecyclerView;
    private ProgressBar loadingView;
    private TextView faqTitle;
    private NRBaseAdapter adapter = null;
    private int labelItemTitleView;

    @Override
    public void enableAdapterClicks(boolean enable) {
        this.adapter.setEnabledViewHolderClicks(enable);
    }

    @Override
    public void setLoading(boolean loading) {
        this.loadingView.setVisibility(loading ? 0 : 4);
    }

    public NRCategoriesView(Context context, int resultsView) {
        super(context);
        try {
            LayoutInflater.from((Context)context).inflate(resultsView, (ViewGroup)this);
        }
        catch (InflateException | NullPointerException e) {
            LayoutInflater.from((Context)context).inflate(R.layout.results_view, (ViewGroup)this);
        }
    }

    public void setLabelItemTitleView(int labelItemTitleView) {
        this.labelItemTitleView = labelItemTitleView;
    }

    public NRBaseAdapter getAdapter() {
        return this.adapter;
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.faqTitle = (TextView)child.findViewById(R.id.faqTitle);
        this.mResultsRecyclerView = (RecyclerView)child.findViewById(R.id.resultsListRecycler);
        this.mResultsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mResultsRecyclerView.setItemAnimator(null);
        this.mResultsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SimpleDividerItemDecoration(this.getContext(), this.getResources(), SimpleDividerItemDecoration.PAGE_LABELS));
        this.loadingView = (ProgressBar)child.findViewById(R.id.loading_view);
        this.faqTitle.setVisibility(8);
    }

    public void setCategories(ArrayList<NRFAQGroupItem> categories, NRCustomViewAdapter viewAdapter, Listener listener) {
        this.adapter = new NRCategoriesAdapter();
        ((NRCategoriesAdapter)this.adapter).setTitleItemLabelView(this.labelItemTitleView);
        ((NRCategoriesAdapter)this.adapter).setListener(listener);
        ((NRCategoriesAdapter)this.adapter).setViewAdapter(viewAdapter);
        ((NRCategoriesAdapter)this.adapter).addItems((List<NRFAQGroupItem>)categories);
        this.mResultsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SimpleDividerItemDecoration(this.getContext(), this.getResources(), SimpleDividerItemDecoration.PAGE_LABELS));
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public void setLabels(NRLabelsAdapter.NRLabelsListener listener) {
        this.adapter = new NRLabelsAdapter(listener, this.labelItemTitleView);
        this.mResultsRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public static interface Listener {
        public void onCategorySelected(NRFAQGroupItem var1);
    }
}

