package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.annotation.NonNull;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

/**
 * Created by nanorep on 28/09/2016.
 */

public class NRViewAdapter implements NRCustomViewAdapter {

    private SearchViewsProvider viewsProvider;

    public NRViewAdapter(@NonNull SearchViewsProvider viewsProvider){
        this.viewsProvider = viewsProvider;
    }

    @Override
    public NRCustomSearchBarView getSearchBar(Context context) {
        return viewsProvider.getSearchBarView(context);
    }

    @Override
    public NRCustomSuggestionsView getSuggestionsView(Context context) {
        return viewsProvider.getSuggestionsView(context);
    }

    @Override
    public NRCustomTitleView getTitleView (Context context) {
        return new NRArticleTitleView(context, viewsProvider);
    }

    @Override
    public NRCustomContentView getContentView(Context context) {
        return viewsProvider.getContentView(context);
    }

    @Override
    public NRCustomLikeView getLikeView(Context context) {
        return viewsProvider.getLikeView(context);
    }

    @Override
    public NRCustomChannelView getChannelView(Context context) {
        return viewsProvider.getChannelView(context);
    }

    @Override
    public NRCustomFeedbackView getFeedbackView(Context context) {
        return null;
    }
}
