package nanorep.nanowidget.Components.formSDK;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.ImageButton;
import android.widget.TimePicker;
import android.widget.Toast;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.formSDK.Adapters.FormAdapter;
import nanorep.nanowidget.Components.formSDK.Decorators.AutoButtonsDecorator;
import nanorep.nanowidget.Components.formSDK.Decorators.DividerItemDecorator;
import nanorep.nanowidget.Components.formSDK.Interactions.AdapterFragmentInteraction;
import nanorep.nanowidget.Components.formSDK.Interactions.FormInputDataRecyclerInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.PickerViewHolder;

import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.GetFormResponse;
import nanorep.nanowidget.Components.formSDK.model.NRForm;
import nanorep.nanowidget.Components.formSDK.model.NRFormInputData;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

/**
 * Created by Oz on 7/25/2017.
 */

public class FormFragment
        extends Fragment
        implements AdapterFragmentInteraction, FormInputDataRecyclerInteraction {

    private NRForm form;
    private List<NRFormStructure> nrFormStructure;
    private RecyclerView formRecyclerView;
    private FormAdapter adapter;
    private PickerViewHolder pickerViewHolder;
    private Drawable divider;
    private ArrayList <String> fileUploadPaths;
    private NRChanneling channel;
    private NRConfiguration.ConfirmationDialogsText confirmationDialogsText;
    private String url = "https://in1-1.nanorep.com/~gojek/api/channeling/v1/getForm?cb=";
    private int formID;
    private SearchViewsProvider viewsProvider;

    public static final String TAG = "FormFragment";
    private static final int FILE_REQUEST_CODE = 217;

    public static FormFragment newInstance(NRChanneling channel, NRConfiguration.ConfirmationDialogsText confirmationDialogsText) {
        FormFragment formFragment = new FormFragment();
        formFragment.channel = channel;
        formFragment.confirmationDialogsText = confirmationDialogsText;
        return formFragment;
    }

//    public static FormFragment newInstance(int formId, String channelConfirmationText, String channelConfirmationTitle, String channelConfirmationButton) {
//        FormFragment formFragment = new FormFragment();
//        Bundle args = new Bundle();
//        args.putInt(FORMID, formId);
//        args.putString(CHANNEL_CONFIRMATION_TEXT, channelConfirmationText);
//        args.putString(CHANNEL_CONFIRMATION_TITLE, channelConfirmationTitle);
//        args.putString(CHANNEL_CONFIRMATION_BUTTON, channelConfirmationButton);
//        formFragment.setArguments(args);
//        return formFragment;
//    }

    public FormFragment() {
    }


    @Nullable
    @Override
    public View onCreateView(final LayoutInflater inflater, @Nullable ViewGroup container, @Nullable final Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.form_fragment, container, false);

        ImageButton closeButton = rootView.findViewById(R.id.cancelButton);
        closeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                discardForm();
            }
        });

        fileUploadPaths = new ArrayList<>();

        if (channel != null) {
            formID = Integer.valueOf(channel.getContactForm());
        }

        if (formID > 0) {
            formRecyclerView = rootView.findViewById(R.id.form_recycler_view);

            divider = getContext().getResources().getDrawable(R.drawable.divider);

            form = new NRForm(this);

            getFormAndGenerateRecyclerView(url, formID);

            setRecyclerViewDecoration();
            return rootView;

        } else {
            Toast.makeText(getContext(), "Invalid form id", Toast.LENGTH_SHORT).show();
            getFragmentManager().popBackStack();
        }
        return null;
    }

    private void getFormAndGenerateRecyclerView(String url, int id) {


        Uri.Builder formUrl = new Uri.Builder();
        formUrl.scheme("https")
                .authority("in1-1.nanorep.com")
                .appendPath("~gojek")
                .appendPath("api")
                .appendPath("channeling")
                .appendPath("v1")
                .appendPath("getForm")
                .appendQueryParameter("cb","")
                .appendQueryParameter("contactFormId", String.valueOf(id));

        NRConnection.connection(formUrl, new OnDataResponse<GetFormResponse>() {

            @Override
            public void onSuccess(GetFormResponse response) {
                if (response.toString().isEmpty()
                                || response.getForms() == null
                                || response.getForms().size() == 0) {
                            Log.e("ServerResponseError", "The response doesn't contain a form");
                            getFragmentManager().popBackStack();
                            return;
                        }
                        nrFormStructure = response.getForms();
                        form.setNRformStructure(nrFormStructure.get(0));
                        adapter = new FormAdapter(form.getStructure().getFields(), FormFragment.this);
                        LinearLayoutManager manager = new LinearLayoutManager(getActivity().getApplicationContext());
                        formRecyclerView.setLayoutManager(manager);
                        formRecyclerView.setHasFixedSize(true);
                        formRecyclerView.setAdapter(adapter);
            }

            @Override
            public void onError(NRConnectionException error) {
                Toast.makeText(getContext(), "Invalid form id", Toast.LENGTH_SHORT).show();
                getFragmentManager().popBackStack();
            }
        });
    }

    private void setRecyclerViewDecoration() {

        RecyclerView.ItemDecoration dividerItemDecorator = new DividerItemDecorator(divider);
        formRecyclerView.addItemDecoration(dividerItemDecorator);

        RecyclerView.ItemDecoration autoButtonsDecorator = new AutoButtonsDecorator(getActivity(), divider);
        formRecyclerView.addItemDecoration(autoButtonsDecorator);
    }

    @Override
    public void selectFromPicker(int type, int adapterPosition, PickerViewHolder pickerViewHolder) {
        Calendar correctData = Calendar.getInstance();
        FormFields formField = form.getStructure().getFields().get(adapterPosition);
        if (formField.isDatePickerField()) {
            selectDateFromPicker(correctData, adapterPosition, pickerViewHolder);
        } else if (formField.isTimePickerField()) {
            selectTimeFromPicker(adapterPosition, pickerViewHolder);
        } else {
            selectFileFromPicker(pickerViewHolder);
        }
    }

    private void selectDateFromPicker(Calendar correctData, final int adapterPosition, final PickerViewHolder pickerViewHolder) {
        final FormFields formField = form.getStructure().getFields().get(adapterPosition);
        final int correctYear = correctData.get(Calendar.YEAR);
        final int correctMonth = correctData.get(Calendar.MONTH);
        final int correctDay = correctData.get(Calendar.DAY_OF_MONTH);
        DatePickerDialog pickerDialog = new DatePickerDialog(getContext(), new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                pickerViewHolder.getPickerTitleTextView().setError(null);

                formField.setTextPlaceholder(pickerViewHolder.getDateString(year, month, dayOfMonth));
                formField.setFieldChecked(true);
                formField.setValid(true);
                pickerViewHolder.handleUserInput(formField);

                pickerViewHolder.setPickedDataTextView(form.getStructure().getFields().get(adapterPosition).getTextPlaceholder());
                pickerViewHolder.getClearButton().setAlpha(0.5f);
            }
        }, correctYear, correctMonth, correctDay);
        pickerDialog.show();
    }

    private void selectTimeFromPicker(final int adapterPosition, final PickerViewHolder pickerViewHolder) {
        final FormFields formField = form.getStructure().getFields().get(adapterPosition);
        final int correctHour = 0;
        final int correctMinute = 0;
        final TimePickerDialog pickerDialog = new TimePickerDialog(getContext(), new TimePickerDialog.OnTimeSetListener() {
            @Override
            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                pickerViewHolder.getPickerTitleTextView().setError(null);

                formField.setTextPlaceholder(pickerViewHolder.getTimeString(hourOfDay, minute));
                formField.setFieldChecked(true);
                formField.setValid(true);
                pickerViewHolder.handleUserInput(formField);

                pickerViewHolder.setPickedDataTextView(form.getStructure().getFields().get(adapterPosition).getTextPlaceholder());
                pickerViewHolder.getClearButton().setAlpha(0.5f);
            }
        }, correctHour, correctMinute, true);
        pickerDialog.show();
    }

    public void selectFileFromPicker(PickerViewHolder pickerViewHolder) {
        this.pickerViewHolder = pickerViewHolder;
        Intent intent = new Intent(Intent. ACTION_GET_CONTENT);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        intent.setType("*/*");
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            startActivityForResult(intent, FILE_REQUEST_CODE, ActivityOptions.makeSceneTransitionAnimation(getActivity()).toBundle());
        } else {
            startActivityForResult(intent, FILE_REQUEST_CODE);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode,
                                 Intent resultData) {
        if (requestCode == FILE_REQUEST_CODE && resultCode == Activity.RESULT_OK) {
            if (resultData != null) {
                FormFields formField = form.getStructure().getFields().get(pickerViewHolder.getAdapterPosition());

                Uri uri = resultData.getData();
                pickerViewHolder.setFileUri(uri);
                fileUploadPaths.add(pickerViewHolder.getFilePath(getContext(), uri));
                formField.setFieldChecked(true);
                formField.setValid(true);
                pickerViewHolder.handleUserInput(formField);

                String fileName = pickerViewHolder.getFileName(uri);
                pickerViewHolder.setPickedDataTextView(fileName);
                pickerViewHolder.getClearButton().setAlpha(0.5f);
                pickerViewHolder.getPickerTitleTextView().setError(null);
            }
        }
    }

    @Override
    public void validateDataAndSendForm() {
        NRFormInputData nrFormInputData = form.getNRformInputData();
        nrFormInputData.integrateFieldsInputsToForm();
        if (nrFormInputData.formValidation()) {
            final String formInputData = nrFormInputData.formInputData();

            Context context = getContext();
            if (context != null && viewsProvider != null && viewsProvider.showChannelConfirmationDialogs(channel)) {
                confirmationDialogsText.setChannelConfirmationDialogBody(channel.getThankYouMessage());
                View view = LayoutInflater.from(context).inflate(viewsProvider.getConfirmationDialogsView(), null);
                ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(context, true, view, confirmationDialogsText);
                confirmationDialogFragment.setListener(new ConfirmationDialogFragment.OnOkClick() {
                    @Override
                    public void okClicked() {
                        Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(formInputData, fileUploadPaths);
                    }
                });
                confirmationDialogFragment.show();

            } else {
                Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(formInputData, fileUploadPaths);
            }
        }
    }

    @Override
    public void discardForm() {
        getFragmentManager().popBackStack();
    }

    @Override
    public void scrollToInvalidatedFieldAndSetError(int position) {
        if (formRecyclerView.findViewHolderForAdapterPosition(position) == null) {
            formRecyclerView.scrollToPosition(position);
        } else {
            ((FormFieldViewHolder) formRecyclerView.findViewHolderForAdapterPosition(position)).getErrorFieldPresenter().requestFocus();
            ((FormFieldViewHolder) formRecyclerView.findViewHolderForAdapterPosition(position)).setFieldError();
        }
    }

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }
}
