/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class DeepLinkFragment
extends Fragment
implements NRArticleView.Listener,
NRErrorHandler.Listener,
NRChannelItem.OnChannelSelectedListener,
NRContentView.Listener {
    private FrameLayout contentMain;
    private NRCustomViewAdapter viewAdapter;
    private NRFetchedDataManager mFetchedDataManager;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private NRConfiguration configuration;
    private NRConfiguration.ConfirmationDialogsText confirmationDialogsText;
    private LinearLayout noConnectionView;
    private NRCustomChannelView channelView;
    private String articleId;
    private static AccountParams accountParams;
    private Map<String, String> articleExtraData = new HashMap<String, String>();
    private SearchViewsProvider viewsProvider;
    private Nanorep nanorepInstance;
    private FragmentManager fragmentManager;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public void setArticleId(String articleId) {
        this.articleId = articleId;
    }

    public void setAccountParams(AccountParams accountParams) {
        DeepLinkFragment.accountParams = accountParams;
    }

    public void setmFetchedDataManager(NRFetchedDataManager mFetchedDataManager) {
        this.mFetchedDataManager = mFetchedDataManager;
    }

    public void setArticleExtraData(Map<String, String> extraData) {
        this.articleExtraData = extraData;
    }

    public void setWidgetListener(Nanorep.NanoRepWidgetListener widgetListener) {
        this.widgetListener = widgetListener;
    }

    public static DeepLinkFragment newInstance(String articleId, AccountParams accountParams, deepLinkingServicesProvider servicesProvider) {
        DeepLinkFragment fragment = new DeepLinkFragment();
        if (servicesProvider != null) {
            fragment.setViewsProvider(servicesProvider.getSearchViewsProvider());
            fragment.setWidgetListener(servicesProvider.getWidgetListener());
        }
        fragment.setAccountParams(accountParams);
        fragment.setArticleId(articleId);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_deeplink, container, false);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.noConnectionView);
        this.contentMain = (FrameLayout)view.findViewById(R.id.content_main);
        this.fragmentManager = this.getFragmentManager();
        if (this.viewsProvider == null) {
            this.viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
        }
        this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        if (!Nanorep.isInitialized()) {
            if (this.widgetListener == null) {
                this.initIndependentWidgetListener();
            }
            Nanorep.initialize((AccountParams)accountParams);
            this.nanorepInstance = Nanorep.getInstance();
            this.nanorepInstance.setHttpRequestTimeout(15);
            this.nanorepInstance.setWidgetListener(this.widgetListener);
        } else {
            this.nanorepInstance = Nanorep.getInstance();
            if (this.mFetchedDataManager == null) {
                this.initIndependentDataManager();
            }
            this.nanorepInstance.setWidgetListener(this.widgetListener);
            this.configuration = Nanorep.getInstance().getNRConfiguration();
            this.confirmationDialogsText = this.configuration.getConfirmationDialogsText();
            final NRArticleView resultTopView = this.getTopView();
            this.mFetchedDataManager.faqAnswer(this.articleId, null, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        NRResult deepLinkingResult = new NRResult(queryResult, null);
                        resultTopView.setResult(deepLinkingResult);
                        DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                        resultTopView.openOpenedView(deepLinkingResult);
                    } else {
                        Toast.makeText((Context)DeepLinkFragment.this.getContext(), (CharSequence)"ArticleID doesn't exists for the given account parameters", (int)0).show();
                    }
                }
            });
        }
        return view;
    }

    private void initIndependentWidgetListener() {
        this.widgetListener = new Nanorep.NanoRepWidgetListener(){

            public void personalInfoWithExtraData(String channelDescription, String extraData, NRExtraDataListener listener) {
                if (DeepLinkFragment.this.articleExtraData != null) {
                    listener.onExtraData(DeepLinkFragment.this.articleExtraData);
                }
            }

            public void onSubmitSupportForm(String formData, ArrayList<String> fileUploadPaths) {
                if (formData != null) {
                    Log.i((String)"formData", (String)formData);
                } else {
                    Log.e((String)"formSubmitError", (String)"the form result is null");
                }
                if (fileUploadPaths != null) {
                    Log.i((String)"filesToUpload", (String)fileUploadPaths.toString());
                } else {
                    Log.e((String)"filesToUploadError", (String)"fileUploadPaths is null");
                }
            }

            public void onConfigurationFetched() {
                if (DeepLinkFragment.this.mFetchedDataManager == null) {
                    DeepLinkFragment.this.initIndependentDataManager();
                }
                DeepLinkFragment.this.nanorepInstance = Nanorep.getInstance();
                DeepLinkFragment.this.configuration = DeepLinkFragment.this.nanorepInstance.getNRConfiguration();
                DeepLinkFragment.this.confirmationDialogsText = DeepLinkFragment.this.configuration.getConfirmationDialogsText();
                if (DeepLinkFragment.this.mFetchedDataManager == null) {
                    DeepLinkFragment.this.initIndependentDataManager();
                }
                final NRArticleView resultTopView = DeepLinkFragment.this.getTopView();
                DeepLinkFragment.this.mFetchedDataManager.faqAnswer(DeepLinkFragment.this.articleId, null, new OnFAQAnswerFetched(){

                    @Override
                    public void onAnswerFetched(NRQueryResult queryResult) {
                        if (queryResult != null) {
                            NRResult deepLinkingResult = new NRResult(queryResult, null);
                            resultTopView.setResult(deepLinkingResult);
                            DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                            resultTopView.openOpenedView(deepLinkingResult);
                        } else {
                            Toast.makeText((Context)DeepLinkFragment.this.getContext(), (CharSequence)"ArticleID doesn't exists for the given account parameters", (int)0).show();
                        }
                    }
                });
            }

            public void onCachedImageRequest(String url, Nanorep.NRCachedImageResponder responder) {
            }

            public void onInitializationFailure() {
            }

            public void onEmptyDataResponse() {
            }

            public void onChannel(NRChanneling.NRChannelingType channelingType, Object extraData) {
                switch (channelingType) {
                    case PhoneNumber: {
                        Intent intent = new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)((String)extraData), null));
                        intent.setFlags(0x10008000);
                        try {
                            DeepLinkFragment.this.startActivity(intent);
                            break;
                        }
                        catch (ActivityNotFoundException e) {
                            Log.d((String)"dialerError", (String)"Unable to start dialer");
                        }
                    }
                }
            }
        };
    }

    private NRArticleView getTopView() {
        NRArticleView resultTopView = new NRArticleView((Context)this.getActivity(), this.viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = this.viewAdapter.getTitleView(this.getContext());
        ((NRArticleTitleView)titleView).configViewObjects(this.configuration);
        NRCustomContentView contentView = this.viewAdapter.getContentView(this.getContext());
        NRCustomLikeView likeView = this.viewAdapter.getLikeView(this.getContext());
        if (likeView == null) {
            likeView = new NRLikeViewText(this.getContext(), this.viewsProvider);
        }
        this.channelView = this.viewAdapter.getChannelView(this.getContext());
        if (this.channelView == null) {
            this.channelView = new NRChannelingView(this.getContext(), this.viewsProvider);
        }
        NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(this.getContext());
        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);
        if (feedbackView != null) {
            feedbackView.setCustomChannelView(this.channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(this.channelView, this);
        }
        return resultTopView;
    }

    private void initIndependentDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
            }

            @Override
            public void onError() {
            }

            @Override
            public void noResultFound(NRResult response, String searchContext) {
            }

            @Override
            public void showContextSelectionDialog(ContextValue contextValues) {
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void closeAnswer() {
        NRArticleView articleView;
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView && !(articleView = (NRArticleView)view).getResult().isSingle()) {
            articleView.setResultUnFoldState(false);
            articleView.removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onLikeClicked(NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRQueryResult fetchedResult;
        NRResult result = view.getResult();
        if (result != null && (fetchedResult = result.getFetchedResult()) != null) {
            if (isLike) {
                fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                    public void onLikeSent(boolean success) {
                        if (!success) {
                            fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                            likeView.resetLikeView();
                        } else if (DeepLinkFragment.this.getActivity() != null) {
                            View view = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                            if (DeepLinkFragment.this.viewsProvider.showFeedbackConfirmationDialogs()) {
                                ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), false, view, DeepLinkFragment.this.confirmationDialogsText);
                                confirmationDialogFragment.show();
                            }
                        }
                    }
                });
            } else if (likeView.shouldOpenDialog()) {
                this.openDislikeDialog(fetchedResult, view, likeView);
            } else {
                this.onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void openDislikeDialog(final NRQueryResult fetchedResult, NRArticleView view, final NRCustomLikeView likeView) {
        int dialogType = this.configuration.getFeedbackDialogType();
        if (dialogType != -1) {
            NRCustomDislikeDialog dislikeDialog = this.viewsProvider.getDislikeDialog(new DislikeConfiguration(this.configuration){

                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener(){

                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            DeepLinkFragment.this.onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            DeepLinkFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                        }
                    };
                }
            });
            if (this.fragmentManager != null) {
                dislikeDialog.show(this.fragmentManager, NRCustomDislikeDialog.TAG);
            }
        }
    }

    private void onDismissDislike() {
        Nanorep.getInstance().updateDislikeChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = DeepLinkFragment.this.contentMain.getChildAt(DeepLinkFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                DeepLinkFragment.this.channelView.setVisibility(0);
                DeepLinkFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
                Log.e((String)"updateChanneling", (String)("error on updateChanneling: " + error.getData()));
                DeepLinkFragment.this.channelView.setVisibility(8);
            }
        });
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    Toast.makeText((Context)DeepLinkFragment.this.getContext(), (CharSequence)DeepLinkFragment.this.getResources().getString(R.string.feedback_error_message), (int)1).show();
                    DeepLinkFragment.this.removeTopView();
                } else if (DeepLinkFragment.this.getActivity() != null) {
                    View view = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), false, view, DeepLinkFragment.this.confirmationDialogsText);
                    confirmationDialogFragment.show();
                }
            }
        });
    }

    public void show(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
            }
        }
    }

    public void dismiss() {
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        NRQueryResult currentResult = this.getCurrentResult();
        final String predefinedExtraData = currentResult == null || currentResult.getExtraData() == null ? channel.getNoResultExtra() : this.getCurrentResult().getExtraData();
        this.widgetListener.personalInfoWithExtraData(channel.getChannelDescription(), predefinedExtraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData, predefinedExtraData);
                DeepLinkFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresenter presentor = NRChannelStrategy.presenter(this.getContext(), channeling, Nanorep.getInstance());
        if (presentor instanceof NRCustomScriptChannelPresenter) {
            presentor.present();
        } else {
            String url = presentor.getUrl();
            final View view = this.getView();
            if (url != null && view != null) {
                RelativeLayout holder = (RelativeLayout)view.findViewById(R.id.fragment_place_holder);
                holder.setVisibility(0);
                NRWebContentFragment webContentFragment = NRWebContentFragment.newInstance(url, channeling, this.viewsProvider, this.widgetListener);
                webContentFragment.setConfirmationDialogsText(this.confirmationDialogsText);
                webContentFragment.setListener(new NRWebContentFragment.WebFormListener(){

                    @Override
                    public void onDismiss(String result) {
                        InputMethodManager imm;
                        if (result == null) {
                            DeepLinkFragment.this.fragmentManager.popBackStack();
                        }
                        if ((imm = (InputMethodManager)view.getContext().getSystemService("input_method")) != null) {
                            imm.hideSoftInputFromWindow(DeepLinkFragment.this.getView().getWindowToken(), 0);
                            DeepLinkFragment.this.requestFocus();
                        }
                    }
                });
                this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(R.id.content_main, (Fragment)webContentFragment).addToBackStack("linked").commit();
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                this.widgetListener.onChannel(NRChanneling.NRChannelingType.PhoneNumber, (Object)phoneNumber);
                String string2 = channeling.getName();
            }
        }
        Nanorep.getInstance().reportChanneling(this.getCurrentResult(), channeling);
    }

    private void requestFocus() {
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(DeepLinkFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(DeepLinkFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRArticleView resultTopView = DeepLinkFragment.this.getTopView();
                DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)DeepLinkFragment.this.getContext(), (int)R.anim.slide_in_left));
                resultTopView.openOpenedView(newResult);
                DeepLinkFragment.this.requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(this.getContext(), url, new MyWebView.Listener(){

                @Override
                public void onDismiss() {
                    DeepLinkFragment.this.contentMain.removeViewAt(DeepLinkFragment.this.contentMain.getChildCount() - 1);
                    DeepLinkFragment.this.requestFocus();
                }
            });
            this.contentMain.addView((View)webView);
            this.requestFocus();
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception e) {
                Log.d((String)"StartActivityError", (String)"Unable to start activity");
            }
        }
    }

    @Override
    public void onDismiss() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_out_left));
        }
        this.removeTopView();
    }

    private void removeTopView() {
        this.contentMain.removeViewAt(this.contentMain.getChildCount() - 1);
    }

    public static interface deepLinkingServicesProvider {
        public Nanorep.NanoRepWidgetListener getWidgetListener();

        public SearchViewsProvider getSearchViewsProvider();
    }
}

