/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.model;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Interactions.FormInputDataRecyclerInteraction;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.NRForm;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NRFormInputData {
    private static String VALUES = "values";
    private static String POST_URL = "postUrl";
    private static String REDIRECT_PARAM = "redirectParam";
    private List<UserInput> userInputs = new ArrayList<UserInput>();
    private String postUrl = "http://example.com";
    private String redirectParam = null;
    private NRForm form;
    private JSONObject formUserInputs;
    private FormInputDataRecyclerInteraction setErrorOnFieldHandler;

    public NRFormInputData(NRForm form, FormInputDataRecyclerInteraction setErrorOnFieldHandler) {
        this.form = form;
        this.setErrorOnFieldHandler = setErrorOnFieldHandler;
    }

    public void integrateFieldsInputsToForm() {
        for (FormFields formField : this.form.getStructure().getFields()) {
            if (formField.getInputType() == 6 && formField.isChecked()) {
                String selectedCheckboxes = "";
                for (SelectionOptions option : formField.getSelectionOptions()) {
                    if (!option.isSelected()) continue;
                    selectedCheckboxes = selectedCheckboxes + option.getText() + ",";
                }
                this.userInputs.add(new UserInput(formField.getFieldLabel(), NRFormStructure.CHECK_BOX_LIST, selectedCheckboxes.substring(0, selectedCheckboxes.lastIndexOf(44)), NRFormStructure.GENERIC));
                continue;
            }
            this.userInputs.add(formField.getUserInputs());
        }
    }

    public boolean formValidation() {
        List<FormFields> formFields = this.form.getStructure().getFields();
        for (int i = 0; i < formFields.size(); ++i) {
            if (!formFields.get(i).isRequired() || formFields.get(i).isChecked() && formFields.get(i).isValid()) continue;
            this.setErrorOnFieldHandler.scrollToInvalidatedFieldAndSetError(i);
            return false;
        }
        return true;
    }

    public JSONObject generateFormUserInputsJSON() {
        this.formUserInputs = new JSONObject();
        Gson gson = new Gson();
        String listString = gson.toJson(this.form.getNRformInputData().userInputs, new TypeToken<ArrayList<UserInput>>(){}.getType());
        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray(listString);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            this.formUserInputs.put(VALUES, (Object)jsonArray);
            this.formUserInputs.put(POST_URL, (Object)this.postUrl);
            this.formUserInputs.put(REDIRECT_PARAM, (Object)String.valueOf(this.redirectParam));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.formUserInputs;
    }

    public String toString() {
        return this.userInputs.toString();
    }

    public String formInputData() {
        return this.generateFormUserInputsJSON().toString();
    }
}

