/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRSearchBarListener;

public class NRSearchBar
extends NRCustomSearchBarView
implements TextWatcher,
TextView.OnEditorActionListener {
    private final int searchIconResourceId = R.drawable.ic_search_black_24dp;
    private final int closeIconResourceId = R.drawable.ic_close_black_24dp;
    private NRSearchBarListener mListener;
    private ImageButton mSearchButton;
    private TextView labelName;
    private LinearLayout searchBarLayout;
    private LinearLayout labelLayout;
    private SearchViewsProvider viewsProvider;
    private String searchQuery;

    public NRSearchBar(Context context, int searchBarLayout) {
        super(context);
        LayoutInflater.from((Context)context).inflate(searchBarLayout, (ViewGroup)this);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.searchBarLayout = (LinearLayout)child.findViewById(R.id.searchBarLayout);
        this.mSearchEditText = (EditText)child.findViewById(R.id.searchText);
        this.labelLayout = (LinearLayout)child.findViewById(R.id.labelLayout);
        this.labelName = (TextView)child.findViewById(R.id.search_bar_label_name_textView);
        this.mSearchEditText.addTextChangedListener((TextWatcher)this);
        this.mSearchEditText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mSearchButton = (ImageButton)child.findViewById(R.id.searchButton);
        this.mSearchButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (NRSearchBar.this.mSearchEditText.getText().length() > 0) {
                    NRSearchBar.this.mSearchButton.setImageResource(NRSearchBar.this.searchIconResourceId);
                    NRSearchBar.this.clear();
                }
            }
        });
        this.mSearchEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 1 && keyCode == 4) {
                    NRSearchBar.this.clear();
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void setListener(NRSearchBarListener listener) {
        this.mListener = listener;
    }

    private int resId(String resName) {
        return this.getResources().getIdentifier(resName, "drawable", this.getContext().getPackageName());
    }

    @Override
    public void updateText(String text) {
        this.mSearchEditText.clearFocus();
        this.mSearchEditText.setText((CharSequence)text);
    }

    @Override
    public void clearText() {
        this.updateText("");
    }

    @Override
    public void adaptSearchBarDisplay(boolean displayLabel, String labelTitle) {
        if (displayLabel && !this.viewsProvider.isSearchBarAlwaysOnTop() && labelTitle != null && !labelTitle.isEmpty()) {
            this.searchBarLayout.setVisibility(8);
            this.labelName.setText((CharSequence)labelTitle);
            this.labelLayout.setVisibility(0);
        } else {
            this.labelLayout.setVisibility(8);
            if (this.searchQuery != null && !this.searchQuery.isEmpty()) {
                this.mSearchEditText.setText((CharSequence)this.searchQuery);
            }
            this.searchBarLayout.setVisibility(0);
        }
    }

    @Override
    public void setHint(String text) {
        this.mSearchEditText.setHint((CharSequence)text);
    }

    @Override
    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public String getText() {
        this.searchQuery = this.mSearchEditText.getText().toString();
        return this.searchQuery;
    }

    private void clear() {
        this.mSearchEditText.clearFocus();
        this.hideKeyboard();
        this.updateText("");
        this.searchQuery = "";
        this.mListener.onClearSearchText(true);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        boolean isSequenceEmpty = charSequence == null || charSequence.length() == 0;
        this.mSearchButton.setImageResource(!isSequenceEmpty ? this.closeIconResourceId : this.searchIconResourceId);
        if (isSequenceEmpty) {
            this.hideKeyboard();
            this.mListener.clearAutoComplete();
        }
    }

    public void afterTextChanged(Editable editable) {
        if (editable != null && editable.length() > 0) {
            this.mListener.fetchSuggestionsForText(this.mSearchEditText.getText().toString());
        } else {
            this.mListener.onEmptyQuery();
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 3) {
            this.mListener.searchForText(this.mSearchEditText.getText().toString());
            this.hideKeyboard();
            return true;
        }
        return false;
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        this.searchBarLayout.setBackgroundColor(-1);
    }
}

