/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.StaticLayout;
import android.util.Log;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.Response.NRConfiguration;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

public class NRArticleTitleView
extends NRCustomTitleView {
    private TextView mTitleView;
    private ImageButton mUnFoldButton;
    private ImageButton mShareButton;
    private LinearLayout titleLayout;
    private Context context;
    private String textColorAnswer = "#0aa0ff";
    private String textColorFaq = "#4a4a4a";
    private String textFontAnswer = "sans-serif-medium";
    private String textFontFaq = "sans-serif-light";
    private boolean closed = true;

    public NRArticleTitleView(Context context, @NonNull SearchViewsProvider viewsProvider) {
        super(context);
        this.context = context;
        try {
            LayoutInflater.from((Context)context).inflate(viewsProvider.getArticleTitleLayout(), (ViewGroup)this);
        }
        catch (InflateException e) {
            Log.d((String)"InflateError", (String)"Custom Layout failed to be inflated");
            LayoutInflater.from((Context)context).inflate(R.layout.article_title, (ViewGroup)this);
        }
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.titleLayout = (LinearLayout)child.findViewById(R.id.titleLayout);
        this.mTitleView = (TextView)child.findViewById(R.id.titleTextView);
        this.mUnFoldButton = (ImageButton)child.findViewById(R.id.unFoldButton);
        this.mUnFoldButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRArticleTitleView.this.mListener.onTitleClicked();
            }
        });
        this.mShareButton = (ImageButton)child.findViewById(R.id.shareButton);
        this.mShareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRArticleTitleView.this.mListener.onShareClicked();
            }
        });
    }

    private void setUnfoldButtonImage() {
        if (this.mUnFoldButton != null) {
            if (!this.closed) {
                this.mUnFoldButton.setVisibility(4);
            } else {
                this.mUnFoldButton.setVisibility(0);
            }
        }
    }

    @Override
    public void setTitleText(String text) {
        this.mTitleView.setText((CharSequence)text);
        this.mTitleView.setMaxLines(2);
    }

    @Override
    public void unfold(boolean closed) {
        this.closed = !closed;
        this.setTitleColor();
        this.setTitleFont();
        this.setUnfoldButtonImage();
        this.setShareImage();
        if (!this.closed) {
            this.collapseTextView(100, 1000L);
            this.mListener.onTitleCollapsed(this.getCollapsedHeight(this.mTitleView.getText()));
        } else {
            this.collapseTextView(2, 100L);
        }
    }

    private void setTitleFont() {
        String font = this.textFontFaq;
        if (!this.closed) {
            font = this.textFontAnswer;
        }
        this.mTitleView.setTypeface(Typeface.create((String)font, (int)0));
    }

    private void setShareImage() {
        if (this.closed) {
            this.mShareButton.setVisibility(8);
        }
    }

    private void setTitleColor() {
        String color = this.textColorFaq;
        if (!this.closed) {
            color = this.textColorAnswer;
        }
        if (!color.startsWith("#")) {
            color = "#" + color;
        }
        this.mTitleView.setTextColor(Color.parseColor((String)color));
    }

    @Override
    public int getTitleHeight(String text) {
        return this.titleLayout.getHeight();
    }

    @Override
    public void resetView() {
    }

    private void collapseTextView(int lines, long duration) {
        ObjectAnimator animation = ObjectAnimator.ofInt((Object)this.mTitleView, (String)"maxLines", (int[])new int[]{lines});
        animation.setDuration(duration).start();
        animation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (NRArticleTitleView.this.closed) {
                    NRArticleTitleView.this.mListener.onTitleCollapsed(NRArticleTitleView.this.mTitleView.getHeight());
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public int getCollapsedHeight(CharSequence text) {
        int mMeasuredHeight = new StaticLayout(text, this.mTitleView.getPaint(), this.mTitleView.getWidth(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true).getHeight();
        if (mMeasuredHeight < this.mTitleView.getHeight()) {
            mMeasuredHeight = this.mTitleView.getHeight();
        }
        return mMeasuredHeight;
    }

    public void configViewObjects(NRConfiguration nrConfiguration) {
        NRConfiguration.NRContent content = nrConfiguration.getContent();
        if (content.getAnswerTitleColor() != null && !"".equals(content.getAnswerTitleColor())) {
            this.textColorAnswer = content.getAnswerTitleColor();
        }
        if (content.getAnswerTextFont() != null && !"".equals(content.getAnswerTextFont())) {
            this.textFontAnswer = content.getAnswerTitleFont();
        }
    }

    @Override
    public void setTitleMaxLines(int lines) {
        this.mTitleView.setMaxLines(lines);
    }
}

