package nanorep.nanowidget.Components;

import android.support.v7.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;

import android.view.View;
import android.widget.TextView;

import nanorep.nanowidget.R;

/**
 * Created by obenoved on 9 Jan 2018.
 */

public class ConfirmationDialogFragment extends AlertDialog.Builder {

    private TextView confirmationTextView;
    private TextView titleTextView;
    private OnOkClick mListener;
    private AlertDialog alert;

    public interface OnOkClick {
        void okClicked();
    }

    public ConfirmationDialogFragment(Context context, final View confirmationView, String confirmationBody, String confirmationButton, String confirmationTitle){
        super(context);
        setView(confirmationView);

        titleTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_title);
        confirmationTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_text);

        titleTextView.setText(confirmationTitle);
        confirmationTextView.setText(confirmationBody);

        setPositiveButton(confirmationButton, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                alert.dismiss();
            }
        });
        alert = create();

        alert.setCanceledOnTouchOutside(false);

        alert.show();
    }

    public ConfirmationDialogFragment(Context context, final View confirmationView, String confirmationBody, String confirmationButton, String confirmationTitle, final OnOkClick listener) {
        super(context);
        setView(confirmationView);

        mListener = listener;

        titleTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_title);
        confirmationTextView = confirmationView.findViewById(R.id.fragment_dialog_confirm_text);

        titleTextView.setText(confirmationTitle);
        confirmationTextView.setText(confirmationBody);

        setPositiveButton(confirmationButton, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                mListener.okClicked();
                alert.dismiss();

            }
        });
        alert = create();

        alert.setCanceledOnTouchOutside(false);

        alert.show();
    }
}
