/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

public class SpinnerViewHolder
extends FormFieldViewHolder {
    private Spinner spinner;
    private TextView fieldTitle;
    private TextView selectedItemText;
    private int selectedPosition;

    public SpinnerViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);
        this.fieldTitle = (TextView)itemView.findViewById(R.id.holder_field_title);
        this.spinner = (Spinner)itemView.findViewById(R.id.holder_spinner);
        this.fieldDataLayout = (LinearLayout)itemView.findViewById(R.id.holder_spinner_dataLayout);
    }

    @Override
    public void bind() {
        final FormFields formField = (FormFields)this.formFields.get(this.getAdapterPosition());
        final List<SelectionOptions> options = formField.getSelectionOptions();
        if (formField.isRequired() && !formField.isChecked() && this.isSendClicked()) {
            this.fieldTitle.requestFocus();
            this.setFieldError();
        }
        if (String.valueOf(options.get(0)).contains("Please select")) {
            options.remove(0);
            options.add(0, new SelectionOptions());
        }
        ArrayAdapter spinnerArrayAdapter = new ArrayAdapter(this.itemView.getContext(), R.layout.form_simple_spinner_item, this.getSelectionOptionsStrings(options));
        this.spinner.setAdapter((SpinnerAdapter)spinnerArrayAdapter);
        this.spinner.setSelection(this.selectedPosition);
        if (formField.isRequired()) {
            this.fieldTitle.setText((CharSequence)this.redStarEnding(formField.getFieldLabel()));
        } else {
            this.fieldTitle.setText((CharSequence)formField.getFieldLabel());
        }
        this.spinner.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        });
        this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                SpinnerViewHolder.this.selectedItemText = (TextView)view;
                if (SpinnerViewHolder.this.selectedItemText.getText().length() > 0) {
                    SpinnerViewHolder.this.selectedPosition = position;
                    SpinnerViewHolder.this.selectedItemText.setTextColor(SpinnerViewHolder.this.itemView.getResources().getColor(R.color.blue_background));
                    for (int i = 0; i < options.size(); ++i) {
                        if (i == position) continue;
                        formField.getSelectionOptions().get(i).setSelected(false);
                    }
                    ((SelectionOptions)options.get(position)).setSelected(true);
                    formField.setFieldChecked(true);
                    formField.setValid(true);
                    SpinnerViewHolder.this.fieldTitle.setError(null);
                } else {
                    formField.setFieldChecked(false);
                }
                SpinnerViewHolder.this.handleUserInput(formField);
            }

            public void onNothingSelected(AdapterView<?> parent) {
                if (SpinnerViewHolder.this.selectedItemText.getText().length() == 0) {
                    formField.setFieldChecked(false);
                }
            }
        });
    }

    private List<String> getSelectionOptionsStrings(List<SelectionOptions> options) {
        ArrayList<String> stringsList = new ArrayList<String>();
        for (SelectionOptions option : options) {
            stringsList.add(option.getText());
        }
        return stringsList;
    }

    @Override
    public void handleUserInput(FormFields formField) {
        String name = null;
        if (formField.getInputType() == 5) {
            name = NRFormStructure.RADIO_LIST;
        } else if (formField.getInputType() == 2) {
            name = NRFormStructure.SELECT_BOX;
        }
        formField.setUserInput(new UserInput(formField.getFieldLabel(), name, this.selectedItemText.getText().toString(), NRFormStructure.GENERIC));
    }

    @Override
    public void setFieldError() {
        this.fieldTitle.setError((CharSequence)this.itemView.getResources().getString(R.string.SpinnerErrorMessage));
        this.fieldTitle.requestFocus();
    }

    @Override
    public View getErrorFieldPresenter() {
        return this.fieldTitle;
    }
}

