/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.nanorep.nanoclient.Handlers.UriToPathHandler;
import java.util.Calendar;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

public class PickerViewHolder
extends FormFieldViewHolder
implements View.OnClickListener {
    private TextView pickerTitleTextView;
    private TextView pickerDataTextView;
    private ImageView pickerIcon;
    private Calendar correctDataFromCalender;
    private Uri fileUri;
    private FormFields formField;
    private ImageButton clearButton;

    public PickerViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);
        this.pickerTitleTextView = (TextView)itemView.findViewById(R.id.holder_picker_title);
        this.pickerDataTextView = (TextView)itemView.findViewById(R.id.holder_picker_data_textview);
        this.pickerIcon = (ImageView)itemView.findViewById(R.id.holder_picker_imageView);
        ViewGroup pickerLayout = (ViewGroup)itemView.findViewById(R.id.holder_picker_layout);
        this.fieldDataLayout = (ViewGroup)itemView.findViewById(R.id.holder_picker_dataLayout);
        this.clearButton = (ImageButton)itemView.findViewById(R.id.holder_picker_clear_button);
        this.correctDataFromCalender = Calendar.getInstance();
        pickerLayout.setOnClickListener((View.OnClickListener)this);
        this.clearButton.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void bind() {
        this.formField = (FormFields)this.formFields.get(this.getAdapterPosition());
        if (this.formField.isRequired() && !this.formField.isChecked() && this.isSendClicked()) {
            this.pickerTitleTextView.requestFocus();
            this.setFieldError();
        }
        this.pickerTitleGenerator();
        this.pickerIconSelector();
        this.setInitialHint();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.holder_picker_layout) {
            this.formViewHolderAdapterInteraction.selectFromPickerAndUpdateView(this.getAdapterPosition(), this);
        } else {
            this.pickerDataTextView.setText((CharSequence)"");
            this.setInitialHint();
            this.clearButton.setAlpha(0.0f);
            this.formField.setFieldChecked(false);
        }
    }

    private void pickerTitleGenerator() {
        String fieldLabel = this.formField.getFieldLabel();
        String title = this.formField.isDatePickerField() ? fieldLabel.substring(0, fieldLabel.indexOf(89)) : (this.formField.isTimePickerField() ? fieldLabel.substring(0, fieldLabel.indexOf(72)) : fieldLabel);
        if (title.indexOf("(") > 0) {
            title = title.replace("(", "");
        }
        if (this.formField.isRequired()) {
            this.pickerTitleTextView.setText((CharSequence)this.redStarEnding(title));
        } else {
            this.pickerTitleTextView.setText((CharSequence)title);
        }
    }

    private void pickerIconSelector() {
        if (this.formField.isDatePickerField()) {
            this.pickerIcon.setImageResource(R.drawable.ic_date_range_black_24dp);
        } else if (this.formField.isTimePickerField()) {
            this.pickerIcon.setImageResource(R.drawable.ic_access_time_black_24dp);
        } else {
            this.pickerIcon.setImageResource(R.drawable.ic_attach_file_black_24dp);
        }
    }

    private void setInitialHint() {
        if (this.formField.isDatePickerField()) {
            this.pickerDataTextView.setHint((CharSequence)this.getDateString(this.correctDataFromCalender.get(1), this.correctDataFromCalender.get(2), this.correctDataFromCalender.get(5)));
        } else if (this.formField.isTimePickerField()) {
            this.pickerDataTextView.setHint((CharSequence)this.getTimeString(this.correctDataFromCalender.get(11), this.correctDataFromCalender.get(12)));
        } else {
            this.pickerDataTextView.setHint(R.string.pickerFileHint);
        }
    }

    @Override
    public void handleUserInput(FormFields formField) {
        if (formField.isDatePickerField() || formField.isTimePickerField()) {
            String additionalFieldTypeData = formField.isDatePickerField() ? "1" : "2";
            formField.setUserInput(new UserInput(formField.getFieldLabel(), NRFormStructure.GENERAL + additionalFieldTypeData, this.pickerDataTextView.getText().toString(), NRFormStructure.GENERAL));
        } else {
            String fileNameInput = String.valueOf("0 - " + this.getFileName(this.fileUri));
            formField.setUserInput(new UserInput(formField.getFieldLabel(), fileNameInput, "{}", NRFormStructure.ATTACHMENT));
        }
    }

    @Override
    public void setFieldError() {
        this.pickerTitleTextView.setError((CharSequence)this.pickerErrorMessage());
    }

    @Override
    public View getErrorFieldPresenter() {
        return this.pickerTitleTextView;
    }

    private String pickerErrorMessage() {
        if (this.formField.isTimePickerField()) {
            return this.itemView.getContext().getString(R.string.TimeErrorMessage);
        }
        if (this.formField.isDatePickerField()) {
            return this.itemView.getContext().getString(R.string.DataErrorMessage);
        }
        return this.itemView.getContext().getString(R.string.FileErrorMessage);
    }

    public String getTimeString(int hourOfDay, int minute) {
        return (hourOfDay < 10 ? "0" + hourOfDay : Integer.valueOf(hourOfDay)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
    }

    public String getDateString(int year, int month, int dayOfMonth) {
        return year + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-" + (dayOfMonth < 10 ? "0" + dayOfMonth : Integer.valueOf(dayOfMonth));
    }

    public void setPickedDataTextView(String pickedData) {
        this.pickerDataTextView.setText((CharSequence)pickedData);
    }

    public void setFileUri(Uri fileUri) {
        this.fileUri = fileUri;
    }

    public TextView getPickerTitleTextView() {
        return this.pickerTitleTextView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName(Uri uri) {
        String fileName = null;
        Cursor cursor = this.itemView.getContext().getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    int nameReference = cursor.getColumnIndex("_display_name");
                    fileName = cursor.getString(nameReference);
                }
            }
            finally {
                cursor.close();
            }
        }
        return fileName;
    }

    public String getFilePath(Context context, Uri uri) {
        return UriToPathHandler.generateFilePathFromUri((Context)context, (Uri)uri);
    }

    public TextView getFieldStaticTitle() {
        return this.pickerTitleTextView;
    }

    public Uri getFileUri() {
        return this.fileUri;
    }

    public void setPickerTitleTextView(TextView pickerTitleTextView) {
        this.pickerTitleTextView = pickerTitleTextView;
    }

    public FormViewHolderAdapterInteraction getFormViewHolderAdapterInteraction() {
        return this.formViewHolderAdapterInteraction;
    }

    public void setFormViewHolderAdapterInteraction(FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        this.formViewHolderAdapterInteraction = formViewHolderAdapterInteraction;
    }

    public FormFields getFormField() {
        return this.formField;
    }

    public void setFormField(FormFields formField) {
        this.formField = formField;
    }

    public Calendar getCorrectDataFromCalender() {
        return this.correctDataFromCalender;
    }

    public void setCorrectDataFromCalender(Calendar correctDataFromCalender) {
        this.correctDataFromCalender = correctDataFromCalender;
    }

    public ImageButton getClearButton() {
        return this.clearButton;
    }
}

