/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Adapters.CheckBoxListAdapter;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.CheckBoxViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.SelectionOptions;
import nanorep.nanowidget.R;

public class CheckBoxListViewHolder
extends FormFieldViewHolder
implements CheckBoxViewHolder.SelectionHandler {
    private TextView checkBoxListTitle;
    private RecyclerView checkBoxListRecycler;
    private FormFields formField;
    private List<SelectionOptions> options;

    public CheckBoxListViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);
        this.checkBoxListTitle = (TextView)itemView.findViewById(R.id.holder_checkbox_list_title);
        this.checkBoxListRecycler = (RecyclerView)itemView.findViewById(R.id.holder_checkbox_recycler_list);
        this.fieldDataLayout = (ViewGroup)itemView.findViewById(R.id.holder_checkbox_list_dataLayout);
        this.checkBoxListRecycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(itemView.getContext()));
        this.checkBoxListRecycler.setHasFixedSize(true);
    }

    @Override
    public void bind() {
        this.formField = (FormFields)this.formFields.get(this.getAdapterPosition());
        if (this.formField.isRequired() && !this.formField.isChecked() && this.isSendClicked()) {
            this.checkBoxListTitle.requestFocus();
            this.setFieldError();
        }
        this.checkBoxListTitle.setText((CharSequence)this.formField.getFieldLabel());
        this.options = this.formField.getSelectionOptions();
        CheckBoxListAdapter adapter = new CheckBoxListAdapter(this.options, this.formField, this);
        this.checkBoxListRecycler.setAdapter((RecyclerView.Adapter)adapter);
        this.formField.setValid(true);
    }

    @Override
    public void handleUserInput(FormFields formField) {
    }

    @Override
    public void setFieldError() {
        this.checkBoxListTitle.setError((CharSequence)this.itemView.getResources().getString(R.string.CheckBoxListErrorMessage));
    }

    @Override
    public View getErrorFieldPresenter() {
        return this.checkBoxListTitle;
    }

    @Override
    public void addSelection() {
        this.formField.setFieldChecked(true);
        this.formField.setValid(true);
        this.checkBoxListTitle.setError(null);
    }

    @Override
    public void subtractSelection() {
        for (SelectionOptions option : this.options) {
            if (!option.isSelected()) continue;
            return;
        }
        this.formField.setFieldChecked(false);
        this.formField.setValid(false);
    }
}

