/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class SeparatorDecoration
extends RecyclerView.ItemDecoration {
    private final Paint mPaint = new Paint();
    private final int mAlpha;

    public SeparatorDecoration(@ColorInt int color2, float width) {
        this.mPaint.setColor(color2);
        this.mPaint.setStrokeWidth(width);
        this.mAlpha = this.mPaint.getAlpha();
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int position = params.getViewAdapterPosition();
        outRect.set(0, 0, 0, (int)this.mPaint.getStrokeWidth());
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int offset = (int)(this.mPaint.getStrokeWidth() / 2.0f);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View view = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
            int position = params.getViewAdapterPosition();
            if (position >= state.getItemCount()) continue;
            this.mPaint.setAlpha((int)(view.getAlpha() * (float)this.mAlpha));
            float positionY = (float)(view.getBottom() + offset) + view.getTranslationY();
            c.drawLine((float)view.getLeft() + view.getTranslationX(), positionY, (float)view.getRight() + view.getTranslationX(), positionY, this.mPaint);
        }
    }
}

