/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import nanorep.nanowidget.Components.AbstractViews.ViewIdsFactory;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.R;

public class NRDislikeDialog
extends NRCustomDislikeDialog
implements View.OnClickListener {
    private boolean isDismissHandled;
    private String feedbackText;
    private NRLikeType mSelection = NRLikeType.MISSING_INFORMATION;

    public static NRDislikeDialog newInstance(DislikeConfiguration dislikeConfiguration, ViewIdsFactory viewIdsFactory) {
        NRDislikeDialog fragment = new NRDislikeDialog();
        fragment.setConfiguration(dislikeConfiguration);
        fragment.setDislikeViewId(viewIdsFactory.getLayoutId());
        fragment.setDislikeViewsProducer(viewIdsFactory.getIDProducer());
        return fragment;
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        Window window = dialog.getWindow();
        if (window != null) {
            window.setSoftInputMode(16);
            window.setLayout(-1, -2);
            if (this.dialogGravity != 0) {
                window.setGravity(this.dialogGravity);
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        try {
            view = inflater.inflate(this.dislikeViewId, container, false);
        }
        catch (InflateException | NullPointerException e) {
            view = inflater.inflate(R.layout.dislike_dialog_mixed, container, false);
        }
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TextView dialogTitle = (TextView)view.findViewById(this.idProducer.getTitleId());
        this.feedbackEditText = (EditText)view.findViewById(this.idProducer.getFeedbackEditTextId());
        RadioGroup feedbackChoicesRadio = (RadioGroup)view.findViewById(this.idProducer.getRadioId());
        this.cancelButton = (Button)view.findViewById(this.idProducer.getCancelButtonId());
        this.okButton = (Button)view.findViewById(this.idProducer.getSubmitButtonId());
        this.okButton.setText((CharSequence)this.dislikeConfiguration.getSubmitButtonText());
        dialogTitle.setText((CharSequence)this.dislikeConfiguration.getTitle());
        if (this.feedbackDialogType != 2 && this.dislikeConfiguration.getDialogOptions() != null && this.dislikeConfiguration.getDialogOptions().size() > 1) {
            RadioButton firstRadioOption = (RadioButton)view.findViewById(this.idProducer.getFirstRadioButtonId());
            firstRadioOption.setText((CharSequence)this.dislikeConfiguration.getFirstOptionText());
            RadioButton secondRadioOption = (RadioButton)view.findViewById(this.idProducer.getSecondRadioButtonId());
            secondRadioOption.setText((CharSequence)this.dislikeConfiguration.getSecondOptionText());
            if (this.feedbackDialogType == 1) {
                this.feedbackEditText.setVisibility(8);
            }
            feedbackChoicesRadio.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

                public void onCheckedChanged(RadioGroup group, @IdRes int checkedId) {
                    if (checkedId == NRDislikeDialog.this.idProducer.getFirstRadioButtonId()) {
                        NRDislikeDialog.this.mSelection = NRLikeType.MISSING_INFORMATION;
                    } else {
                        NRDislikeDialog.this.mSelection = NRLikeType.INCORRECT_ANSWER;
                    }
                }
            });
        } else if (this.feedbackDialogType == 2) {
            feedbackChoicesRadio.setVisibility(8);
            this.mSelection = NRLikeType.INCORRECT_ANSWER;
        } else {
            this.dismiss();
            return;
        }
        this.cancelButton.setOnClickListener((View.OnClickListener)this);
        this.okButton.setOnClickListener((View.OnClickListener)this);
    }

    public void onDismiss(DialogInterface dialogInterface) {
        this.hideKeyboard();
        if (!this.isDismissHandled) {
            this.dislikeDialogListener.onCancel();
        }
    }

    public void onClick(View view) {
        this.hideKeyboard();
        if (view.getId() == this.okButton.getId()) {
            this.isDismissHandled = true;
            if (this.feedbackDialogType == 2 || this.feedbackDialogType == 0) {
                this.feedbackText = this.feedbackEditText.getText().toString();
            }
            this.dislikeDialogListener.onDislike(this.mSelection, this.feedbackText);
            this.dismiss();
        } else {
            this.isDismissHandled = true;
            this.dislikeDialogListener.onCancel();
            this.dismiss();
        }
    }

    private void hideKeyboard() {
        View view = this.getView();
        if (view != null) {
            view.clearFocus();
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }
}

