package nanorep.nanowidget.Components;

import android.content.Context;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

/**
 * Created by nanorep on 28/09/2016.
 */

public class NRViewAdapter implements NRCustomViewAdapter {

    private SearchViewsProvider viewsProvider;

    public NRViewAdapter(SearchViewsProvider viewsProvider){
        this.viewsProvider = viewsProvider;

    }

    @Override
    public NRCustomSearchBarView getSearchBar(Context context) {
        if(viewsProvider != null) {
            return viewsProvider.getSearchBarView(context);
        }
        return new NRSearchBar(context);
    }

    @Override
    public NRCustomSuggestionsView getSuggestionsView(Context context) {
        if(viewsProvider != null) {
            return viewsProvider.getSuggestionsView(context);
        }
        return new NRSuggestionsView(context);
    }

    @Override
    public NRCustomTitleView getTitleView (Context context) {
//        if (viewsProvider != null) {
//            return viewsProvider.getTitleView(context, viewsProvider);
//        }
        return new NRArticleTitleView(context, viewsProvider);
    }

    @Override
    public NRCustomContentView getContentView(Context context) {
        if(viewsProvider != null) {
            return viewsProvider.getContentView(context);
        }
        return new NRContentView(context);
    }

    @Override
    public NRCustomLikeView getLikeView(Context context) {
        if (viewsProvider != null) {
            return viewsProvider.getLikeView(context);
        }
        return new NRLikeViewText(context, null);
    }

    @Override
    public NRCustomChannelView getChannelView(Context context) {
        if (viewsProvider != null) {
            return viewsProvider.getChannelView(context);
        } return new NRChannelingView(context, null);
    }

    @Override
    public NRCustomFeedbackView getFeedbackView(Context context) {
        return null;
    }
}
