/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.nanorep.nanoclient.Nanorep;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

public class NRLikeViewIcons
extends NRCustomLikeView {
    private ImageButton mLikeButton;
    private ImageButton mDislikeButton;
    private boolean mLikeSelection;

    public NRLikeViewIcons(Context context, SearchViewsProvider searchViewsProvider) {
        super(context);
        try {
            LayoutInflater.from((Context)context).inflate(searchViewsProvider.getLikeViewLayout(), (ViewGroup)this);
        }
        catch (InflateException | NullPointerException e) {
            LayoutInflater.from((Context)context).inflate(R.layout.like_view_icons, (ViewGroup)this);
        }
    }

    @Override
    public void updateLikeButton(boolean isLike) {
        this.resetLikeView();
        if (isLike) {
            this.mLikeButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.like));
            this.mLikeButton.setSelected(true);
        } else {
            this.mDislikeButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.dislike));
            this.mDislikeButton.setSelected(true);
        }
        this.mDislikeButton.setEnabled(false);
        this.mLikeButton.setEnabled(false);
        this.mLikeSelection = isLike;
    }

    @Override
    public void resetLikeView() {
        this.mDislikeButton.setEnabled(true);
        this.mLikeButton.setEnabled(true);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mLikeButton = (ImageButton)this.findViewById(R.id.fragment_article_positiveFeedback_button);
        this.mDislikeButton = (ImageButton)this.findViewById(R.id.fragment_article_negativeFeedback_button);
        this.mLikeButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.like));
        this.mDislikeButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.dislike));
        this.mLikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeViewIcons.this.sendSelection(true);
            }
        });
        this.mDislikeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NRLikeViewIcons.this.sendSelection(false);
            }
        });
    }

    private void sendSelection(boolean selection) {
        this.mLikeSelection = selection;
        this.updateLikeButton(this.mLikeSelection);
        this.mListener.onLikeClicked(this, null, this.mLikeSelection);
    }

    @Override
    public boolean getLikeSelection() {
        return this.mLikeSelection;
    }

    @Override
    public boolean shouldOpenDialog() {
        return Nanorep.getInstance().getNRConfiguration().getFeedbackDialogType() != -1;
    }
}

