package nanorep.nanowidget.Components.formSDK.Adapters;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import nanorep.nanowidget.Components.formSDK.Interactions.AdapterFragmentInteraction;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.AutoButtonsViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.CheckBoxListViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.EditTextViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.PickerViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.SpinnerViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.TextViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.R;

import org.json.JSONException;

import java.util.List;

import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.AUTO_BUTTONS;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.CHECKBOX_LIST;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.FILE_UPLOAD;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.LABEL_ITEM;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.RADIO_LIST;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.SELECT_BOX;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.TEXT_BOX;
import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.TIME;


/**
 * Created by Oz on 7/25/2017.
 */

public class FormAdapter
        extends RecyclerView.Adapter<FormFieldViewHolder>
        implements AutoButtonsViewHolder.ButtonClicked, FormViewHolderAdapterInteraction {

    private List<FormFields> formFields;
    private RecyclerView recyclerView;
    private AdapterFragmentInteraction adapterFragmentInteraction;

    public FormAdapter(List<FormFields> formFields, AdapterFragmentInteraction adapterFragmentInteraction) {
        this.formFields = formFields;
        this.adapterFragmentInteraction = adapterFragmentInteraction;
    }

    private final int ANDROID_EDIT_TEXT = 0;
    private final int ANDROID_BUTTONS = 1;
    private final int ANDROID_SPINNER = 2;
    private final int ANDROID_TEXT_VIEW = 3;
    private final int ANDROID_PICKER = 4;
    private final int ANDROID_CHECKBOX_LIST = 5;
    private final int ANDROID_FILE_UPLOAD = 6;

    @Override
    public FormFieldViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        View view;

        switch (viewType) {
            case ANDROID_EDIT_TEXT:
                view = inflater.inflate(R.layout.form_view_holder_edittext, parent, false);
                return new EditTextViewHolder(view, formFields, this);
            case ANDROID_BUTTONS:
                view = inflater.inflate(R.layout.form_view_holder_auto_buttons, parent, false);
                return new AutoButtonsViewHolder(view, formFields, this);
            case ANDROID_SPINNER:
                view = inflater.inflate(R.layout.form_view_holder_spinner, parent, false);
                return new SpinnerViewHolder(view, formFields, this);
            case ANDROID_TEXT_VIEW:
                view = inflater.inflate(R.layout.form_view_holder_textview, parent, false);
                return new TextViewHolder(view, formFields);
            case ANDROID_PICKER:
                view = inflater.inflate(R.layout.form_view_holder_picker, parent, false);
                return new PickerViewHolder(view, formFields, this);
            case ANDROID_FILE_UPLOAD:
                view = inflater.inflate(R.layout.form_view_holder_picker, parent, false);
                return new PickerViewHolder(view, formFields, this);
            case ANDROID_CHECKBOX_LIST:
                view = inflater.inflate(R.layout.form_view_holder_checkbox_list, parent, false);
                return new CheckBoxListViewHolder(view, formFields, this);
        }
        return null;
    }

    @Override
    public int getItemViewType(int position) {
        FormFields formField = formFields.get(position);
        switch (formField.getInputType()) {
            case TEXT_BOX:
                if (formField.isDatePickerField() ||
                        formField.isTimePickerField() ||
                        formField.isFilePickerField()) {
                    return ANDROID_PICKER;
                }
                return ANDROID_EDIT_TEXT;
            case AUTO_BUTTONS:
                return ANDROID_BUTTONS;
            case SELECT_BOX:
            case RADIO_LIST:
                return ANDROID_SPINNER;
            case LABEL_ITEM:
                return ANDROID_TEXT_VIEW;
            case CHECKBOX_LIST:
                return ANDROID_CHECKBOX_LIST;
            case FILE_UPLOAD:
                return ANDROID_FILE_UPLOAD;
        }
        return -1;
    }

    @Override
    public void onBindViewHolder(FormFieldViewHolder holder, int position) {
        holder.bind();
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    @Override
    public int getItemCount() {
        return formFields.size();
    }

    @Override
    public void selectFromPickerAndUpdateView(int adapterPosition, PickerViewHolder pickerViewHolder) {
        adapterFragmentInteraction.selectFromPicker(TIME, adapterPosition, pickerViewHolder);
    }

    @Override
    public void onNextClicked(int position) {
        RecyclerView.ViewHolder nextViewHolder = recyclerView.findViewHolderForAdapterPosition(position + 1);
        if (nextViewHolder instanceof EditTextViewHolder) {
            nextViewHolder.itemView.requestFocus();
        }
    }

    @Override
    public void yesButtonClicked() throws JSONException {
        recyclerView.clearFocus();
        adapterFragmentInteraction.validateDataAndSendForm();
    }

    @Override
    public void noButtonClicked() {
        adapterFragmentInteraction.discardForm();
    }
}



