package nanorep.nanowidget.Components.AbstractViews.dislikeDialog;

import android.view.View;

import com.nanorep.nanoclient.Response.NRConfiguration;

import java.util.List;

import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.interfaces.DislikeDialogListener;

/**
 * Created by obenoved on 12/03/2018.
 */

public abstract class DislikeConfiguration {
    NRConfiguration configuration;

    public DislikeConfiguration (NRConfiguration configuration) {
        this.configuration = configuration;
    }

    public abstract DislikeDialogListener getDislikeDialogListener();

    public int getFeedbackDialogType() {
        return configuration.getFeedbackDialogType();
    }

    public String getTitle() {
        return configuration.getFeedbackDialogTitle();
    }

    public String getFirstOptionText() {
        return configuration.getFeedbackOptions().get(0);
    }


    public String getSecondOptionText() {
        return configuration.getFeedbackOptions().get(1);
    }

    public String getSubmitButtonText() {
        return configuration.getFeedbackDialogSubmitButtonText();
    }

    public List<String> getDialogOptions() {
        return configuration.getFeedbackOptions();
    }
}
