/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.DataClass;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import java.util.ArrayList;
import java.util.List;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.CRUDAdapterInterface;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

public class NRResultsAdapter
extends RecyclerView.Adapter<ViewHolder>
implements CRUDAdapterInterface<NRResult> {
    private ArrayList<NRResult> results = new ArrayList();
    private NRCustomViewAdapter viewAdapter;
    private Listener listener;
    private boolean enableClicks = false;
    private int titleItemLabel;

    public void setEnabledViewHolderClicks(boolean enableClicks) {
        this.enableClicks = enableClicks;
    }

    public void setTitleItemLabelView(int titleItemLabelView) {
        this.titleItemLabel = titleItemLabelView;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.titleItemLabel, parent, false);
        view.findViewById(R.id.label_image).setVisibility(8);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        NRResult result = this.getItem(position);
        holder.setResult(result);
        holder.textView.setText((CharSequence)result.getFetchedResult().getTitle());
        int resId = Nanorep.getInstance().getAccountParams().getChevronResourceId();
        if (resId != 0) {
            holder.chevronImageView.setImageResource(resId);
        }
    }

    public int getItemCount() {
        return this.results.size();
    }

    @Override
    public NRResult getItem(int position) {
        return this.results.get(position);
    }

    @Override
    public void addItem(NRResult item) {
    }

    @Override
    public void removeItem(NRResult item) {
    }

    @Override
    public void addItems(List<NRResult> items) {
        if (items == null) {
            return;
        }
        this.results.addAll(items);
        this.notifyDataSetChanged();
    }

    @Override
    public void clearList() {
    }

    @Override
    public void updateItem(int pos, NRResult item) {
    }

    @Override
    public void showItem(NRResult result, int itemPosition) {
    }

    @Override
    public List<NRResult> getItems() {
        return null;
    }

    @Override
    public void removeItem(int currentItemPosition) {
    }

    public void setViewAdapter(NRCustomViewAdapter viewAdapter) {
        this.viewAdapter = viewAdapter;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private TextView textView;
        private NRResult result;
        private ImageView chevronImageView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener((View.OnClickListener)this);
            this.textView = (TextView)view.findViewById(R.id.titleTextView);
            this.chevronImageView = (ImageView)view.findViewById(R.id.unFoldButton);
        }

        public void onClick(View v) {
            if (NRResultsAdapter.this.enableClicks) {
                NRResultsAdapter.this.enableClicks = false;
                NRResultsAdapter.this.listener.onResultItemSelected(this, this.getAdapterPosition());
            }
        }

        public NRResult getResult() {
            return this.result;
        }

        public void setResult(NRResult result) {
            this.result = result;
        }
    }

    public static interface Listener {
        public void onResultItemSelected(ViewHolder var1, int var2);
    }
}

